/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.InboundEndpointProtocol;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class InboundEndpoint
implements JsonSerializable<InboundEndpoint> {
    private final String name;
    private final InboundEndpointProtocol protocol;
    private final String publicIpAddress;
    private final String publicFQDN;
    private final int frontendPort;
    private final int backendPort;

    private InboundEndpoint(String name, InboundEndpointProtocol protocol, String publicIpAddress, String publicFQDN, int frontendPort, int backendPort) {
        this.name = name;
        this.protocol = protocol;
        this.publicIpAddress = publicIpAddress;
        this.publicFQDN = publicFQDN;
        this.frontendPort = frontendPort;
        this.backendPort = backendPort;
    }

    public String getName() {
        return this.name;
    }

    public InboundEndpointProtocol getProtocol() {
        return this.protocol;
    }

    public String getPublicIpAddress() {
        return this.publicIpAddress;
    }

    public String getPublicFQDN() {
        return this.publicFQDN;
    }

    public int getFrontendPort() {
        return this.frontendPort;
    }

    public int getBackendPort() {
        return this.backendPort;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("protocol", this.protocol == null ? null : this.protocol.toString());
        jsonWriter.writeStringField("publicIPAddress", this.publicIpAddress);
        jsonWriter.writeStringField("publicFQDN", this.publicFQDN);
        jsonWriter.writeIntField("frontendPort", this.frontendPort);
        jsonWriter.writeIntField("backendPort", this.backendPort);
        return jsonWriter.writeEndObject();
    }

    public static InboundEndpoint fromJson(JsonReader jsonReader) throws IOException {
        return (InboundEndpoint)jsonReader.readObject(reader -> {
            String name = null;
            InboundEndpointProtocol protocol = null;
            String publicIpAddress = null;
            String publicFQDN = null;
            int frontendPort = 0;
            int backendPort = 0;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("protocol".equals(fieldName)) {
                    protocol = InboundEndpointProtocol.fromString(reader.getString());
                    continue;
                }
                if ("publicIPAddress".equals(fieldName)) {
                    publicIpAddress = reader.getString();
                    continue;
                }
                if ("publicFQDN".equals(fieldName)) {
                    publicFQDN = reader.getString();
                    continue;
                }
                if ("frontendPort".equals(fieldName)) {
                    frontendPort = reader.getInt();
                    continue;
                }
                if ("backendPort".equals(fieldName)) {
                    backendPort = reader.getInt();
                    continue;
                }
                reader.skipChildren();
            }
            return new InboundEndpoint(name, protocol, publicIpAddress, publicFQDN, frontendPort, backendPort);
        });
    }
}

