/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.BatchCertificateState;
import com.azure.compute.batch.models.DeleteBatchCertificateError;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class GetCertificateResponse
implements JsonSerializable<GetCertificateResponse> {
    private final String thumbprint;
    private final String thumbprintAlgorithm;
    private String url;
    private BatchCertificateState state;
    private OffsetDateTime stateTransitionTime;
    private BatchCertificateState previousState;
    private OffsetDateTime previousStateTransitionTime;
    private String publicData;
    private DeleteBatchCertificateError deleteCertificateError;

    private GetCertificateResponse(String thumbprint, String thumbprintAlgorithm) {
        this.thumbprint = thumbprint;
        this.thumbprintAlgorithm = thumbprintAlgorithm;
    }

    public String getThumbprint() {
        return this.thumbprint;
    }

    public String getThumbprintAlgorithm() {
        return this.thumbprintAlgorithm;
    }

    public String getUrl() {
        return this.url;
    }

    public BatchCertificateState getState() {
        return this.state;
    }

    public OffsetDateTime getStateTransitionTime() {
        return this.stateTransitionTime;
    }

    public BatchCertificateState getPreviousState() {
        return this.previousState;
    }

    public OffsetDateTime getPreviousStateTransitionTime() {
        return this.previousStateTransitionTime;
    }

    public String getPublicData() {
        return this.publicData;
    }

    public DeleteBatchCertificateError getDeleteCertificateError() {
        return this.deleteCertificateError;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("thumbprint", this.thumbprint);
        jsonWriter.writeStringField("thumbprintAlgorithm", this.thumbprintAlgorithm);
        return jsonWriter.writeEndObject();
    }

    public static GetCertificateResponse fromJson(JsonReader jsonReader) throws IOException {
        return (GetCertificateResponse)jsonReader.readObject(reader -> {
            String thumbprint = null;
            String thumbprintAlgorithm = null;
            String url = null;
            BatchCertificateState state = null;
            OffsetDateTime stateTransitionTime = null;
            BatchCertificateState previousState = null;
            OffsetDateTime previousStateTransitionTime = null;
            String publicData = null;
            DeleteBatchCertificateError deleteCertificateError = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("thumbprint".equals(fieldName)) {
                    thumbprint = reader.getString();
                    continue;
                }
                if ("thumbprintAlgorithm".equals(fieldName)) {
                    thumbprintAlgorithm = reader.getString();
                    continue;
                }
                if ("url".equals(fieldName)) {
                    url = reader.getString();
                    continue;
                }
                if ("state".equals(fieldName)) {
                    state = BatchCertificateState.fromString(reader.getString());
                    continue;
                }
                if ("stateTransitionTime".equals(fieldName)) {
                    stateTransitionTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("previousState".equals(fieldName)) {
                    previousState = BatchCertificateState.fromString(reader.getString());
                    continue;
                }
                if ("previousStateTransitionTime".equals(fieldName)) {
                    previousStateTransitionTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("publicData".equals(fieldName)) {
                    publicData = reader.getString();
                    continue;
                }
                if ("deleteCertificateError".equals(fieldName)) {
                    deleteCertificateError = DeleteBatchCertificateError.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            GetCertificateResponse deserializedGetCertificateResponse = new GetCertificateResponse(thumbprint, thumbprintAlgorithm);
            deserializedGetCertificateResponse.url = url;
            deserializedGetCertificateResponse.state = state;
            deserializedGetCertificateResponse.stateTransitionTime = stateTransitionTime;
            deserializedGetCertificateResponse.previousState = previousState;
            deserializedGetCertificateResponse.previousStateTransitionTime = previousStateTransitionTime;
            deserializedGetCertificateResponse.publicData = publicData;
            deserializedGetCertificateResponse.deleteCertificateError = deleteCertificateError;
            return deserializedGetCertificateResponse;
        });
    }
}

