/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.BatchNodeIdentityReference;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ContainerRegistryReference
implements JsonSerializable<ContainerRegistryReference> {
    private String username;
    private String password;
    private String registryServer;
    private BatchNodeIdentityReference identityReference;

    public String getUsername() {
        return this.username;
    }

    public ContainerRegistryReference setUsername(String username) {
        this.username = username;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public ContainerRegistryReference setPassword(String password) {
        this.password = password;
        return this;
    }

    public String getRegistryServer() {
        return this.registryServer;
    }

    public ContainerRegistryReference setRegistryServer(String registryServer) {
        this.registryServer = registryServer;
        return this;
    }

    public BatchNodeIdentityReference getIdentityReference() {
        return this.identityReference;
    }

    public ContainerRegistryReference setIdentityReference(BatchNodeIdentityReference identityReference) {
        this.identityReference = identityReference;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("username", this.username);
        jsonWriter.writeStringField("password", this.password);
        jsonWriter.writeStringField("registryServer", this.registryServer);
        jsonWriter.writeJsonField("identityReference", (JsonSerializable)this.identityReference);
        return jsonWriter.writeEndObject();
    }

    public static ContainerRegistryReference fromJson(JsonReader jsonReader) throws IOException {
        return (ContainerRegistryReference)jsonReader.readObject(reader -> {
            ContainerRegistryReference deserializedContainerRegistryReference = new ContainerRegistryReference();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("username".equals(fieldName)) {
                    deserializedContainerRegistryReference.username = reader.getString();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedContainerRegistryReference.password = reader.getString();
                    continue;
                }
                if ("registryServer".equals(fieldName)) {
                    deserializedContainerRegistryReference.registryServer = reader.getString();
                    continue;
                }
                if ("identityReference".equals(fieldName)) {
                    deserializedContainerRegistryReference.identityReference = BatchNodeIdentityReference.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedContainerRegistryReference;
        });
    }
}

