/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class BatchTaskIdRange
implements JsonSerializable<BatchTaskIdRange> {
    private final int start;
    private final int end;

    public BatchTaskIdRange(int start, int end) {
        this.start = start;
        this.end = end;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("start", this.start);
        jsonWriter.writeIntField("end", this.end);
        return jsonWriter.writeEndObject();
    }

    public static BatchTaskIdRange fromJson(JsonReader jsonReader) throws IOException {
        return (BatchTaskIdRange)jsonReader.readObject(reader -> {
            int start = 0;
            int end = 0;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("start".equals(fieldName)) {
                    start = reader.getInt();
                    continue;
                }
                if ("end".equals(fieldName)) {
                    end = reader.getInt();
                    continue;
                }
                reader.skipChildren();
            }
            return new BatchTaskIdRange(start, end);
        });
    }
}

