/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.AffinityInfo;
import com.azure.compute.batch.models.AuthenticationTokenSettings;
import com.azure.compute.batch.models.BatchApplicationPackageReference;
import com.azure.compute.batch.models.BatchTaskConstraints;
import com.azure.compute.batch.models.BatchTaskContainerSettings;
import com.azure.compute.batch.models.BatchTaskDependencies;
import com.azure.compute.batch.models.EnvironmentSetting;
import com.azure.compute.batch.models.ExitConditions;
import com.azure.compute.batch.models.MultiInstanceSettings;
import com.azure.compute.batch.models.OutputFile;
import com.azure.compute.batch.models.ResourceFile;
import com.azure.compute.batch.models.UserIdentity;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class BatchTaskCreateContent
implements JsonSerializable<BatchTaskCreateContent> {
    private final String id;
    private String displayName;
    private ExitConditions exitConditions;
    private final String commandLine;
    private BatchTaskContainerSettings containerSettings;
    private List<ResourceFile> resourceFiles;
    private List<OutputFile> outputFiles;
    private List<EnvironmentSetting> environmentSettings;
    private AffinityInfo affinityInfo;
    private BatchTaskConstraints constraints;
    private Integer requiredSlots;
    private UserIdentity userIdentity;
    private MultiInstanceSettings multiInstanceSettings;
    private BatchTaskDependencies dependsOn;
    private List<BatchApplicationPackageReference> applicationPackageReferences;
    private AuthenticationTokenSettings authenticationTokenSettings;

    public BatchTaskCreateContent(String id, String commandLine) {
        this.id = id;
        this.commandLine = commandLine;
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public BatchTaskCreateContent setDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public ExitConditions getExitConditions() {
        return this.exitConditions;
    }

    public BatchTaskCreateContent setExitConditions(ExitConditions exitConditions) {
        this.exitConditions = exitConditions;
        return this;
    }

    public String getCommandLine() {
        return this.commandLine;
    }

    public BatchTaskContainerSettings getContainerSettings() {
        return this.containerSettings;
    }

    public BatchTaskCreateContent setContainerSettings(BatchTaskContainerSettings containerSettings) {
        this.containerSettings = containerSettings;
        return this;
    }

    public List<ResourceFile> getResourceFiles() {
        return this.resourceFiles;
    }

    public BatchTaskCreateContent setResourceFiles(List<ResourceFile> resourceFiles) {
        this.resourceFiles = resourceFiles;
        return this;
    }

    public List<OutputFile> getOutputFiles() {
        return this.outputFiles;
    }

    public BatchTaskCreateContent setOutputFiles(List<OutputFile> outputFiles) {
        this.outputFiles = outputFiles;
        return this;
    }

    public List<EnvironmentSetting> getEnvironmentSettings() {
        return this.environmentSettings;
    }

    public BatchTaskCreateContent setEnvironmentSettings(List<EnvironmentSetting> environmentSettings) {
        this.environmentSettings = environmentSettings;
        return this;
    }

    public AffinityInfo getAffinityInfo() {
        return this.affinityInfo;
    }

    public BatchTaskCreateContent setAffinityInfo(AffinityInfo affinityInfo) {
        this.affinityInfo = affinityInfo;
        return this;
    }

    public BatchTaskConstraints getConstraints() {
        return this.constraints;
    }

    public BatchTaskCreateContent setConstraints(BatchTaskConstraints constraints) {
        this.constraints = constraints;
        return this;
    }

    public Integer getRequiredSlots() {
        return this.requiredSlots;
    }

    public BatchTaskCreateContent setRequiredSlots(Integer requiredSlots) {
        this.requiredSlots = requiredSlots;
        return this;
    }

    public UserIdentity getUserIdentity() {
        return this.userIdentity;
    }

    public BatchTaskCreateContent setUserIdentity(UserIdentity userIdentity) {
        this.userIdentity = userIdentity;
        return this;
    }

    public MultiInstanceSettings getMultiInstanceSettings() {
        return this.multiInstanceSettings;
    }

    public BatchTaskCreateContent setMultiInstanceSettings(MultiInstanceSettings multiInstanceSettings) {
        this.multiInstanceSettings = multiInstanceSettings;
        return this;
    }

    public BatchTaskDependencies getDependsOn() {
        return this.dependsOn;
    }

    public BatchTaskCreateContent setDependsOn(BatchTaskDependencies dependsOn) {
        this.dependsOn = dependsOn;
        return this;
    }

    public List<BatchApplicationPackageReference> getApplicationPackageReferences() {
        return this.applicationPackageReferences;
    }

    public BatchTaskCreateContent setApplicationPackageReferences(List<BatchApplicationPackageReference> applicationPackageReferences) {
        this.applicationPackageReferences = applicationPackageReferences;
        return this;
    }

    public AuthenticationTokenSettings getAuthenticationTokenSettings() {
        return this.authenticationTokenSettings;
    }

    public BatchTaskCreateContent setAuthenticationTokenSettings(AuthenticationTokenSettings authenticationTokenSettings) {
        this.authenticationTokenSettings = authenticationTokenSettings;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("commandLine", this.commandLine);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeJsonField("exitConditions", (JsonSerializable)this.exitConditions);
        jsonWriter.writeJsonField("containerSettings", (JsonSerializable)this.containerSettings);
        jsonWriter.writeArrayField("resourceFiles", this.resourceFiles, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("outputFiles", this.outputFiles, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("environmentSettings", this.environmentSettings, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("affinityInfo", (JsonSerializable)this.affinityInfo);
        jsonWriter.writeJsonField("constraints", (JsonSerializable)this.constraints);
        jsonWriter.writeNumberField("requiredSlots", (Number)this.requiredSlots);
        jsonWriter.writeJsonField("userIdentity", (JsonSerializable)this.userIdentity);
        jsonWriter.writeJsonField("multiInstanceSettings", (JsonSerializable)this.multiInstanceSettings);
        jsonWriter.writeJsonField("dependsOn", (JsonSerializable)this.dependsOn);
        jsonWriter.writeArrayField("applicationPackageReferences", this.applicationPackageReferences, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("authenticationTokenSettings", (JsonSerializable)this.authenticationTokenSettings);
        return jsonWriter.writeEndObject();
    }

    public static BatchTaskCreateContent fromJson(JsonReader jsonReader) throws IOException {
        return (BatchTaskCreateContent)jsonReader.readObject(reader -> {
            String id = null;
            String commandLine = null;
            String displayName = null;
            ExitConditions exitConditions = null;
            BatchTaskContainerSettings containerSettings = null;
            List resourceFiles = null;
            List outputFiles = null;
            List environmentSettings = null;
            AffinityInfo affinityInfo = null;
            BatchTaskConstraints constraints = null;
            Integer requiredSlots = null;
            UserIdentity userIdentity = null;
            MultiInstanceSettings multiInstanceSettings = null;
            BatchTaskDependencies dependsOn = null;
            List applicationPackageReferences = null;
            AuthenticationTokenSettings authenticationTokenSettings = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("commandLine".equals(fieldName)) {
                    commandLine = reader.getString();
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    displayName = reader.getString();
                    continue;
                }
                if ("exitConditions".equals(fieldName)) {
                    exitConditions = ExitConditions.fromJson(reader);
                    continue;
                }
                if ("containerSettings".equals(fieldName)) {
                    containerSettings = BatchTaskContainerSettings.fromJson(reader);
                    continue;
                }
                if ("resourceFiles".equals(fieldName)) {
                    resourceFiles = reader.readArray(reader1 -> ResourceFile.fromJson(reader1));
                    continue;
                }
                if ("outputFiles".equals(fieldName)) {
                    outputFiles = reader.readArray(reader1 -> OutputFile.fromJson(reader1));
                    continue;
                }
                if ("environmentSettings".equals(fieldName)) {
                    environmentSettings = reader.readArray(reader1 -> EnvironmentSetting.fromJson(reader1));
                    continue;
                }
                if ("affinityInfo".equals(fieldName)) {
                    affinityInfo = AffinityInfo.fromJson(reader);
                    continue;
                }
                if ("constraints".equals(fieldName)) {
                    constraints = BatchTaskConstraints.fromJson(reader);
                    continue;
                }
                if ("requiredSlots".equals(fieldName)) {
                    requiredSlots = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("userIdentity".equals(fieldName)) {
                    userIdentity = UserIdentity.fromJson(reader);
                    continue;
                }
                if ("multiInstanceSettings".equals(fieldName)) {
                    multiInstanceSettings = MultiInstanceSettings.fromJson(reader);
                    continue;
                }
                if ("dependsOn".equals(fieldName)) {
                    dependsOn = BatchTaskDependencies.fromJson(reader);
                    continue;
                }
                if ("applicationPackageReferences".equals(fieldName)) {
                    applicationPackageReferences = reader.readArray(reader1 -> BatchApplicationPackageReference.fromJson(reader1));
                    continue;
                }
                if ("authenticationTokenSettings".equals(fieldName)) {
                    authenticationTokenSettings = AuthenticationTokenSettings.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            BatchTaskCreateContent deserializedBatchTaskCreateContent = new BatchTaskCreateContent(id, commandLine);
            deserializedBatchTaskCreateContent.displayName = displayName;
            deserializedBatchTaskCreateContent.exitConditions = exitConditions;
            deserializedBatchTaskCreateContent.containerSettings = containerSettings;
            deserializedBatchTaskCreateContent.resourceFiles = resourceFiles;
            deserializedBatchTaskCreateContent.outputFiles = outputFiles;
            deserializedBatchTaskCreateContent.environmentSettings = environmentSettings;
            deserializedBatchTaskCreateContent.affinityInfo = affinityInfo;
            deserializedBatchTaskCreateContent.constraints = constraints;
            deserializedBatchTaskCreateContent.requiredSlots = requiredSlots;
            deserializedBatchTaskCreateContent.userIdentity = userIdentity;
            deserializedBatchTaskCreateContent.multiInstanceSettings = multiInstanceSettings;
            deserializedBatchTaskCreateContent.dependsOn = dependsOn;
            deserializedBatchTaskCreateContent.applicationPackageReferences = applicationPackageReferences;
            deserializedBatchTaskCreateContent.authenticationTokenSettings = authenticationTokenSettings;
            return deserializedBatchTaskCreateContent;
        });
    }
}

