/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.BatchTaskCounts;
import com.azure.compute.batch.models.BatchTaskSlotCounts;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class BatchTaskCountsResult
implements JsonSerializable<BatchTaskCountsResult> {
    private final BatchTaskCounts taskCounts;
    private final BatchTaskSlotCounts taskSlotCounts;

    private BatchTaskCountsResult(BatchTaskCounts taskCounts, BatchTaskSlotCounts taskSlotCounts) {
        this.taskCounts = taskCounts;
        this.taskSlotCounts = taskSlotCounts;
    }

    public BatchTaskCounts getTaskCounts() {
        return this.taskCounts;
    }

    public BatchTaskSlotCounts getTaskSlotCounts() {
        return this.taskSlotCounts;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("taskCounts", (JsonSerializable)this.taskCounts);
        jsonWriter.writeJsonField("taskSlotCounts", (JsonSerializable)this.taskSlotCounts);
        return jsonWriter.writeEndObject();
    }

    public static BatchTaskCountsResult fromJson(JsonReader jsonReader) throws IOException {
        return (BatchTaskCountsResult)jsonReader.readObject(reader -> {
            BatchTaskCounts taskCounts = null;
            BatchTaskSlotCounts taskSlotCounts = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("taskCounts".equals(fieldName)) {
                    taskCounts = BatchTaskCounts.fromJson(reader);
                    continue;
                }
                if ("taskSlotCounts".equals(fieldName)) {
                    taskSlotCounts = BatchTaskSlotCounts.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return new BatchTaskCountsResult(taskCounts, taskSlotCounts);
        });
    }
}

