/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.AffinityInfo;
import com.azure.compute.batch.models.AuthenticationTokenSettings;
import com.azure.compute.batch.models.BatchApplicationPackageReference;
import com.azure.compute.batch.models.BatchNodeInfo;
import com.azure.compute.batch.models.BatchTaskConstraints;
import com.azure.compute.batch.models.BatchTaskContainerSettings;
import com.azure.compute.batch.models.BatchTaskDependencies;
import com.azure.compute.batch.models.BatchTaskExecutionInfo;
import com.azure.compute.batch.models.BatchTaskState;
import com.azure.compute.batch.models.BatchTaskStatistics;
import com.azure.compute.batch.models.EnvironmentSetting;
import com.azure.compute.batch.models.ExitConditions;
import com.azure.compute.batch.models.MultiInstanceSettings;
import com.azure.compute.batch.models.OutputFile;
import com.azure.compute.batch.models.ResourceFile;
import com.azure.compute.batch.models.UserIdentity;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class BatchTask
implements JsonSerializable<BatchTask> {
    private String id;
    private String displayName;
    private String url;
    private String eTag;
    private OffsetDateTime lastModified;
    private OffsetDateTime creationTime;
    private ExitConditions exitConditions;
    private BatchTaskState state;
    private OffsetDateTime stateTransitionTime;
    private BatchTaskState previousState;
    private OffsetDateTime previousStateTransitionTime;
    private String commandLine;
    private BatchTaskContainerSettings containerSettings;
    private List<ResourceFile> resourceFiles;
    private List<OutputFile> outputFiles;
    private List<EnvironmentSetting> environmentSettings;
    private AffinityInfo affinityInfo;
    private BatchTaskConstraints constraints;
    private Integer requiredSlots;
    private UserIdentity userIdentity;
    private BatchTaskExecutionInfo executionInfo;
    private BatchNodeInfo nodeInfo;
    private MultiInstanceSettings multiInstanceSettings;
    private BatchTaskStatistics stats;
    private BatchTaskDependencies dependsOn;
    private List<BatchApplicationPackageReference> applicationPackageReferences;
    private AuthenticationTokenSettings authenticationTokenSettings;

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getUrl() {
        return this.url;
    }

    public String getETag() {
        return this.eTag;
    }

    public OffsetDateTime getLastModified() {
        return this.lastModified;
    }

    public OffsetDateTime getCreationTime() {
        return this.creationTime;
    }

    public ExitConditions getExitConditions() {
        return this.exitConditions;
    }

    public BatchTaskState getState() {
        return this.state;
    }

    public OffsetDateTime getStateTransitionTime() {
        return this.stateTransitionTime;
    }

    public BatchTaskState getPreviousState() {
        return this.previousState;
    }

    public OffsetDateTime getPreviousStateTransitionTime() {
        return this.previousStateTransitionTime;
    }

    public String getCommandLine() {
        return this.commandLine;
    }

    public BatchTaskContainerSettings getContainerSettings() {
        return this.containerSettings;
    }

    public List<ResourceFile> getResourceFiles() {
        return this.resourceFiles;
    }

    public List<OutputFile> getOutputFiles() {
        return this.outputFiles;
    }

    public List<EnvironmentSetting> getEnvironmentSettings() {
        return this.environmentSettings;
    }

    public AffinityInfo getAffinityInfo() {
        return this.affinityInfo;
    }

    public BatchTaskConstraints getConstraints() {
        return this.constraints;
    }

    public BatchTask setConstraints(BatchTaskConstraints constraints) {
        this.constraints = constraints;
        return this;
    }

    public Integer getRequiredSlots() {
        return this.requiredSlots;
    }

    public UserIdentity getUserIdentity() {
        return this.userIdentity;
    }

    public BatchTaskExecutionInfo getExecutionInfo() {
        return this.executionInfo;
    }

    public BatchNodeInfo getNodeInfo() {
        return this.nodeInfo;
    }

    public MultiInstanceSettings getMultiInstanceSettings() {
        return this.multiInstanceSettings;
    }

    public BatchTaskStatistics getStats() {
        return this.stats;
    }

    public BatchTaskDependencies getDependsOn() {
        return this.dependsOn;
    }

    public List<BatchApplicationPackageReference> getApplicationPackageReferences() {
        return this.applicationPackageReferences;
    }

    public AuthenticationTokenSettings getAuthenticationTokenSettings() {
        return this.authenticationTokenSettings;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("constraints", (JsonSerializable)this.constraints);
        return jsonWriter.writeEndObject();
    }

    public static BatchTask fromJson(JsonReader jsonReader) throws IOException {
        return (BatchTask)jsonReader.readObject(reader -> {
            BatchTask deserializedBatchTask = new BatchTask();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedBatchTask.id = reader.getString();
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedBatchTask.displayName = reader.getString();
                    continue;
                }
                if ("url".equals(fieldName)) {
                    deserializedBatchTask.url = reader.getString();
                    continue;
                }
                if ("eTag".equals(fieldName)) {
                    deserializedBatchTask.eTag = reader.getString();
                    continue;
                }
                if ("lastModified".equals(fieldName)) {
                    deserializedBatchTask.lastModified = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("creationTime".equals(fieldName)) {
                    deserializedBatchTask.creationTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("exitConditions".equals(fieldName)) {
                    deserializedBatchTask.exitConditions = ExitConditions.fromJson(reader);
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedBatchTask.state = BatchTaskState.fromString(reader.getString());
                    continue;
                }
                if ("stateTransitionTime".equals(fieldName)) {
                    deserializedBatchTask.stateTransitionTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("previousState".equals(fieldName)) {
                    deserializedBatchTask.previousState = BatchTaskState.fromString(reader.getString());
                    continue;
                }
                if ("previousStateTransitionTime".equals(fieldName)) {
                    deserializedBatchTask.previousStateTransitionTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("commandLine".equals(fieldName)) {
                    deserializedBatchTask.commandLine = reader.getString();
                    continue;
                }
                if ("containerSettings".equals(fieldName)) {
                    deserializedBatchTask.containerSettings = BatchTaskContainerSettings.fromJson(reader);
                    continue;
                }
                if ("resourceFiles".equals(fieldName)) {
                    List resourceFiles;
                    deserializedBatchTask.resourceFiles = resourceFiles = reader.readArray(reader1 -> ResourceFile.fromJson(reader1));
                    continue;
                }
                if ("outputFiles".equals(fieldName)) {
                    List outputFiles;
                    deserializedBatchTask.outputFiles = outputFiles = reader.readArray(reader1 -> OutputFile.fromJson(reader1));
                    continue;
                }
                if ("environmentSettings".equals(fieldName)) {
                    List environmentSettings;
                    deserializedBatchTask.environmentSettings = environmentSettings = reader.readArray(reader1 -> EnvironmentSetting.fromJson(reader1));
                    continue;
                }
                if ("affinityInfo".equals(fieldName)) {
                    deserializedBatchTask.affinityInfo = AffinityInfo.fromJson(reader);
                    continue;
                }
                if ("constraints".equals(fieldName)) {
                    deserializedBatchTask.constraints = BatchTaskConstraints.fromJson(reader);
                    continue;
                }
                if ("requiredSlots".equals(fieldName)) {
                    deserializedBatchTask.requiredSlots = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("userIdentity".equals(fieldName)) {
                    deserializedBatchTask.userIdentity = UserIdentity.fromJson(reader);
                    continue;
                }
                if ("executionInfo".equals(fieldName)) {
                    deserializedBatchTask.executionInfo = BatchTaskExecutionInfo.fromJson(reader);
                    continue;
                }
                if ("nodeInfo".equals(fieldName)) {
                    deserializedBatchTask.nodeInfo = BatchNodeInfo.fromJson(reader);
                    continue;
                }
                if ("multiInstanceSettings".equals(fieldName)) {
                    deserializedBatchTask.multiInstanceSettings = MultiInstanceSettings.fromJson(reader);
                    continue;
                }
                if ("stats".equals(fieldName)) {
                    deserializedBatchTask.stats = BatchTaskStatistics.fromJson(reader);
                    continue;
                }
                if ("dependsOn".equals(fieldName)) {
                    deserializedBatchTask.dependsOn = BatchTaskDependencies.fromJson(reader);
                    continue;
                }
                if ("applicationPackageReferences".equals(fieldName)) {
                    List applicationPackageReferences;
                    deserializedBatchTask.applicationPackageReferences = applicationPackageReferences = reader.readArray(reader1 -> BatchApplicationPackageReference.fromJson(reader1));
                    continue;
                }
                if ("authenticationTokenSettings".equals(fieldName)) {
                    deserializedBatchTask.authenticationTokenSettings = AuthenticationTokenSettings.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBatchTask;
        });
    }
}

