/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.BatchNodeInfo;
import com.azure.compute.batch.models.BatchSubtaskState;
import com.azure.compute.batch.models.BatchTaskContainerExecutionInfo;
import com.azure.compute.batch.models.BatchTaskExecutionResult;
import com.azure.compute.batch.models.BatchTaskFailureInfo;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class BatchSubtask
implements JsonSerializable<BatchSubtask> {
    private Integer id;
    private BatchNodeInfo nodeInfo;
    private OffsetDateTime startTime;
    private OffsetDateTime endTime;
    private Integer exitCode;
    private BatchTaskContainerExecutionInfo containerInfo;
    private BatchTaskFailureInfo failureInfo;
    private BatchSubtaskState state;
    private OffsetDateTime stateTransitionTime;
    private BatchSubtaskState previousState;
    private OffsetDateTime previousStateTransitionTime;
    private BatchTaskExecutionResult result;

    private BatchSubtask() {
    }

    public Integer getId() {
        return this.id;
    }

    public BatchNodeInfo getNodeInfo() {
        return this.nodeInfo;
    }

    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    public OffsetDateTime getEndTime() {
        return this.endTime;
    }

    public Integer getExitCode() {
        return this.exitCode;
    }

    public BatchTaskContainerExecutionInfo getContainerInfo() {
        return this.containerInfo;
    }

    public BatchTaskFailureInfo getFailureInfo() {
        return this.failureInfo;
    }

    public BatchSubtaskState getState() {
        return this.state;
    }

    public OffsetDateTime getStateTransitionTime() {
        return this.stateTransitionTime;
    }

    public BatchSubtaskState getPreviousState() {
        return this.previousState;
    }

    public OffsetDateTime getPreviousStateTransitionTime() {
        return this.previousStateTransitionTime;
    }

    public BatchTaskExecutionResult getResult() {
        return this.result;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("id", (Number)this.id);
        jsonWriter.writeJsonField("nodeInfo", (JsonSerializable)this.nodeInfo);
        jsonWriter.writeStringField("startTime", this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("endTime", this.endTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endTime));
        jsonWriter.writeNumberField("exitCode", (Number)this.exitCode);
        jsonWriter.writeJsonField("containerInfo", (JsonSerializable)this.containerInfo);
        jsonWriter.writeJsonField("failureInfo", (JsonSerializable)this.failureInfo);
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeStringField("stateTransitionTime", this.stateTransitionTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.stateTransitionTime));
        jsonWriter.writeStringField("previousState", this.previousState == null ? null : this.previousState.toString());
        jsonWriter.writeStringField("previousStateTransitionTime", this.previousStateTransitionTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.previousStateTransitionTime));
        jsonWriter.writeStringField("result", this.result == null ? null : this.result.toString());
        return jsonWriter.writeEndObject();
    }

    public static BatchSubtask fromJson(JsonReader jsonReader) throws IOException {
        return (BatchSubtask)jsonReader.readObject(reader -> {
            BatchSubtask deserializedBatchSubtask = new BatchSubtask();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedBatchSubtask.id = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("nodeInfo".equals(fieldName)) {
                    deserializedBatchSubtask.nodeInfo = BatchNodeInfo.fromJson(reader);
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedBatchSubtask.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedBatchSubtask.endTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("exitCode".equals(fieldName)) {
                    deserializedBatchSubtask.exitCode = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("containerInfo".equals(fieldName)) {
                    deserializedBatchSubtask.containerInfo = BatchTaskContainerExecutionInfo.fromJson(reader);
                    continue;
                }
                if ("failureInfo".equals(fieldName)) {
                    deserializedBatchSubtask.failureInfo = BatchTaskFailureInfo.fromJson(reader);
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedBatchSubtask.state = BatchSubtaskState.fromString(reader.getString());
                    continue;
                }
                if ("stateTransitionTime".equals(fieldName)) {
                    deserializedBatchSubtask.stateTransitionTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("previousState".equals(fieldName)) {
                    deserializedBatchSubtask.previousState = BatchSubtaskState.fromString(reader.getString());
                    continue;
                }
                if ("previousStateTransitionTime".equals(fieldName)) {
                    deserializedBatchSubtask.previousStateTransitionTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("result".equals(fieldName)) {
                    deserializedBatchSubtask.result = BatchTaskExecutionResult.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBatchSubtask;
        });
    }
}

