/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.BatchApplicationPackageReference;
import com.azure.compute.batch.models.BatchCertificateReference;
import com.azure.compute.batch.models.BatchNodeCommunicationMode;
import com.azure.compute.batch.models.BatchStartTask;
import com.azure.compute.batch.models.MetadataItem;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class BatchPoolReplaceContent
implements JsonSerializable<BatchPoolReplaceContent> {
    private BatchStartTask startTask;
    private final List<BatchCertificateReference> certificateReferences;
    private final List<BatchApplicationPackageReference> applicationPackageReferences;
    private final List<MetadataItem> metadata;
    private BatchNodeCommunicationMode targetNodeCommunicationMode;

    public BatchPoolReplaceContent(List<BatchCertificateReference> certificateReferences, List<BatchApplicationPackageReference> applicationPackageReferences, List<MetadataItem> metadata) {
        this.certificateReferences = certificateReferences;
        this.applicationPackageReferences = applicationPackageReferences;
        this.metadata = metadata;
    }

    public BatchStartTask getStartTask() {
        return this.startTask;
    }

    public BatchPoolReplaceContent setStartTask(BatchStartTask startTask) {
        this.startTask = startTask;
        return this;
    }

    public List<BatchCertificateReference> getCertificateReferences() {
        return this.certificateReferences;
    }

    public List<BatchApplicationPackageReference> getApplicationPackageReferences() {
        return this.applicationPackageReferences;
    }

    public List<MetadataItem> getMetadata() {
        return this.metadata;
    }

    public BatchNodeCommunicationMode getTargetNodeCommunicationMode() {
        return this.targetNodeCommunicationMode;
    }

    public BatchPoolReplaceContent setTargetNodeCommunicationMode(BatchNodeCommunicationMode targetNodeCommunicationMode) {
        this.targetNodeCommunicationMode = targetNodeCommunicationMode;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("certificateReferences", this.certificateReferences, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("applicationPackageReferences", this.applicationPackageReferences, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("metadata", this.metadata, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("startTask", (JsonSerializable)this.startTask);
        jsonWriter.writeStringField("targetNodeCommunicationMode", this.targetNodeCommunicationMode == null ? null : this.targetNodeCommunicationMode.toString());
        return jsonWriter.writeEndObject();
    }

    public static BatchPoolReplaceContent fromJson(JsonReader jsonReader) throws IOException {
        return (BatchPoolReplaceContent)jsonReader.readObject(reader -> {
            List certificateReferences = null;
            List applicationPackageReferences = null;
            List metadata = null;
            BatchStartTask startTask = null;
            BatchNodeCommunicationMode targetNodeCommunicationMode = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("certificateReferences".equals(fieldName)) {
                    certificateReferences = reader.readArray(reader1 -> BatchCertificateReference.fromJson(reader1));
                    continue;
                }
                if ("applicationPackageReferences".equals(fieldName)) {
                    applicationPackageReferences = reader.readArray(reader1 -> BatchApplicationPackageReference.fromJson(reader1));
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    metadata = reader.readArray(reader1 -> MetadataItem.fromJson(reader1));
                    continue;
                }
                if ("startTask".equals(fieldName)) {
                    startTask = BatchStartTask.fromJson(reader);
                    continue;
                }
                if ("targetNodeCommunicationMode".equals(fieldName)) {
                    targetNodeCommunicationMode = BatchNodeCommunicationMode.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            BatchPoolReplaceContent deserializedBatchPoolReplaceContent = new BatchPoolReplaceContent(certificateReferences, applicationPackageReferences, metadata);
            deserializedBatchPoolReplaceContent.startTask = startTask;
            deserializedBatchPoolReplaceContent.targetNodeCommunicationMode = targetNodeCommunicationMode;
            return deserializedBatchPoolReplaceContent;
        });
    }
}

