/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.BatchNodeCounts;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class BatchPoolNodeCounts
implements JsonSerializable<BatchPoolNodeCounts> {
    private final String poolId;
    private BatchNodeCounts dedicated;
    private BatchNodeCounts lowPriority;

    private BatchPoolNodeCounts(String poolId) {
        this.poolId = poolId;
    }

    public String getPoolId() {
        return this.poolId;
    }

    public BatchNodeCounts getDedicated() {
        return this.dedicated;
    }

    public BatchNodeCounts getLowPriority() {
        return this.lowPriority;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("poolId", this.poolId);
        jsonWriter.writeJsonField("dedicated", (JsonSerializable)this.dedicated);
        jsonWriter.writeJsonField("lowPriority", (JsonSerializable)this.lowPriority);
        return jsonWriter.writeEndObject();
    }

    public static BatchPoolNodeCounts fromJson(JsonReader jsonReader) throws IOException {
        return (BatchPoolNodeCounts)jsonReader.readObject(reader -> {
            String poolId = null;
            BatchNodeCounts dedicated = null;
            BatchNodeCounts lowPriority = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("poolId".equals(fieldName)) {
                    poolId = reader.getString();
                    continue;
                }
                if ("dedicated".equals(fieldName)) {
                    dedicated = BatchNodeCounts.fromJson(reader);
                    continue;
                }
                if ("lowPriority".equals(fieldName)) {
                    lowPriority = BatchNodeCounts.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            BatchPoolNodeCounts deserializedBatchPoolNodeCounts = new BatchPoolNodeCounts(poolId);
            deserializedBatchPoolNodeCounts.dedicated = dedicated;
            deserializedBatchPoolNodeCounts.lowPriority = lowPriority;
            return deserializedBatchPoolNodeCounts;
        });
    }
}

