/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.BatchCertificateReference;
import com.azure.compute.batch.models.BatchNodeAgentInfo;
import com.azure.compute.batch.models.BatchNodeEndpointConfiguration;
import com.azure.compute.batch.models.BatchNodeError;
import com.azure.compute.batch.models.BatchNodeState;
import com.azure.compute.batch.models.BatchStartTask;
import com.azure.compute.batch.models.BatchStartTaskInfo;
import com.azure.compute.batch.models.BatchTaskInfo;
import com.azure.compute.batch.models.SchedulingState;
import com.azure.compute.batch.models.VirtualMachineInfo;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class BatchNode
implements JsonSerializable<BatchNode> {
    private String id;
    private String url;
    private BatchNodeState state;
    private SchedulingState schedulingState;
    private OffsetDateTime stateTransitionTime;
    private OffsetDateTime lastBootTime;
    private OffsetDateTime allocationTime;
    private String ipAddress;
    private String affinityId;
    private String vmSize;
    private Integer totalTasksRun;
    private Integer runningTasksCount;
    private Integer runningTaskSlotsCount;
    private Integer totalTasksSucceeded;
    private List<BatchTaskInfo> recentTasks;
    private BatchStartTask startTask;
    private BatchStartTaskInfo startTaskInfo;
    private List<BatchCertificateReference> certificateReferences;
    private List<BatchNodeError> errors;
    private Boolean isDedicated;
    private BatchNodeEndpointConfiguration endpointConfiguration;
    private BatchNodeAgentInfo nodeAgentInfo;
    private VirtualMachineInfo virtualMachineInfo;

    private BatchNode() {
    }

    public String getId() {
        return this.id;
    }

    public String getUrl() {
        return this.url;
    }

    public BatchNodeState getState() {
        return this.state;
    }

    public SchedulingState getSchedulingState() {
        return this.schedulingState;
    }

    public OffsetDateTime getStateTransitionTime() {
        return this.stateTransitionTime;
    }

    public OffsetDateTime getLastBootTime() {
        return this.lastBootTime;
    }

    public OffsetDateTime getAllocationTime() {
        return this.allocationTime;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getAffinityId() {
        return this.affinityId;
    }

    public String getVmSize() {
        return this.vmSize;
    }

    public Integer getTotalTasksRun() {
        return this.totalTasksRun;
    }

    public Integer getRunningTasksCount() {
        return this.runningTasksCount;
    }

    public Integer getRunningTaskSlotsCount() {
        return this.runningTaskSlotsCount;
    }

    public Integer getTotalTasksSucceeded() {
        return this.totalTasksSucceeded;
    }

    public List<BatchTaskInfo> getRecentTasks() {
        return this.recentTasks;
    }

    public BatchStartTask getStartTask() {
        return this.startTask;
    }

    public BatchStartTaskInfo getStartTaskInfo() {
        return this.startTaskInfo;
    }

    public List<BatchCertificateReference> getCertificateReferences() {
        return this.certificateReferences;
    }

    public List<BatchNodeError> getErrors() {
        return this.errors;
    }

    public Boolean isDedicated() {
        return this.isDedicated;
    }

    public BatchNodeEndpointConfiguration getEndpointConfiguration() {
        return this.endpointConfiguration;
    }

    public BatchNodeAgentInfo getNodeAgentInfo() {
        return this.nodeAgentInfo;
    }

    public VirtualMachineInfo getVirtualMachineInfo() {
        return this.virtualMachineInfo;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("url", this.url);
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeStringField("schedulingState", this.schedulingState == null ? null : this.schedulingState.toString());
        jsonWriter.writeStringField("stateTransitionTime", this.stateTransitionTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.stateTransitionTime));
        jsonWriter.writeStringField("lastBootTime", this.lastBootTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastBootTime));
        jsonWriter.writeStringField("allocationTime", this.allocationTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.allocationTime));
        jsonWriter.writeStringField("ipAddress", this.ipAddress);
        jsonWriter.writeStringField("affinityId", this.affinityId);
        jsonWriter.writeStringField("vmSize", this.vmSize);
        jsonWriter.writeNumberField("totalTasksRun", (Number)this.totalTasksRun);
        jsonWriter.writeNumberField("runningTasksCount", (Number)this.runningTasksCount);
        jsonWriter.writeNumberField("runningTaskSlotsCount", (Number)this.runningTaskSlotsCount);
        jsonWriter.writeNumberField("totalTasksSucceeded", (Number)this.totalTasksSucceeded);
        jsonWriter.writeArrayField("recentTasks", this.recentTasks, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("startTask", (JsonSerializable)this.startTask);
        jsonWriter.writeJsonField("startTaskInfo", (JsonSerializable)this.startTaskInfo);
        jsonWriter.writeArrayField("certificateReferences", this.certificateReferences, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("errors", this.errors, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeBooleanField("isDedicated", this.isDedicated);
        jsonWriter.writeJsonField("endpointConfiguration", (JsonSerializable)this.endpointConfiguration);
        jsonWriter.writeJsonField("nodeAgentInfo", (JsonSerializable)this.nodeAgentInfo);
        jsonWriter.writeJsonField("virtualMachineInfo", (JsonSerializable)this.virtualMachineInfo);
        return jsonWriter.writeEndObject();
    }

    public static BatchNode fromJson(JsonReader jsonReader) throws IOException {
        return (BatchNode)jsonReader.readObject(reader -> {
            BatchNode deserializedBatchNode = new BatchNode();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedBatchNode.id = reader.getString();
                    continue;
                }
                if ("url".equals(fieldName)) {
                    deserializedBatchNode.url = reader.getString();
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedBatchNode.state = BatchNodeState.fromString(reader.getString());
                    continue;
                }
                if ("schedulingState".equals(fieldName)) {
                    deserializedBatchNode.schedulingState = SchedulingState.fromString(reader.getString());
                    continue;
                }
                if ("stateTransitionTime".equals(fieldName)) {
                    deserializedBatchNode.stateTransitionTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastBootTime".equals(fieldName)) {
                    deserializedBatchNode.lastBootTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("allocationTime".equals(fieldName)) {
                    deserializedBatchNode.allocationTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("ipAddress".equals(fieldName)) {
                    deserializedBatchNode.ipAddress = reader.getString();
                    continue;
                }
                if ("affinityId".equals(fieldName)) {
                    deserializedBatchNode.affinityId = reader.getString();
                    continue;
                }
                if ("vmSize".equals(fieldName)) {
                    deserializedBatchNode.vmSize = reader.getString();
                    continue;
                }
                if ("totalTasksRun".equals(fieldName)) {
                    deserializedBatchNode.totalTasksRun = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("runningTasksCount".equals(fieldName)) {
                    deserializedBatchNode.runningTasksCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("runningTaskSlotsCount".equals(fieldName)) {
                    deserializedBatchNode.runningTaskSlotsCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("totalTasksSucceeded".equals(fieldName)) {
                    deserializedBatchNode.totalTasksSucceeded = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("recentTasks".equals(fieldName)) {
                    List recentTasks;
                    deserializedBatchNode.recentTasks = recentTasks = reader.readArray(reader1 -> BatchTaskInfo.fromJson(reader1));
                    continue;
                }
                if ("startTask".equals(fieldName)) {
                    deserializedBatchNode.startTask = BatchStartTask.fromJson(reader);
                    continue;
                }
                if ("startTaskInfo".equals(fieldName)) {
                    deserializedBatchNode.startTaskInfo = BatchStartTaskInfo.fromJson(reader);
                    continue;
                }
                if ("certificateReferences".equals(fieldName)) {
                    List certificateReferences;
                    deserializedBatchNode.certificateReferences = certificateReferences = reader.readArray(reader1 -> BatchCertificateReference.fromJson(reader1));
                    continue;
                }
                if ("errors".equals(fieldName)) {
                    List errors;
                    deserializedBatchNode.errors = errors = reader.readArray(reader1 -> BatchNodeError.fromJson(reader1));
                    continue;
                }
                if ("isDedicated".equals(fieldName)) {
                    deserializedBatchNode.isDedicated = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("endpointConfiguration".equals(fieldName)) {
                    deserializedBatchNode.endpointConfiguration = BatchNodeEndpointConfiguration.fromJson(reader);
                    continue;
                }
                if ("nodeAgentInfo".equals(fieldName)) {
                    deserializedBatchNode.nodeAgentInfo = BatchNodeAgentInfo.fromJson(reader);
                    continue;
                }
                if ("virtualMachineInfo".equals(fieldName)) {
                    deserializedBatchNode.virtualMachineInfo = VirtualMachineInfo.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBatchNode;
        });
    }
}

