/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.BatchJobConstraints;
import com.azure.compute.batch.models.BatchJobManagerTask;
import com.azure.compute.batch.models.BatchJobNetworkConfiguration;
import com.azure.compute.batch.models.BatchJobPreparationTask;
import com.azure.compute.batch.models.BatchJobReleaseTask;
import com.azure.compute.batch.models.BatchPoolInfo;
import com.azure.compute.batch.models.EnvironmentSetting;
import com.azure.compute.batch.models.MetadataItem;
import com.azure.compute.batch.models.OnAllBatchTasksComplete;
import com.azure.compute.batch.models.OnBatchTaskFailure;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class BatchJobSpecification
implements JsonSerializable<BatchJobSpecification> {
    private Integer priority;
    private Boolean allowTaskPreemption;
    private Integer maxParallelTasks;
    private String displayName;
    private Boolean usesTaskDependencies;
    private OnAllBatchTasksComplete onAllTasksComplete;
    private OnBatchTaskFailure onTaskFailure;
    private BatchJobNetworkConfiguration networkConfiguration;
    private BatchJobConstraints constraints;
    private BatchJobManagerTask jobManagerTask;
    private BatchJobPreparationTask jobPreparationTask;
    private BatchJobReleaseTask jobReleaseTask;
    private List<EnvironmentSetting> commonEnvironmentSettings;
    private final BatchPoolInfo poolInfo;
    private List<MetadataItem> metadata;

    public BatchJobSpecification(BatchPoolInfo poolInfo) {
        this.poolInfo = poolInfo;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public BatchJobSpecification setPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    public Boolean isAllowTaskPreemption() {
        return this.allowTaskPreemption;
    }

    public BatchJobSpecification setAllowTaskPreemption(Boolean allowTaskPreemption) {
        this.allowTaskPreemption = allowTaskPreemption;
        return this;
    }

    public Integer getMaxParallelTasks() {
        return this.maxParallelTasks;
    }

    public BatchJobSpecification setMaxParallelTasks(Integer maxParallelTasks) {
        this.maxParallelTasks = maxParallelTasks;
        return this;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public BatchJobSpecification setDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public Boolean isUsesTaskDependencies() {
        return this.usesTaskDependencies;
    }

    public BatchJobSpecification setUsesTaskDependencies(Boolean usesTaskDependencies) {
        this.usesTaskDependencies = usesTaskDependencies;
        return this;
    }

    public OnAllBatchTasksComplete getOnAllTasksComplete() {
        return this.onAllTasksComplete;
    }

    public BatchJobSpecification setOnAllTasksComplete(OnAllBatchTasksComplete onAllTasksComplete) {
        this.onAllTasksComplete = onAllTasksComplete;
        return this;
    }

    public OnBatchTaskFailure getOnTaskFailure() {
        return this.onTaskFailure;
    }

    public BatchJobSpecification setOnTaskFailure(OnBatchTaskFailure onTaskFailure) {
        this.onTaskFailure = onTaskFailure;
        return this;
    }

    public BatchJobNetworkConfiguration getNetworkConfiguration() {
        return this.networkConfiguration;
    }

    public BatchJobSpecification setNetworkConfiguration(BatchJobNetworkConfiguration networkConfiguration) {
        this.networkConfiguration = networkConfiguration;
        return this;
    }

    public BatchJobConstraints getConstraints() {
        return this.constraints;
    }

    public BatchJobSpecification setConstraints(BatchJobConstraints constraints) {
        this.constraints = constraints;
        return this;
    }

    public BatchJobManagerTask getJobManagerTask() {
        return this.jobManagerTask;
    }

    public BatchJobSpecification setJobManagerTask(BatchJobManagerTask jobManagerTask) {
        this.jobManagerTask = jobManagerTask;
        return this;
    }

    public BatchJobPreparationTask getJobPreparationTask() {
        return this.jobPreparationTask;
    }

    public BatchJobSpecification setJobPreparationTask(BatchJobPreparationTask jobPreparationTask) {
        this.jobPreparationTask = jobPreparationTask;
        return this;
    }

    public BatchJobReleaseTask getJobReleaseTask() {
        return this.jobReleaseTask;
    }

    public BatchJobSpecification setJobReleaseTask(BatchJobReleaseTask jobReleaseTask) {
        this.jobReleaseTask = jobReleaseTask;
        return this;
    }

    public List<EnvironmentSetting> getCommonEnvironmentSettings() {
        return this.commonEnvironmentSettings;
    }

    public BatchJobSpecification setCommonEnvironmentSettings(List<EnvironmentSetting> commonEnvironmentSettings) {
        this.commonEnvironmentSettings = commonEnvironmentSettings;
        return this;
    }

    public BatchPoolInfo getPoolInfo() {
        return this.poolInfo;
    }

    public List<MetadataItem> getMetadata() {
        return this.metadata;
    }

    public BatchJobSpecification setMetadata(List<MetadataItem> metadata) {
        this.metadata = metadata;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("poolInfo", (JsonSerializable)this.poolInfo);
        jsonWriter.writeNumberField("priority", (Number)this.priority);
        jsonWriter.writeBooleanField("allowTaskPreemption", this.allowTaskPreemption);
        jsonWriter.writeNumberField("maxParallelTasks", (Number)this.maxParallelTasks);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeBooleanField("usesTaskDependencies", this.usesTaskDependencies);
        jsonWriter.writeStringField("onAllTasksComplete", this.onAllTasksComplete == null ? null : this.onAllTasksComplete.toString());
        jsonWriter.writeStringField("onTaskFailure", this.onTaskFailure == null ? null : this.onTaskFailure.toString());
        jsonWriter.writeJsonField("networkConfiguration", (JsonSerializable)this.networkConfiguration);
        jsonWriter.writeJsonField("constraints", (JsonSerializable)this.constraints);
        jsonWriter.writeJsonField("jobManagerTask", (JsonSerializable)this.jobManagerTask);
        jsonWriter.writeJsonField("jobPreparationTask", (JsonSerializable)this.jobPreparationTask);
        jsonWriter.writeJsonField("jobReleaseTask", (JsonSerializable)this.jobReleaseTask);
        jsonWriter.writeArrayField("commonEnvironmentSettings", this.commonEnvironmentSettings, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("metadata", this.metadata, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static BatchJobSpecification fromJson(JsonReader jsonReader) throws IOException {
        return (BatchJobSpecification)jsonReader.readObject(reader -> {
            BatchPoolInfo poolInfo = null;
            Integer priority = null;
            Boolean allowTaskPreemption = null;
            Integer maxParallelTasks = null;
            String displayName = null;
            Boolean usesTaskDependencies = null;
            OnAllBatchTasksComplete onAllTasksComplete = null;
            OnBatchTaskFailure onTaskFailure = null;
            BatchJobNetworkConfiguration networkConfiguration = null;
            BatchJobConstraints constraints = null;
            BatchJobManagerTask jobManagerTask = null;
            BatchJobPreparationTask jobPreparationTask = null;
            BatchJobReleaseTask jobReleaseTask = null;
            List commonEnvironmentSettings = null;
            List metadata = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("poolInfo".equals(fieldName)) {
                    poolInfo = BatchPoolInfo.fromJson(reader);
                    continue;
                }
                if ("priority".equals(fieldName)) {
                    priority = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("allowTaskPreemption".equals(fieldName)) {
                    allowTaskPreemption = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("maxParallelTasks".equals(fieldName)) {
                    maxParallelTasks = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    displayName = reader.getString();
                    continue;
                }
                if ("usesTaskDependencies".equals(fieldName)) {
                    usesTaskDependencies = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("onAllTasksComplete".equals(fieldName)) {
                    onAllTasksComplete = OnAllBatchTasksComplete.fromString(reader.getString());
                    continue;
                }
                if ("onTaskFailure".equals(fieldName)) {
                    onTaskFailure = OnBatchTaskFailure.fromString(reader.getString());
                    continue;
                }
                if ("networkConfiguration".equals(fieldName)) {
                    networkConfiguration = BatchJobNetworkConfiguration.fromJson(reader);
                    continue;
                }
                if ("constraints".equals(fieldName)) {
                    constraints = BatchJobConstraints.fromJson(reader);
                    continue;
                }
                if ("jobManagerTask".equals(fieldName)) {
                    jobManagerTask = BatchJobManagerTask.fromJson(reader);
                    continue;
                }
                if ("jobPreparationTask".equals(fieldName)) {
                    jobPreparationTask = BatchJobPreparationTask.fromJson(reader);
                    continue;
                }
                if ("jobReleaseTask".equals(fieldName)) {
                    jobReleaseTask = BatchJobReleaseTask.fromJson(reader);
                    continue;
                }
                if ("commonEnvironmentSettings".equals(fieldName)) {
                    commonEnvironmentSettings = reader.readArray(reader1 -> EnvironmentSetting.fromJson(reader1));
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    metadata = reader.readArray(reader1 -> MetadataItem.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            BatchJobSpecification deserializedBatchJobSpecification = new BatchJobSpecification(poolInfo);
            deserializedBatchJobSpecification.priority = priority;
            deserializedBatchJobSpecification.allowTaskPreemption = allowTaskPreemption;
            deserializedBatchJobSpecification.maxParallelTasks = maxParallelTasks;
            deserializedBatchJobSpecification.displayName = displayName;
            deserializedBatchJobSpecification.usesTaskDependencies = usesTaskDependencies;
            deserializedBatchJobSpecification.onAllTasksComplete = onAllTasksComplete;
            deserializedBatchJobSpecification.onTaskFailure = onTaskFailure;
            deserializedBatchJobSpecification.networkConfiguration = networkConfiguration;
            deserializedBatchJobSpecification.constraints = constraints;
            deserializedBatchJobSpecification.jobManagerTask = jobManagerTask;
            deserializedBatchJobSpecification.jobPreparationTask = jobPreparationTask;
            deserializedBatchJobSpecification.jobReleaseTask = jobReleaseTask;
            deserializedBatchJobSpecification.commonEnvironmentSettings = commonEnvironmentSettings;
            deserializedBatchJobSpecification.metadata = metadata;
            return deserializedBatchJobSpecification;
        });
    }
}

