/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class BatchJobNetworkConfiguration
implements JsonSerializable<BatchJobNetworkConfiguration> {
    private final String subnetId;
    private final boolean skipWithdrawFromVNet;

    public BatchJobNetworkConfiguration(String subnetId, boolean skipWithdrawFromVNet) {
        this.subnetId = subnetId;
        this.skipWithdrawFromVNet = skipWithdrawFromVNet;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public boolean isSkipWithdrawFromVNet() {
        return this.skipWithdrawFromVNet;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("subnetId", this.subnetId);
        jsonWriter.writeBooleanField("skipWithdrawFromVNet", this.skipWithdrawFromVNet);
        return jsonWriter.writeEndObject();
    }

    public static BatchJobNetworkConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (BatchJobNetworkConfiguration)jsonReader.readObject(reader -> {
            String subnetId = null;
            boolean skipWithdrawFromVNet = false;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("subnetId".equals(fieldName)) {
                    subnetId = reader.getString();
                    continue;
                }
                if ("skipWithdrawFromVNet".equals(fieldName)) {
                    skipWithdrawFromVNet = reader.getBoolean();
                    continue;
                }
                reader.skipChildren();
            }
            return new BatchJobNetworkConfiguration(subnetId, skipWithdrawFromVNet);
        });
    }
}

