/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.BatchJobSchedulingError;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class BatchJobExecutionInfo
implements JsonSerializable<BatchJobExecutionInfo> {
    private final OffsetDateTime startTime;
    private OffsetDateTime endTime;
    private String poolId;
    private BatchJobSchedulingError schedulingError;
    private String terminationReason;

    private BatchJobExecutionInfo(OffsetDateTime startTime) {
        this.startTime = startTime;
    }

    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    public OffsetDateTime getEndTime() {
        return this.endTime;
    }

    public String getPoolId() {
        return this.poolId;
    }

    public BatchJobSchedulingError getSchedulingError() {
        return this.schedulingError;
    }

    public String getTerminationReason() {
        return this.terminationReason;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("startTime", this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("endTime", this.endTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endTime));
        jsonWriter.writeStringField("poolId", this.poolId);
        jsonWriter.writeJsonField("schedulingError", (JsonSerializable)this.schedulingError);
        jsonWriter.writeStringField("terminateReason", this.terminationReason);
        return jsonWriter.writeEndObject();
    }

    public static BatchJobExecutionInfo fromJson(JsonReader jsonReader) throws IOException {
        return (BatchJobExecutionInfo)jsonReader.readObject(reader -> {
            OffsetDateTime startTime = null;
            OffsetDateTime endTime = null;
            String poolId = null;
            BatchJobSchedulingError schedulingError = null;
            String terminationReason = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("startTime".equals(fieldName)) {
                    startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    endTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("poolId".equals(fieldName)) {
                    poolId = reader.getString();
                    continue;
                }
                if ("schedulingError".equals(fieldName)) {
                    schedulingError = BatchJobSchedulingError.fromJson(reader);
                    continue;
                }
                if ("terminateReason".equals(fieldName)) {
                    terminationReason = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            BatchJobExecutionInfo deserializedBatchJobExecutionInfo = new BatchJobExecutionInfo(startTime);
            deserializedBatchJobExecutionInfo.endTime = endTime;
            deserializedBatchJobExecutionInfo.poolId = poolId;
            deserializedBatchJobExecutionInfo.schedulingError = schedulingError;
            deserializedBatchJobExecutionInfo.terminationReason = terminationReason;
            return deserializedBatchJobExecutionInfo;
        });
    }
}

