/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.BatchJobConstraints;
import com.azure.compute.batch.models.BatchJobExecutionInfo;
import com.azure.compute.batch.models.BatchJobManagerTask;
import com.azure.compute.batch.models.BatchJobNetworkConfiguration;
import com.azure.compute.batch.models.BatchJobPreparationTask;
import com.azure.compute.batch.models.BatchJobReleaseTask;
import com.azure.compute.batch.models.BatchJobState;
import com.azure.compute.batch.models.BatchJobStatistics;
import com.azure.compute.batch.models.BatchPoolInfo;
import com.azure.compute.batch.models.EnvironmentSetting;
import com.azure.compute.batch.models.MetadataItem;
import com.azure.compute.batch.models.OnAllBatchTasksComplete;
import com.azure.compute.batch.models.OnBatchTaskFailure;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class BatchJob
implements JsonSerializable<BatchJob> {
    private String id;
    private String displayName;
    private Boolean usesTaskDependencies;
    private String url;
    private String eTag;
    private OffsetDateTime lastModified;
    private OffsetDateTime creationTime;
    private BatchJobState state;
    private OffsetDateTime stateTransitionTime;
    private BatchJobState previousState;
    private OffsetDateTime previousStateTransitionTime;
    private Integer priority;
    private Boolean allowTaskPreemption;
    private Integer maxParallelTasks;
    private BatchJobConstraints constraints;
    private BatchJobManagerTask jobManagerTask;
    private BatchJobPreparationTask jobPreparationTask;
    private BatchJobReleaseTask jobReleaseTask;
    private List<EnvironmentSetting> commonEnvironmentSettings;
    private final BatchPoolInfo poolInfo;
    private OnAllBatchTasksComplete onAllTasksComplete;
    private OnBatchTaskFailure onTaskFailure;
    private BatchJobNetworkConfiguration networkConfiguration;
    private List<MetadataItem> metadata;
    private BatchJobExecutionInfo executionInfo;
    private BatchJobStatistics stats;

    public BatchJob(BatchPoolInfo poolInfo) {
        this.poolInfo = poolInfo;
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Boolean isUsesTaskDependencies() {
        return this.usesTaskDependencies;
    }

    public String getUrl() {
        return this.url;
    }

    public String getETag() {
        return this.eTag;
    }

    public OffsetDateTime getLastModified() {
        return this.lastModified;
    }

    public OffsetDateTime getCreationTime() {
        return this.creationTime;
    }

    public BatchJobState getState() {
        return this.state;
    }

    public OffsetDateTime getStateTransitionTime() {
        return this.stateTransitionTime;
    }

    public BatchJobState getPreviousState() {
        return this.previousState;
    }

    public OffsetDateTime getPreviousStateTransitionTime() {
        return this.previousStateTransitionTime;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public BatchJob setPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    public Boolean isAllowTaskPreemption() {
        return this.allowTaskPreemption;
    }

    public BatchJob setAllowTaskPreemption(Boolean allowTaskPreemption) {
        this.allowTaskPreemption = allowTaskPreemption;
        return this;
    }

    public Integer getMaxParallelTasks() {
        return this.maxParallelTasks;
    }

    public BatchJob setMaxParallelTasks(Integer maxParallelTasks) {
        this.maxParallelTasks = maxParallelTasks;
        return this;
    }

    public BatchJobConstraints getConstraints() {
        return this.constraints;
    }

    public BatchJob setConstraints(BatchJobConstraints constraints) {
        this.constraints = constraints;
        return this;
    }

    public BatchJobManagerTask getJobManagerTask() {
        return this.jobManagerTask;
    }

    public BatchJobPreparationTask getJobPreparationTask() {
        return this.jobPreparationTask;
    }

    public BatchJobReleaseTask getJobReleaseTask() {
        return this.jobReleaseTask;
    }

    public List<EnvironmentSetting> getCommonEnvironmentSettings() {
        return this.commonEnvironmentSettings;
    }

    public BatchPoolInfo getPoolInfo() {
        return this.poolInfo;
    }

    public OnAllBatchTasksComplete getOnAllTasksComplete() {
        return this.onAllTasksComplete;
    }

    public BatchJob setOnAllTasksComplete(OnAllBatchTasksComplete onAllTasksComplete) {
        this.onAllTasksComplete = onAllTasksComplete;
        return this;
    }

    public OnBatchTaskFailure getOnTaskFailure() {
        return this.onTaskFailure;
    }

    public BatchJobNetworkConfiguration getNetworkConfiguration() {
        return this.networkConfiguration;
    }

    public List<MetadataItem> getMetadata() {
        return this.metadata;
    }

    public BatchJob setMetadata(List<MetadataItem> metadata) {
        this.metadata = metadata;
        return this;
    }

    public BatchJobExecutionInfo getExecutionInfo() {
        return this.executionInfo;
    }

    public BatchJobStatistics getStats() {
        return this.stats;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("poolInfo", (JsonSerializable)this.poolInfo);
        jsonWriter.writeNumberField("priority", (Number)this.priority);
        jsonWriter.writeBooleanField("allowTaskPreemption", this.allowTaskPreemption);
        jsonWriter.writeNumberField("maxParallelTasks", (Number)this.maxParallelTasks);
        jsonWriter.writeJsonField("constraints", (JsonSerializable)this.constraints);
        jsonWriter.writeStringField("onAllTasksComplete", this.onAllTasksComplete == null ? null : this.onAllTasksComplete.toString());
        jsonWriter.writeArrayField("metadata", this.metadata, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static BatchJob fromJson(JsonReader jsonReader) throws IOException {
        return (BatchJob)jsonReader.readObject(reader -> {
            BatchPoolInfo poolInfo = null;
            String id = null;
            String displayName = null;
            Boolean usesTaskDependencies = null;
            String url = null;
            String eTag = null;
            OffsetDateTime lastModified = null;
            OffsetDateTime creationTime = null;
            BatchJobState state = null;
            OffsetDateTime stateTransitionTime = null;
            BatchJobState previousState = null;
            OffsetDateTime previousStateTransitionTime = null;
            Integer priority = null;
            Boolean allowTaskPreemption = null;
            Integer maxParallelTasks = null;
            BatchJobConstraints constraints = null;
            BatchJobManagerTask jobManagerTask = null;
            BatchJobPreparationTask jobPreparationTask = null;
            BatchJobReleaseTask jobReleaseTask = null;
            List commonEnvironmentSettings = null;
            OnAllBatchTasksComplete onAllTasksComplete = null;
            OnBatchTaskFailure onTaskFailure = null;
            BatchJobNetworkConfiguration networkConfiguration = null;
            List metadata = null;
            BatchJobExecutionInfo executionInfo = null;
            BatchJobStatistics stats = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("poolInfo".equals(fieldName)) {
                    poolInfo = BatchPoolInfo.fromJson(reader);
                    continue;
                }
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    displayName = reader.getString();
                    continue;
                }
                if ("usesTaskDependencies".equals(fieldName)) {
                    usesTaskDependencies = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("url".equals(fieldName)) {
                    url = reader.getString();
                    continue;
                }
                if ("eTag".equals(fieldName)) {
                    eTag = reader.getString();
                    continue;
                }
                if ("lastModified".equals(fieldName)) {
                    lastModified = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("creationTime".equals(fieldName)) {
                    creationTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("state".equals(fieldName)) {
                    state = BatchJobState.fromString(reader.getString());
                    continue;
                }
                if ("stateTransitionTime".equals(fieldName)) {
                    stateTransitionTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("previousState".equals(fieldName)) {
                    previousState = BatchJobState.fromString(reader.getString());
                    continue;
                }
                if ("previousStateTransitionTime".equals(fieldName)) {
                    previousStateTransitionTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("priority".equals(fieldName)) {
                    priority = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("allowTaskPreemption".equals(fieldName)) {
                    allowTaskPreemption = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("maxParallelTasks".equals(fieldName)) {
                    maxParallelTasks = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("constraints".equals(fieldName)) {
                    constraints = BatchJobConstraints.fromJson(reader);
                    continue;
                }
                if ("jobManagerTask".equals(fieldName)) {
                    jobManagerTask = BatchJobManagerTask.fromJson(reader);
                    continue;
                }
                if ("jobPreparationTask".equals(fieldName)) {
                    jobPreparationTask = BatchJobPreparationTask.fromJson(reader);
                    continue;
                }
                if ("jobReleaseTask".equals(fieldName)) {
                    jobReleaseTask = BatchJobReleaseTask.fromJson(reader);
                    continue;
                }
                if ("commonEnvironmentSettings".equals(fieldName)) {
                    commonEnvironmentSettings = reader.readArray(reader1 -> EnvironmentSetting.fromJson(reader1));
                    continue;
                }
                if ("onAllTasksComplete".equals(fieldName)) {
                    onAllTasksComplete = OnAllBatchTasksComplete.fromString(reader.getString());
                    continue;
                }
                if ("onTaskFailure".equals(fieldName)) {
                    onTaskFailure = OnBatchTaskFailure.fromString(reader.getString());
                    continue;
                }
                if ("networkConfiguration".equals(fieldName)) {
                    networkConfiguration = BatchJobNetworkConfiguration.fromJson(reader);
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    metadata = reader.readArray(reader1 -> MetadataItem.fromJson(reader1));
                    continue;
                }
                if ("executionInfo".equals(fieldName)) {
                    executionInfo = BatchJobExecutionInfo.fromJson(reader);
                    continue;
                }
                if ("stats".equals(fieldName)) {
                    stats = BatchJobStatistics.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            BatchJob deserializedBatchJob = new BatchJob(poolInfo);
            deserializedBatchJob.id = id;
            deserializedBatchJob.displayName = displayName;
            deserializedBatchJob.usesTaskDependencies = usesTaskDependencies;
            deserializedBatchJob.url = url;
            deserializedBatchJob.eTag = eTag;
            deserializedBatchJob.lastModified = lastModified;
            deserializedBatchJob.creationTime = creationTime;
            deserializedBatchJob.state = state;
            deserializedBatchJob.stateTransitionTime = stateTransitionTime;
            deserializedBatchJob.previousState = previousState;
            deserializedBatchJob.previousStateTransitionTime = previousStateTransitionTime;
            deserializedBatchJob.priority = priority;
            deserializedBatchJob.allowTaskPreemption = allowTaskPreemption;
            deserializedBatchJob.maxParallelTasks = maxParallelTasks;
            deserializedBatchJob.constraints = constraints;
            deserializedBatchJob.jobManagerTask = jobManagerTask;
            deserializedBatchJob.jobPreparationTask = jobPreparationTask;
            deserializedBatchJob.jobReleaseTask = jobReleaseTask;
            deserializedBatchJob.commonEnvironmentSettings = commonEnvironmentSettings;
            deserializedBatchJob.onAllTasksComplete = onAllTasksComplete;
            deserializedBatchJob.onTaskFailure = onTaskFailure;
            deserializedBatchJob.networkConfiguration = networkConfiguration;
            deserializedBatchJob.metadata = metadata;
            deserializedBatchJob.executionInfo = executionInfo;
            deserializedBatchJob.stats = stats;
            return deserializedBatchJob;
        });
    }
}

