/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.BatchErrorDetail;
import com.azure.compute.batch.models.BatchErrorMessage;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpResponse;
import com.azure.json.JsonProviders;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;

public final class BatchError
implements JsonSerializable<BatchError> {
    private final String code;
    private BatchErrorMessage message;
    private List<BatchErrorDetail> values;

    private BatchError(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public BatchErrorMessage getMessage() {
        return this.message;
    }

    public List<BatchErrorDetail> getValues() {
        return this.values;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("code", this.code);
        jsonWriter.writeJsonField("message", (JsonSerializable)this.message);
        jsonWriter.writeArrayField("values", this.values, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static BatchError fromJson(JsonReader jsonReader) throws IOException {
        return (BatchError)jsonReader.readObject(reader -> {
            String code = null;
            BatchErrorMessage message = null;
            List values = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("code".equals(fieldName)) {
                    code = reader.getString();
                    continue;
                }
                if ("message".equals(fieldName)) {
                    message = BatchErrorMessage.fromJson(reader);
                    continue;
                }
                if ("values".equals(fieldName)) {
                    values = reader.readArray(reader1 -> BatchErrorDetail.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            BatchError deserializedBatchError = new BatchError(code);
            deserializedBatchError.message = message;
            deserializedBatchError.values = values;
            return deserializedBatchError;
        });
    }

    public static BatchError fromException(HttpResponseException err) {
        if (err == null) {
            return null;
        }
        HttpResponse response = err.getResponse();
        if (response == null) {
            return null;
        }
        String bodyastring = (String)response.getBodyAsString().block();
        if (bodyastring == null) {
            return null;
        }
        try {
            JsonReader jsonReader = JsonProviders.createReader((Reader)new StringReader(bodyastring));
            return BatchError.fromJson(jsonReader);
        }
        catch (IOException e) {
            return null;
        }
    }
}

