/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.phonenumbers;

import com.azure.communication.common.implementation.CommunicationConnectionString;
import com.azure.communication.common.implementation.HmacAuthenticationPolicy;
import com.azure.communication.phonenumbers.PhoneNumbersAsyncClient;
import com.azure.communication.phonenumbers.PhoneNumbersClient;
import com.azure.communication.phonenumbers.PhoneNumbersServiceVersion;
import com.azure.communication.phonenumbers.implementation.PhoneNumberAdminClientImpl;
import com.azure.communication.phonenumbers.implementation.PhoneNumberAdminClientImplBuilder;
import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.client.traits.AzureKeyCredentialTrait;
import com.azure.core.client.traits.ConfigurationTrait;
import com.azure.core.client.traits.ConnectionStringTrait;
import com.azure.core.client.traits.EndpointTrait;
import com.azure.core.client.traits.HttpTrait;
import com.azure.core.client.traits.TokenCredentialTrait;
import com.azure.core.credential.AzureKeyCredential;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.builder.ClientBuilderUtil;
import com.azure.core.util.logging.ClientLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ServiceClientBuilder(serviceClients={PhoneNumbersClient.class, PhoneNumbersAsyncClient.class})
public final class PhoneNumbersClientBuilder
implements AzureKeyCredentialTrait<PhoneNumbersClientBuilder>,
ConfigurationTrait<PhoneNumbersClientBuilder>,
ConnectionStringTrait<PhoneNumbersClientBuilder>,
EndpointTrait<PhoneNumbersClientBuilder>,
HttpTrait<PhoneNumbersClientBuilder>,
TokenCredentialTrait<PhoneNumbersClientBuilder> {
    private static final Map<String, String> PROPERTIES = CoreUtils.getProperties((String)"azure-communication-phonenumbers.properties");
    private static final String SDK_NAME = "name";
    private static final String SDK_VERSION = "version";
    private final ClientLogger logger = new ClientLogger(PhoneNumbersClientBuilder.class);
    private PhoneNumbersServiceVersion version;
    private String endpoint;
    private HttpPipeline pipeline;
    private HttpClient httpClient;
    private HttpLogOptions httpLogOptions;
    private AzureKeyCredential azureKeyCredential;
    private TokenCredential tokenCredential;
    private Configuration configuration;
    private ClientOptions clientOptions;
    private RetryPolicy retryPolicy;
    private RetryOptions retryOptions;
    private final List<HttpPipelinePolicy> additionalPolicies = new ArrayList<HttpPipelinePolicy>();
    private String acceptLanguage;

    public PhoneNumbersClientBuilder endpoint(String endpoint) {
        this.endpoint = Objects.requireNonNull(endpoint, "'endpoint' cannot be null.");
        return this;
    }

    public PhoneNumbersClientBuilder pipeline(HttpPipeline pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    public PhoneNumbersClientBuilder httpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public PhoneNumbersClientBuilder httpLogOptions(HttpLogOptions httpLogOptions) {
        this.httpLogOptions = httpLogOptions;
        return this;
    }

    public PhoneNumbersClientBuilder credential(AzureKeyCredential keyCredential) {
        this.azureKeyCredential = Objects.requireNonNull(keyCredential, "'keyCredential' cannot be null.");
        return this;
    }

    public PhoneNumbersClientBuilder credential(TokenCredential tokenCredential) {
        this.tokenCredential = Objects.requireNonNull(tokenCredential, "'tokenCredential' cannot be null.");
        return this;
    }

    public PhoneNumbersClientBuilder connectionString(String connectionString) {
        Objects.requireNonNull(connectionString, "'connectionString' cannot be null.");
        CommunicationConnectionString connectionStringObject = new CommunicationConnectionString(connectionString);
        String endpoint = connectionStringObject.getEndpoint();
        String accessKey = connectionStringObject.getAccessKey();
        this.endpoint(endpoint).credential(new AzureKeyCredential(accessKey));
        return this;
    }

    public PhoneNumbersClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public PhoneNumbersClientBuilder addPolicy(HttpPipelinePolicy policy) {
        this.additionalPolicies.add(Objects.requireNonNull(policy, "'policy' cannot be null."));
        return this;
    }

    public PhoneNumbersClientBuilder clientOptions(ClientOptions clientOptions) {
        this.clientOptions = Objects.requireNonNull(clientOptions, "'clientOptions' cannot be null.");
        return this;
    }

    public PhoneNumbersClientBuilder serviceVersion(PhoneNumbersServiceVersion version) {
        this.version = version;
        return this;
    }

    public PhoneNumbersClientBuilder retryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public PhoneNumbersClientBuilder retryOptions(RetryOptions retryOptions) {
        this.retryOptions = retryOptions;
        return this;
    }

    public PhoneNumbersClientBuilder acceptLanguage(String acceptLanguage) {
        this.acceptLanguage = acceptLanguage;
        return this;
    }

    public PhoneNumbersClient buildClient() {
        this.validateRequiredFields();
        if (this.version != null) {
            this.logger.info("Build client for service version" + this.version.getVersion());
        }
        PhoneNumberAdminClientImpl adminClient = this.createPhoneNumberAdminClient();
        return new PhoneNumbersClient(adminClient, this.createPhoneNumberAsyncClient(adminClient, this.acceptLanguage));
    }

    public PhoneNumbersAsyncClient buildAsyncClient() {
        this.validateRequiredFields();
        if (this.version != null) {
            this.logger.info("Build client for service version" + this.version.getVersion());
        }
        return this.createPhoneNumberAsyncClient(this.createPhoneNumberAdminClient(), this.acceptLanguage);
    }

    PhoneNumbersAsyncClient createPhoneNumberAsyncClient(PhoneNumberAdminClientImpl phoneNumberAdminClient) {
        return this.createPhoneNumberAsyncClient(phoneNumberAdminClient, null);
    }

    PhoneNumbersAsyncClient createPhoneNumberAsyncClient(PhoneNumberAdminClientImpl phoneNumberAdminClient, String acceptLanguage) {
        return new PhoneNumbersAsyncClient(phoneNumberAdminClient, acceptLanguage);
    }

    HttpPipelinePolicy createAuthenticationPolicy() {
        if (this.tokenCredential != null && this.azureKeyCredential != null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Both 'credential' and 'keyCredential' are set. Just one may be used."));
        }
        if (this.tokenCredential != null) {
            return new BearerTokenAuthenticationPolicy(this.tokenCredential, new String[]{"https://communication.azure.com//.default"});
        }
        if (this.azureKeyCredential != null) {
            return new HmacAuthenticationPolicy(this.azureKeyCredential);
        }
        throw this.logger.logExceptionAsError((RuntimeException)new NullPointerException("Missing credential information while building a client."));
    }

    UserAgentPolicy createUserAgentPolicy(String applicationId, String sdkName, String sdkVersion, Configuration configuration) {
        return new UserAgentPolicy(applicationId, sdkName, sdkVersion, configuration);
    }

    HttpPipelinePolicy createRequestIdPolicy() {
        return new RequestIdPolicy();
    }

    CookiePolicy createCookiePolicy() {
        return new CookiePolicy();
    }

    HttpLoggingPolicy createHttpLoggingPolicy(HttpLogOptions httpLogOptions) {
        return new HttpLoggingPolicy(httpLogOptions);
    }

    HttpLogOptions createDefaultHttpLogOptions() {
        return new HttpLogOptions();
    }

    private void validateRequiredFields() {
        Objects.requireNonNull(this.endpoint);
    }

    private PhoneNumberAdminClientImpl createPhoneNumberAdminClient() {
        PhoneNumberAdminClientImplBuilder clientBuilder = new PhoneNumberAdminClientImplBuilder();
        return clientBuilder.endpoint(this.endpoint).pipeline(this.createHttpPipeline()).buildClient();
    }

    private HttpPipeline createHttpPipeline() {
        if (this.pipeline != null) {
            return this.pipeline;
        }
        ArrayList<Object> policyList = new ArrayList<Object>();
        ClientOptions buildClientOptions = this.clientOptions == null ? new ClientOptions() : this.clientOptions;
        HttpLogOptions buildLogOptions = this.httpLogOptions == null ? new HttpLogOptions() : this.httpLogOptions;
        String applicationId = null;
        if (!CoreUtils.isNullOrEmpty((CharSequence)buildClientOptions.getApplicationId())) {
            applicationId = buildClientOptions.getApplicationId();
        } else if (!CoreUtils.isNullOrEmpty((CharSequence)buildLogOptions.getApplicationId())) {
            applicationId = buildLogOptions.getApplicationId();
        }
        policyList.add(this.createUserAgentPolicy(applicationId, PROPERTIES.get(SDK_NAME), PROPERTIES.get(SDK_VERSION), this.configuration));
        policyList.add(this.createRequestIdPolicy());
        policyList.add(ClientBuilderUtil.validateAndGetRetryPolicy((HttpPipelinePolicy)this.retryPolicy, (RetryOptions)this.retryOptions));
        policyList.add(this.createAuthenticationPolicy());
        policyList.add(this.createCookiePolicy());
        if (this.additionalPolicies.size() > 0) {
            policyList.addAll(this.additionalPolicies);
        }
        policyList.add(this.createHttpLoggingPolicy(this.getHttpLogOptions()));
        return new HttpPipelineBuilder().policies(policyList.toArray(new HttpPipelinePolicy[0])).httpClient(this.httpClient).clientOptions(this.clientOptions).build();
    }

    private HttpLogOptions getHttpLogOptions() {
        if (this.httpLogOptions == null) {
            this.httpLogOptions = this.createDefaultHttpLogOptions();
        }
        return this.httpLogOptions;
    }
}

