/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.phonenumbers.models;

import com.azure.communication.phonenumbers.implementation.accesshelpers.PhoneNumbersReservationAccessHelper;
import com.azure.communication.phonenumbers.models.AvailablePhoneNumber;
import com.azure.communication.phonenumbers.models.PhoneNumbersReservationStatus;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.UUID;

public final class PhoneNumbersReservation
implements JsonSerializable<PhoneNumbersReservation> {
    private UUID id;
    private OffsetDateTime expiresAt;
    private Map<String, AvailablePhoneNumber> phoneNumbers;
    private PhoneNumbersReservationStatus status;

    public OffsetDateTime getExpiresAt() {
        return this.expiresAt;
    }

    public Map<String, AvailablePhoneNumber> getPhoneNumbers() {
        return this.phoneNumbers;
    }

    public PhoneNumbersReservationStatus getStatus() {
        return this.status;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.id != null) {
            jsonWriter.writeStringField("id", this.id.toString());
        }
        if (this.expiresAt != null) {
            jsonWriter.writeStringField("expiresAt", this.expiresAt.toString());
        }
        if (this.phoneNumbers != null) {
            jsonWriter.writeMapField("phoneNumbers", this.phoneNumbers, (writer, value) -> {
                if (value != null) {
                    value.toJson((JsonWriter)writer);
                } else {
                    writer.writeNull();
                }
            });
        }
        if (this.status != null) {
            jsonWriter.writeStringField("status", this.status.toString());
        }
        return jsonWriter.writeEndObject();
    }

    public static PhoneNumbersReservation fromJson(JsonReader jsonReader) throws IOException {
        return (PhoneNumbersReservation)jsonReader.readObject(reader -> {
            PhoneNumbersReservation deserializedPhoneNumbersReservation = new PhoneNumbersReservation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedPhoneNumbersReservation.id = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                if ("expiresAt".equals(fieldName)) {
                    deserializedPhoneNumbersReservation.expiresAt = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("phoneNumbers".equals(fieldName)) {
                    Map phoneNumbers;
                    deserializedPhoneNumbersReservation.phoneNumbers = phoneNumbers = reader.readMap(reader1 -> AvailablePhoneNumber.fromJson(reader1));
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedPhoneNumbersReservation.status = PhoneNumbersReservationStatus.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPhoneNumbersReservation;
        });
    }

    private PhoneNumbersReservation setPhoneNumbers(Map<String, AvailablePhoneNumber> phoneNumbers) {
        this.phoneNumbers = phoneNumbers;
        return this;
    }

    public String getId() {
        return this.id.toString();
    }

    static {
        PhoneNumbersReservationAccessHelper.setAccessor(new PhoneNumbersReservationAccessHelper.PhoneNumbersReservationAccessor(){

            @Override
            public void setPhoneNumbers(PhoneNumbersReservation reservation, Map<String, AvailablePhoneNumber> phoneNumbers) {
                reservation.setPhoneNumbers(phoneNumbers);
            }
        });
    }
}

