/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.phonenumbers.implementation;

import com.azure.communication.phonenumbers.implementation.PhoneNumberAdminClientImpl;
import com.azure.communication.phonenumbers.implementation.models.CommunicationErrorResponseException;
import com.azure.communication.phonenumbers.implementation.models.OfferingsResponse;
import com.azure.communication.phonenumbers.implementation.models.OperatorInformationRequest;
import com.azure.communication.phonenumbers.implementation.models.PhoneNumberAreaCodes;
import com.azure.communication.phonenumbers.implementation.models.PhoneNumberCapabilitiesRequest;
import com.azure.communication.phonenumbers.implementation.models.PhoneNumberCountries;
import com.azure.communication.phonenumbers.implementation.models.PhoneNumberLocalities;
import com.azure.communication.phonenumbers.implementation.models.PhoneNumberPurchaseRequest;
import com.azure.communication.phonenumbers.implementation.models.PhoneNumberRawOperation;
import com.azure.communication.phonenumbers.implementation.models.PhoneNumberSearchRequest;
import com.azure.communication.phonenumbers.implementation.models.PhoneNumbersGetOperationHeaders;
import com.azure.communication.phonenumbers.implementation.models.PhoneNumbersPurchasePhoneNumbersHeaders;
import com.azure.communication.phonenumbers.implementation.models.PhoneNumbersPurchaseReservationHeaders;
import com.azure.communication.phonenumbers.implementation.models.PhoneNumbersReleasePhoneNumberHeaders;
import com.azure.communication.phonenumbers.implementation.models.PhoneNumbersReservationPurchaseRequest;
import com.azure.communication.phonenumbers.implementation.models.PhoneNumbersReservations;
import com.azure.communication.phonenumbers.implementation.models.PhoneNumbersSearchAvailablePhoneNumbersHeaders;
import com.azure.communication.phonenumbers.implementation.models.PhoneNumbersUpdateCapabilitiesHeaders;
import com.azure.communication.phonenumbers.implementation.models.PurchasedPhoneNumbers;
import com.azure.communication.phonenumbers.models.BrowsePhoneNumbersOptions;
import com.azure.communication.phonenumbers.models.OperatorInformationResult;
import com.azure.communication.phonenumbers.models.PhoneNumberAreaCode;
import com.azure.communication.phonenumbers.models.PhoneNumberAssignmentType;
import com.azure.communication.phonenumbers.models.PhoneNumberCountry;
import com.azure.communication.phonenumbers.models.PhoneNumberLocality;
import com.azure.communication.phonenumbers.models.PhoneNumberOffering;
import com.azure.communication.phonenumbers.models.PhoneNumberSearchResult;
import com.azure.communication.phonenumbers.models.PhoneNumberType;
import com.azure.communication.phonenumbers.models.PhoneNumbersBrowseResult;
import com.azure.communication.phonenumbers.models.PhoneNumbersReservation;
import com.azure.communication.phonenumbers.models.PurchasedPhoneNumber;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import java.util.UUID;
import reactor.core.publisher.Mono;

public final class PhoneNumbersImpl {
    private final PhoneNumbersService service;
    private final PhoneNumberAdminClientImpl client;

    PhoneNumbersImpl(PhoneNumberAdminClientImpl client) {
        this.service = (PhoneNumbersService)RestProxy.create(PhoneNumbersService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<PhoneNumberAreaCode>> listAreaCodesSinglePageAsync(String countryCode, PhoneNumberType phoneNumberType, Integer skip, Integer maxPageSize, PhoneNumberAssignmentType assignmentType, String locality, String administrativeDivision, String acceptLanguage) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listAreaCodes(this.client.getEndpoint(), countryCode, phoneNumberType, skip, maxPageSize, assignmentType, locality, administrativeDivision, this.client.getApiVersion(), acceptLanguage, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PhoneNumberAreaCodes)res.getValue()).getAreaCodes(), ((PhoneNumberAreaCodes)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<PhoneNumberAreaCode>> listAreaCodesSinglePageAsync(String countryCode, PhoneNumberType phoneNumberType, Integer skip, Integer maxPageSize, PhoneNumberAssignmentType assignmentType, String locality, String administrativeDivision, String acceptLanguage, Context context) {
        String accept = "application/json";
        return this.service.listAreaCodes(this.client.getEndpoint(), countryCode, phoneNumberType, skip, maxPageSize, assignmentType, locality, administrativeDivision, this.client.getApiVersion(), acceptLanguage, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PhoneNumberAreaCodes)res.getValue()).getAreaCodes(), ((PhoneNumberAreaCodes)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PhoneNumberAreaCode> listAreaCodesAsync(String countryCode, PhoneNumberType phoneNumberType, Integer skip, Integer maxPageSize, PhoneNumberAssignmentType assignmentType, String locality, String administrativeDivision, String acceptLanguage) {
        return new PagedFlux(() -> this.listAreaCodesSinglePageAsync(countryCode, phoneNumberType, skip, maxPageSize, assignmentType, locality, administrativeDivision, acceptLanguage), nextLink -> this.listAreaCodesNextSinglePageAsync((String)nextLink, acceptLanguage));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PhoneNumberAreaCode> listAreaCodesAsync(String countryCode, PhoneNumberType phoneNumberType, Integer skip, Integer maxPageSize, PhoneNumberAssignmentType assignmentType, String locality, String administrativeDivision, String acceptLanguage, Context context) {
        return new PagedFlux(() -> this.listAreaCodesSinglePageAsync(countryCode, phoneNumberType, skip, maxPageSize, assignmentType, locality, administrativeDivision, acceptLanguage, context), nextLink -> this.listAreaCodesNextSinglePageAsync((String)nextLink, acceptLanguage, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<PhoneNumberAreaCode> listAreaCodesSinglePage(String countryCode, PhoneNumberType phoneNumberType, Integer skip, Integer maxPageSize, PhoneNumberAssignmentType assignmentType, String locality, String administrativeDivision, String acceptLanguage) {
        return (PagedResponse)this.listAreaCodesSinglePageAsync(countryCode, phoneNumberType, skip, maxPageSize, assignmentType, locality, administrativeDivision, acceptLanguage).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<PhoneNumberAreaCode> listAreaCodesSinglePage(String countryCode, PhoneNumberType phoneNumberType, Integer skip, Integer maxPageSize, PhoneNumberAssignmentType assignmentType, String locality, String administrativeDivision, String acceptLanguage, Context context) {
        return (PagedResponse)this.listAreaCodesSinglePageAsync(countryCode, phoneNumberType, skip, maxPageSize, assignmentType, locality, administrativeDivision, acceptLanguage, context).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PhoneNumberAreaCode> listAreaCodes(String countryCode, PhoneNumberType phoneNumberType, Integer skip, Integer maxPageSize, PhoneNumberAssignmentType assignmentType, String locality, String administrativeDivision, String acceptLanguage) {
        return new PagedIterable(this.listAreaCodesAsync(countryCode, phoneNumberType, skip, maxPageSize, assignmentType, locality, administrativeDivision, acceptLanguage));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PhoneNumberAreaCode> listAreaCodes(String countryCode, PhoneNumberType phoneNumberType, Integer skip, Integer maxPageSize, PhoneNumberAssignmentType assignmentType, String locality, String administrativeDivision, String acceptLanguage, Context context) {
        return new PagedIterable(this.listAreaCodesAsync(countryCode, phoneNumberType, skip, maxPageSize, assignmentType, locality, administrativeDivision, acceptLanguage, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<PhoneNumberCountry>> listAvailableCountriesSinglePageAsync(Integer skip, Integer maxPageSize, String acceptLanguage) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listAvailableCountries(this.client.getEndpoint(), skip, maxPageSize, this.client.getApiVersion(), acceptLanguage, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PhoneNumberCountries)res.getValue()).getCountries(), ((PhoneNumberCountries)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<PhoneNumberCountry>> listAvailableCountriesSinglePageAsync(Integer skip, Integer maxPageSize, String acceptLanguage, Context context) {
        String accept = "application/json";
        return this.service.listAvailableCountries(this.client.getEndpoint(), skip, maxPageSize, this.client.getApiVersion(), acceptLanguage, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PhoneNumberCountries)res.getValue()).getCountries(), ((PhoneNumberCountries)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PhoneNumberCountry> listAvailableCountriesAsync(Integer skip, Integer maxPageSize, String acceptLanguage) {
        return new PagedFlux(() -> this.listAvailableCountriesSinglePageAsync(skip, maxPageSize, acceptLanguage), nextLink -> this.listAvailableCountriesNextSinglePageAsync((String)nextLink, acceptLanguage));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PhoneNumberCountry> listAvailableCountriesAsync(Integer skip, Integer maxPageSize, String acceptLanguage, Context context) {
        return new PagedFlux(() -> this.listAvailableCountriesSinglePageAsync(skip, maxPageSize, acceptLanguage, context), nextLink -> this.listAvailableCountriesNextSinglePageAsync((String)nextLink, acceptLanguage, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<PhoneNumberCountry> listAvailableCountriesSinglePage(Integer skip, Integer maxPageSize, String acceptLanguage) {
        return (PagedResponse)this.listAvailableCountriesSinglePageAsync(skip, maxPageSize, acceptLanguage).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<PhoneNumberCountry> listAvailableCountriesSinglePage(Integer skip, Integer maxPageSize, String acceptLanguage, Context context) {
        return (PagedResponse)this.listAvailableCountriesSinglePageAsync(skip, maxPageSize, acceptLanguage, context).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PhoneNumberCountry> listAvailableCountries(Integer skip, Integer maxPageSize, String acceptLanguage) {
        return new PagedIterable(this.listAvailableCountriesAsync(skip, maxPageSize, acceptLanguage));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PhoneNumberCountry> listAvailableCountries(Integer skip, Integer maxPageSize, String acceptLanguage, Context context) {
        return new PagedIterable(this.listAvailableCountriesAsync(skip, maxPageSize, acceptLanguage, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PhoneNumbersBrowseResult>> browseAvailableNumbersWithResponseAsync(String countryCode, BrowsePhoneNumbersOptions phoneNumbersBrowseRequest) {
        return FluxUtil.withContext(context -> this.browseAvailableNumbersWithResponseAsync(countryCode, phoneNumbersBrowseRequest, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PhoneNumbersBrowseResult>> browseAvailableNumbersWithResponseAsync(String countryCode, BrowsePhoneNumbersOptions phoneNumbersBrowseRequest, Context context) {
        String accept = "application/json";
        return this.service.browseAvailableNumbers(this.client.getEndpoint(), this.client.getApiVersion(), countryCode, phoneNumbersBrowseRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PhoneNumbersBrowseResult> browseAvailableNumbersAsync(String countryCode, BrowsePhoneNumbersOptions phoneNumbersBrowseRequest) {
        return this.browseAvailableNumbersWithResponseAsync(countryCode, phoneNumbersBrowseRequest).flatMap(res -> Mono.justOrEmpty((Object)((PhoneNumbersBrowseResult)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PhoneNumbersBrowseResult> browseAvailableNumbersAsync(String countryCode, BrowsePhoneNumbersOptions phoneNumbersBrowseRequest, Context context) {
        return this.browseAvailableNumbersWithResponseAsync(countryCode, phoneNumbersBrowseRequest, context).flatMap(res -> Mono.justOrEmpty((Object)((PhoneNumbersBrowseResult)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PhoneNumbersBrowseResult> browseAvailableNumbersWithResponse(String countryCode, BrowsePhoneNumbersOptions phoneNumbersBrowseRequest, Context context) {
        return (Response)this.browseAvailableNumbersWithResponseAsync(countryCode, phoneNumbersBrowseRequest, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PhoneNumbersBrowseResult browseAvailableNumbers(String countryCode, BrowsePhoneNumbersOptions phoneNumbersBrowseRequest) {
        return (PhoneNumbersBrowseResult)this.browseAvailableNumbersWithResponse(countryCode, phoneNumbersBrowseRequest, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<PhoneNumberLocality>> listAvailableLocalitiesSinglePageAsync(String countryCode, Integer skip, Integer maxPageSize, String administrativeDivision, String acceptLanguage) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listAvailableLocalities(this.client.getEndpoint(), countryCode, skip, maxPageSize, administrativeDivision, this.client.getApiVersion(), acceptLanguage, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PhoneNumberLocalities)res.getValue()).getPhoneNumberLocalities(), ((PhoneNumberLocalities)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<PhoneNumberLocality>> listAvailableLocalitiesSinglePageAsync(String countryCode, Integer skip, Integer maxPageSize, String administrativeDivision, String acceptLanguage, Context context) {
        String accept = "application/json";
        return this.service.listAvailableLocalities(this.client.getEndpoint(), countryCode, skip, maxPageSize, administrativeDivision, this.client.getApiVersion(), acceptLanguage, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PhoneNumberLocalities)res.getValue()).getPhoneNumberLocalities(), ((PhoneNumberLocalities)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PhoneNumberLocality> listAvailableLocalitiesAsync(String countryCode, Integer skip, Integer maxPageSize, String administrativeDivision, String acceptLanguage) {
        return new PagedFlux(() -> this.listAvailableLocalitiesSinglePageAsync(countryCode, skip, maxPageSize, administrativeDivision, acceptLanguage), nextLink -> this.listAvailableLocalitiesNextSinglePageAsync((String)nextLink, acceptLanguage));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PhoneNumberLocality> listAvailableLocalitiesAsync(String countryCode, Integer skip, Integer maxPageSize, String administrativeDivision, String acceptLanguage, Context context) {
        return new PagedFlux(() -> this.listAvailableLocalitiesSinglePageAsync(countryCode, skip, maxPageSize, administrativeDivision, acceptLanguage, context), nextLink -> this.listAvailableLocalitiesNextSinglePageAsync((String)nextLink, acceptLanguage, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<PhoneNumberLocality> listAvailableLocalitiesSinglePage(String countryCode, Integer skip, Integer maxPageSize, String administrativeDivision, String acceptLanguage) {
        return (PagedResponse)this.listAvailableLocalitiesSinglePageAsync(countryCode, skip, maxPageSize, administrativeDivision, acceptLanguage).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<PhoneNumberLocality> listAvailableLocalitiesSinglePage(String countryCode, Integer skip, Integer maxPageSize, String administrativeDivision, String acceptLanguage, Context context) {
        return (PagedResponse)this.listAvailableLocalitiesSinglePageAsync(countryCode, skip, maxPageSize, administrativeDivision, acceptLanguage, context).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PhoneNumberLocality> listAvailableLocalities(String countryCode, Integer skip, Integer maxPageSize, String administrativeDivision, String acceptLanguage) {
        return new PagedIterable(this.listAvailableLocalitiesAsync(countryCode, skip, maxPageSize, administrativeDivision, acceptLanguage));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PhoneNumberLocality> listAvailableLocalities(String countryCode, Integer skip, Integer maxPageSize, String administrativeDivision, String acceptLanguage, Context context) {
        return new PagedIterable(this.listAvailableLocalitiesAsync(countryCode, skip, maxPageSize, administrativeDivision, acceptLanguage, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<PhoneNumberOffering>> listOfferingsSinglePageAsync(String countryCode, Integer skip, Integer maxPageSize, PhoneNumberType phoneNumberType, PhoneNumberAssignmentType assignmentType, String acceptLanguage) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listOfferings(this.client.getEndpoint(), countryCode, skip, maxPageSize, phoneNumberType, assignmentType, this.client.getApiVersion(), acceptLanguage, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((OfferingsResponse)res.getValue()).getPhoneNumberOfferings(), ((OfferingsResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<PhoneNumberOffering>> listOfferingsSinglePageAsync(String countryCode, Integer skip, Integer maxPageSize, PhoneNumberType phoneNumberType, PhoneNumberAssignmentType assignmentType, String acceptLanguage, Context context) {
        String accept = "application/json";
        return this.service.listOfferings(this.client.getEndpoint(), countryCode, skip, maxPageSize, phoneNumberType, assignmentType, this.client.getApiVersion(), acceptLanguage, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((OfferingsResponse)res.getValue()).getPhoneNumberOfferings(), ((OfferingsResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PhoneNumberOffering> listOfferingsAsync(String countryCode, Integer skip, Integer maxPageSize, PhoneNumberType phoneNumberType, PhoneNumberAssignmentType assignmentType, String acceptLanguage) {
        return new PagedFlux(() -> this.listOfferingsSinglePageAsync(countryCode, skip, maxPageSize, phoneNumberType, assignmentType, acceptLanguage), nextLink -> this.listOfferingsNextSinglePageAsync((String)nextLink, acceptLanguage));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PhoneNumberOffering> listOfferingsAsync(String countryCode, Integer skip, Integer maxPageSize, PhoneNumberType phoneNumberType, PhoneNumberAssignmentType assignmentType, String acceptLanguage, Context context) {
        return new PagedFlux(() -> this.listOfferingsSinglePageAsync(countryCode, skip, maxPageSize, phoneNumberType, assignmentType, acceptLanguage, context), nextLink -> this.listOfferingsNextSinglePageAsync((String)nextLink, acceptLanguage, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<PhoneNumberOffering> listOfferingsSinglePage(String countryCode, Integer skip, Integer maxPageSize, PhoneNumberType phoneNumberType, PhoneNumberAssignmentType assignmentType, String acceptLanguage) {
        return (PagedResponse)this.listOfferingsSinglePageAsync(countryCode, skip, maxPageSize, phoneNumberType, assignmentType, acceptLanguage).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<PhoneNumberOffering> listOfferingsSinglePage(String countryCode, Integer skip, Integer maxPageSize, PhoneNumberType phoneNumberType, PhoneNumberAssignmentType assignmentType, String acceptLanguage, Context context) {
        return (PagedResponse)this.listOfferingsSinglePageAsync(countryCode, skip, maxPageSize, phoneNumberType, assignmentType, acceptLanguage, context).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PhoneNumberOffering> listOfferings(String countryCode, Integer skip, Integer maxPageSize, PhoneNumberType phoneNumberType, PhoneNumberAssignmentType assignmentType, String acceptLanguage) {
        return new PagedIterable(this.listOfferingsAsync(countryCode, skip, maxPageSize, phoneNumberType, assignmentType, acceptLanguage));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PhoneNumberOffering> listOfferings(String countryCode, Integer skip, Integer maxPageSize, PhoneNumberType phoneNumberType, PhoneNumberAssignmentType assignmentType, String acceptLanguage, Context context) {
        return new PagedIterable(this.listOfferingsAsync(countryCode, skip, maxPageSize, phoneNumberType, assignmentType, acceptLanguage, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<PhoneNumbersReservation>> listReservationsSinglePageAsync(Integer maxPageSize) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listReservations(this.client.getEndpoint(), this.client.getApiVersion(), maxPageSize, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PhoneNumbersReservations)res.getValue()).getReservations(), ((PhoneNumbersReservations)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<PhoneNumbersReservation>> listReservationsSinglePageAsync(Integer maxPageSize, Context context) {
        String accept = "application/json";
        return this.service.listReservations(this.client.getEndpoint(), this.client.getApiVersion(), maxPageSize, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PhoneNumbersReservations)res.getValue()).getReservations(), ((PhoneNumbersReservations)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PhoneNumbersReservation> listReservationsAsync(Integer maxPageSize) {
        return new PagedFlux(() -> this.listReservationsSinglePageAsync(maxPageSize), nextLink -> this.listReservationsNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PhoneNumbersReservation> listReservationsAsync(Integer maxPageSize, Context context) {
        return new PagedFlux(() -> this.listReservationsSinglePageAsync(maxPageSize, context), nextLink -> this.listReservationsNextSinglePageAsync((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<PhoneNumbersReservation> listReservationsSinglePage(Integer maxPageSize) {
        return (PagedResponse)this.listReservationsSinglePageAsync(maxPageSize).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<PhoneNumbersReservation> listReservationsSinglePage(Integer maxPageSize, Context context) {
        return (PagedResponse)this.listReservationsSinglePageAsync(maxPageSize, context).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PhoneNumbersReservation> listReservations(Integer maxPageSize) {
        return new PagedIterable(this.listReservationsAsync(maxPageSize));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PhoneNumbersReservation> listReservations(Integer maxPageSize, Context context) {
        return new PagedIterable(this.listReservationsAsync(maxPageSize, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PhoneNumbersReservation>> createOrUpdateReservationWithResponseAsync(UUID reservationId, PhoneNumbersReservation reservation) {
        return FluxUtil.withContext(context -> this.createOrUpdateReservationWithResponseAsync(reservationId, reservation, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PhoneNumbersReservation>> createOrUpdateReservationWithResponseAsync(UUID reservationId, PhoneNumbersReservation reservation, Context context) {
        String accept = "application/json";
        return this.service.createOrUpdateReservation(this.client.getEndpoint(), this.client.getApiVersion(), reservationId, reservation, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PhoneNumbersReservation> createOrUpdateReservationAsync(UUID reservationId, PhoneNumbersReservation reservation) {
        return this.createOrUpdateReservationWithResponseAsync(reservationId, reservation).flatMap(res -> Mono.justOrEmpty((Object)((PhoneNumbersReservation)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PhoneNumbersReservation> createOrUpdateReservationAsync(UUID reservationId, PhoneNumbersReservation reservation, Context context) {
        return this.createOrUpdateReservationWithResponseAsync(reservationId, reservation, context).flatMap(res -> Mono.justOrEmpty((Object)((PhoneNumbersReservation)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PhoneNumbersReservation> createOrUpdateReservationWithResponse(UUID reservationId, PhoneNumbersReservation reservation, Context context) {
        return (Response)this.createOrUpdateReservationWithResponseAsync(reservationId, reservation, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PhoneNumbersReservation createOrUpdateReservation(UUID reservationId, PhoneNumbersReservation reservation) {
        return (PhoneNumbersReservation)this.createOrUpdateReservationWithResponse(reservationId, reservation, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PhoneNumbersReservation>> getReservationWithResponseAsync(UUID reservationId) {
        return FluxUtil.withContext(context -> this.getReservationWithResponseAsync(reservationId, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PhoneNumbersReservation>> getReservationWithResponseAsync(UUID reservationId, Context context) {
        String accept = "application/json";
        return this.service.getReservation(this.client.getEndpoint(), this.client.getApiVersion(), reservationId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PhoneNumbersReservation> getReservationAsync(UUID reservationId) {
        return this.getReservationWithResponseAsync(reservationId).flatMap(res -> Mono.justOrEmpty((Object)((PhoneNumbersReservation)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PhoneNumbersReservation> getReservationAsync(UUID reservationId, Context context) {
        return this.getReservationWithResponseAsync(reservationId, context).flatMap(res -> Mono.justOrEmpty((Object)((PhoneNumbersReservation)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PhoneNumbersReservation> getReservationWithResponse(UUID reservationId, Context context) {
        return (Response)this.getReservationWithResponseAsync(reservationId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PhoneNumbersReservation getReservation(UUID reservationId) {
        return (PhoneNumbersReservation)this.getReservationWithResponse(reservationId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteReservationWithResponseAsync(UUID reservationId) {
        return FluxUtil.withContext(context -> this.deleteReservationWithResponseAsync(reservationId, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteReservationWithResponseAsync(UUID reservationId, Context context) {
        String accept = "application/json";
        return this.service.deleteReservation(this.client.getEndpoint(), this.client.getApiVersion(), reservationId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteReservationAsync(UUID reservationId) {
        return this.deleteReservationWithResponseAsync(reservationId).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteReservationAsync(UUID reservationId, Context context) {
        return this.deleteReservationWithResponseAsync(reservationId, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteReservationWithResponse(UUID reservationId, Context context) {
        return (Response)this.deleteReservationWithResponseAsync(reservationId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteReservation(UUID reservationId) {
        this.deleteReservationWithResponse(reservationId, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<PhoneNumbersPurchaseReservationHeaders, Void>> purchaseReservationWithResponseAsync(UUID reservationId, PhoneNumbersReservationPurchaseRequest reservationPurchaseRequest) {
        return FluxUtil.withContext(context -> this.purchaseReservationWithResponseAsync(reservationId, reservationPurchaseRequest, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<PhoneNumbersPurchaseReservationHeaders, Void>> purchaseReservationWithResponseAsync(UUID reservationId, PhoneNumbersReservationPurchaseRequest reservationPurchaseRequest, Context context) {
        String accept = "application/json";
        return this.service.purchaseReservation(this.client.getEndpoint(), this.client.getApiVersion(), reservationId, reservationPurchaseRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> purchaseReservationAsync(UUID reservationId, PhoneNumbersReservationPurchaseRequest reservationPurchaseRequest) {
        return this.purchaseReservationWithResponseAsync(reservationId, reservationPurchaseRequest).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> purchaseReservationAsync(UUID reservationId, PhoneNumbersReservationPurchaseRequest reservationPurchaseRequest, Context context) {
        return this.purchaseReservationWithResponseAsync(reservationId, reservationPurchaseRequest, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<PhoneNumbersPurchaseReservationHeaders, Void> purchaseReservationWithResponse(UUID reservationId, PhoneNumbersReservationPurchaseRequest reservationPurchaseRequest, Context context) {
        return (ResponseBase)this.purchaseReservationWithResponseAsync(reservationId, reservationPurchaseRequest, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void purchaseReservation(UUID reservationId, PhoneNumbersReservationPurchaseRequest reservationPurchaseRequest) {
        this.purchaseReservationWithResponse(reservationId, reservationPurchaseRequest, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> purchaseReservationNoCustomHeadersWithResponseAsync(UUID reservationId, PhoneNumbersReservationPurchaseRequest reservationPurchaseRequest) {
        return FluxUtil.withContext(context -> this.purchaseReservationNoCustomHeadersWithResponseAsync(reservationId, reservationPurchaseRequest, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> purchaseReservationNoCustomHeadersWithResponseAsync(UUID reservationId, PhoneNumbersReservationPurchaseRequest reservationPurchaseRequest, Context context) {
        String accept = "application/json";
        return this.service.purchaseReservationNoCustomHeaders(this.client.getEndpoint(), this.client.getApiVersion(), reservationId, reservationPurchaseRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> purchaseReservationNoCustomHeadersWithResponse(UUID reservationId, PhoneNumbersReservationPurchaseRequest reservationPurchaseRequest, Context context) {
        return (Response)this.purchaseReservationNoCustomHeadersWithResponseAsync(reservationId, reservationPurchaseRequest, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<PhoneNumbersSearchAvailablePhoneNumbersHeaders, PhoneNumberSearchResult>> searchAvailablePhoneNumbersWithResponseAsync(String countryCode, PhoneNumberSearchRequest body) {
        return FluxUtil.withContext(context -> this.searchAvailablePhoneNumbersWithResponseAsync(countryCode, body, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<PhoneNumbersSearchAvailablePhoneNumbersHeaders, PhoneNumberSearchResult>> searchAvailablePhoneNumbersWithResponseAsync(String countryCode, PhoneNumberSearchRequest body, Context context) {
        String accept = "application/json";
        return this.service.searchAvailablePhoneNumbers(this.client.getEndpoint(), countryCode, this.client.getApiVersion(), body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PhoneNumberSearchResult> searchAvailablePhoneNumbersAsync(String countryCode, PhoneNumberSearchRequest body) {
        return this.searchAvailablePhoneNumbersWithResponseAsync(countryCode, body).flatMap(res -> Mono.justOrEmpty((Object)((PhoneNumberSearchResult)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PhoneNumberSearchResult> searchAvailablePhoneNumbersAsync(String countryCode, PhoneNumberSearchRequest body, Context context) {
        return this.searchAvailablePhoneNumbersWithResponseAsync(countryCode, body, context).flatMap(res -> Mono.justOrEmpty((Object)((PhoneNumberSearchResult)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<PhoneNumbersSearchAvailablePhoneNumbersHeaders, PhoneNumberSearchResult> searchAvailablePhoneNumbersWithResponse(String countryCode, PhoneNumberSearchRequest body, Context context) {
        return (ResponseBase)this.searchAvailablePhoneNumbersWithResponseAsync(countryCode, body, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PhoneNumberSearchResult searchAvailablePhoneNumbers(String countryCode, PhoneNumberSearchRequest body) {
        return (PhoneNumberSearchResult)this.searchAvailablePhoneNumbersWithResponse(countryCode, body, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PhoneNumberSearchResult>> searchAvailablePhoneNumbersNoCustomHeadersWithResponseAsync(String countryCode, PhoneNumberSearchRequest body) {
        return FluxUtil.withContext(context -> this.searchAvailablePhoneNumbersNoCustomHeadersWithResponseAsync(countryCode, body, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PhoneNumberSearchResult>> searchAvailablePhoneNumbersNoCustomHeadersWithResponseAsync(String countryCode, PhoneNumberSearchRequest body, Context context) {
        String accept = "application/json";
        return this.service.searchAvailablePhoneNumbersNoCustomHeaders(this.client.getEndpoint(), countryCode, this.client.getApiVersion(), body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PhoneNumberSearchResult> searchAvailablePhoneNumbersNoCustomHeadersWithResponse(String countryCode, PhoneNumberSearchRequest body, Context context) {
        return (Response)this.searchAvailablePhoneNumbersNoCustomHeadersWithResponseAsync(countryCode, body, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PhoneNumberSearchResult>> getSearchResultWithResponseAsync(String searchId) {
        return FluxUtil.withContext(context -> this.getSearchResultWithResponseAsync(searchId, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PhoneNumberSearchResult>> getSearchResultWithResponseAsync(String searchId, Context context) {
        String accept = "application/json";
        return this.service.getSearchResult(this.client.getEndpoint(), searchId, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PhoneNumberSearchResult> getSearchResultAsync(String searchId) {
        return this.getSearchResultWithResponseAsync(searchId).flatMap(res -> Mono.justOrEmpty((Object)((PhoneNumberSearchResult)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PhoneNumberSearchResult> getSearchResultAsync(String searchId, Context context) {
        return this.getSearchResultWithResponseAsync(searchId, context).flatMap(res -> Mono.justOrEmpty((Object)((PhoneNumberSearchResult)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PhoneNumberSearchResult> getSearchResultWithResponse(String searchId, Context context) {
        return (Response)this.getSearchResultWithResponseAsync(searchId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PhoneNumberSearchResult getSearchResult(String searchId) {
        return (PhoneNumberSearchResult)this.getSearchResultWithResponse(searchId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<PhoneNumbersPurchasePhoneNumbersHeaders, Void>> purchasePhoneNumbersWithResponseAsync(PhoneNumberPurchaseRequest body) {
        return FluxUtil.withContext(context -> this.purchasePhoneNumbersWithResponseAsync(body, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<PhoneNumbersPurchasePhoneNumbersHeaders, Void>> purchasePhoneNumbersWithResponseAsync(PhoneNumberPurchaseRequest body, Context context) {
        String accept = "application/json";
        return this.service.purchasePhoneNumbers(this.client.getEndpoint(), this.client.getApiVersion(), body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> purchasePhoneNumbersAsync(PhoneNumberPurchaseRequest body) {
        return this.purchasePhoneNumbersWithResponseAsync(body).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> purchasePhoneNumbersAsync(PhoneNumberPurchaseRequest body, Context context) {
        return this.purchasePhoneNumbersWithResponseAsync(body, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<PhoneNumbersPurchasePhoneNumbersHeaders, Void> purchasePhoneNumbersWithResponse(PhoneNumberPurchaseRequest body, Context context) {
        return (ResponseBase)this.purchasePhoneNumbersWithResponseAsync(body, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void purchasePhoneNumbers(PhoneNumberPurchaseRequest body) {
        this.purchasePhoneNumbersWithResponse(body, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> purchasePhoneNumbersNoCustomHeadersWithResponseAsync(PhoneNumberPurchaseRequest body) {
        return FluxUtil.withContext(context -> this.purchasePhoneNumbersNoCustomHeadersWithResponseAsync(body, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> purchasePhoneNumbersNoCustomHeadersWithResponseAsync(PhoneNumberPurchaseRequest body, Context context) {
        String accept = "application/json";
        return this.service.purchasePhoneNumbersNoCustomHeaders(this.client.getEndpoint(), this.client.getApiVersion(), body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> purchasePhoneNumbersNoCustomHeadersWithResponse(PhoneNumberPurchaseRequest body, Context context) {
        return (Response)this.purchasePhoneNumbersNoCustomHeadersWithResponseAsync(body, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<PhoneNumbersGetOperationHeaders, PhoneNumberRawOperation>> getOperationWithResponseAsync(String operationId) {
        return FluxUtil.withContext(context -> this.getOperationWithResponseAsync(operationId, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<PhoneNumbersGetOperationHeaders, PhoneNumberRawOperation>> getOperationWithResponseAsync(String operationId, Context context) {
        String accept = "application/json";
        return this.service.getOperation(this.client.getEndpoint(), operationId, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PhoneNumberRawOperation> getOperationAsync(String operationId) {
        return this.getOperationWithResponseAsync(operationId).flatMap(res -> Mono.justOrEmpty((Object)((PhoneNumberRawOperation)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PhoneNumberRawOperation> getOperationAsync(String operationId, Context context) {
        return this.getOperationWithResponseAsync(operationId, context).flatMap(res -> Mono.justOrEmpty((Object)((PhoneNumberRawOperation)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<PhoneNumbersGetOperationHeaders, PhoneNumberRawOperation> getOperationWithResponse(String operationId, Context context) {
        return (ResponseBase)this.getOperationWithResponseAsync(operationId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PhoneNumberRawOperation getOperation(String operationId) {
        return (PhoneNumberRawOperation)this.getOperationWithResponse(operationId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PhoneNumberRawOperation>> getOperationNoCustomHeadersWithResponseAsync(String operationId) {
        return FluxUtil.withContext(context -> this.getOperationNoCustomHeadersWithResponseAsync(operationId, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PhoneNumberRawOperation>> getOperationNoCustomHeadersWithResponseAsync(String operationId, Context context) {
        String accept = "application/json";
        return this.service.getOperationNoCustomHeaders(this.client.getEndpoint(), operationId, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PhoneNumberRawOperation> getOperationNoCustomHeadersWithResponse(String operationId, Context context) {
        return (Response)this.getOperationNoCustomHeadersWithResponseAsync(operationId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> cancelOperationWithResponseAsync(String operationId) {
        return FluxUtil.withContext(context -> this.cancelOperationWithResponseAsync(operationId, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> cancelOperationWithResponseAsync(String operationId, Context context) {
        String accept = "application/json";
        return this.service.cancelOperation(this.client.getEndpoint(), operationId, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> cancelOperationAsync(String operationId) {
        return this.cancelOperationWithResponseAsync(operationId).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> cancelOperationAsync(String operationId, Context context) {
        return this.cancelOperationWithResponseAsync(operationId, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> cancelOperationWithResponse(String operationId, Context context) {
        return (Response)this.cancelOperationWithResponseAsync(operationId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void cancelOperation(String operationId) {
        this.cancelOperationWithResponse(operationId, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<PhoneNumbersUpdateCapabilitiesHeaders, PurchasedPhoneNumber>> updateCapabilitiesWithResponseAsync(String phoneNumber, PhoneNumberCapabilitiesRequest body) {
        return FluxUtil.withContext(context -> this.updateCapabilitiesWithResponseAsync(phoneNumber, body, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<PhoneNumbersUpdateCapabilitiesHeaders, PurchasedPhoneNumber>> updateCapabilitiesWithResponseAsync(String phoneNumber, PhoneNumberCapabilitiesRequest body, Context context) {
        String accept = "application/json";
        return this.service.updateCapabilities(this.client.getEndpoint(), phoneNumber, this.client.getApiVersion(), body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PurchasedPhoneNumber> updateCapabilitiesAsync(String phoneNumber, PhoneNumberCapabilitiesRequest body) {
        return this.updateCapabilitiesWithResponseAsync(phoneNumber, body).flatMap(res -> Mono.justOrEmpty((Object)((PurchasedPhoneNumber)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PurchasedPhoneNumber> updateCapabilitiesAsync(String phoneNumber, PhoneNumberCapabilitiesRequest body, Context context) {
        return this.updateCapabilitiesWithResponseAsync(phoneNumber, body, context).flatMap(res -> Mono.justOrEmpty((Object)((PurchasedPhoneNumber)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<PhoneNumbersUpdateCapabilitiesHeaders, PurchasedPhoneNumber> updateCapabilitiesWithResponse(String phoneNumber, PhoneNumberCapabilitiesRequest body, Context context) {
        return (ResponseBase)this.updateCapabilitiesWithResponseAsync(phoneNumber, body, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PurchasedPhoneNumber updateCapabilities(String phoneNumber, PhoneNumberCapabilitiesRequest body) {
        return (PurchasedPhoneNumber)this.updateCapabilitiesWithResponse(phoneNumber, body, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PurchasedPhoneNumber>> updateCapabilitiesNoCustomHeadersWithResponseAsync(String phoneNumber, PhoneNumberCapabilitiesRequest body) {
        return FluxUtil.withContext(context -> this.updateCapabilitiesNoCustomHeadersWithResponseAsync(phoneNumber, body, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PurchasedPhoneNumber>> updateCapabilitiesNoCustomHeadersWithResponseAsync(String phoneNumber, PhoneNumberCapabilitiesRequest body, Context context) {
        String accept = "application/json";
        return this.service.updateCapabilitiesNoCustomHeaders(this.client.getEndpoint(), phoneNumber, this.client.getApiVersion(), body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PurchasedPhoneNumber> updateCapabilitiesNoCustomHeadersWithResponse(String phoneNumber, PhoneNumberCapabilitiesRequest body, Context context) {
        return (Response)this.updateCapabilitiesNoCustomHeadersWithResponseAsync(phoneNumber, body, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PurchasedPhoneNumber>> getByNumberWithResponseAsync(String phoneNumber) {
        return FluxUtil.withContext(context -> this.getByNumberWithResponseAsync(phoneNumber, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PurchasedPhoneNumber>> getByNumberWithResponseAsync(String phoneNumber, Context context) {
        String accept = "application/json";
        return this.service.getByNumber(this.client.getEndpoint(), phoneNumber, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PurchasedPhoneNumber> getByNumberAsync(String phoneNumber) {
        return this.getByNumberWithResponseAsync(phoneNumber).flatMap(res -> Mono.justOrEmpty((Object)((PurchasedPhoneNumber)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PurchasedPhoneNumber> getByNumberAsync(String phoneNumber, Context context) {
        return this.getByNumberWithResponseAsync(phoneNumber, context).flatMap(res -> Mono.justOrEmpty((Object)((PurchasedPhoneNumber)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PurchasedPhoneNumber> getByNumberWithResponse(String phoneNumber, Context context) {
        return (Response)this.getByNumberWithResponseAsync(phoneNumber, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PurchasedPhoneNumber getByNumber(String phoneNumber) {
        return (PurchasedPhoneNumber)this.getByNumberWithResponse(phoneNumber, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<PhoneNumbersReleasePhoneNumberHeaders, Void>> releasePhoneNumberWithResponseAsync(String phoneNumber) {
        return FluxUtil.withContext(context -> this.releasePhoneNumberWithResponseAsync(phoneNumber, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<PhoneNumbersReleasePhoneNumberHeaders, Void>> releasePhoneNumberWithResponseAsync(String phoneNumber, Context context) {
        String accept = "application/json";
        return this.service.releasePhoneNumber(this.client.getEndpoint(), phoneNumber, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> releasePhoneNumberAsync(String phoneNumber) {
        return this.releasePhoneNumberWithResponseAsync(phoneNumber).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> releasePhoneNumberAsync(String phoneNumber, Context context) {
        return this.releasePhoneNumberWithResponseAsync(phoneNumber, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<PhoneNumbersReleasePhoneNumberHeaders, Void> releasePhoneNumberWithResponse(String phoneNumber, Context context) {
        return (ResponseBase)this.releasePhoneNumberWithResponseAsync(phoneNumber, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void releasePhoneNumber(String phoneNumber) {
        this.releasePhoneNumberWithResponse(phoneNumber, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> releasePhoneNumberNoCustomHeadersWithResponseAsync(String phoneNumber) {
        return FluxUtil.withContext(context -> this.releasePhoneNumberNoCustomHeadersWithResponseAsync(phoneNumber, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> releasePhoneNumberNoCustomHeadersWithResponseAsync(String phoneNumber, Context context) {
        String accept = "application/json";
        return this.service.releasePhoneNumberNoCustomHeaders(this.client.getEndpoint(), phoneNumber, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> releasePhoneNumberNoCustomHeadersWithResponse(String phoneNumber, Context context) {
        return (Response)this.releasePhoneNumberNoCustomHeadersWithResponseAsync(phoneNumber, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<PurchasedPhoneNumber>> listPhoneNumbersSinglePageAsync(Integer skip, Integer top) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listPhoneNumbers(this.client.getEndpoint(), skip, top, this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PurchasedPhoneNumbers)res.getValue()).getPhoneNumbers(), ((PurchasedPhoneNumbers)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<PurchasedPhoneNumber>> listPhoneNumbersSinglePageAsync(Integer skip, Integer top, Context context) {
        String accept = "application/json";
        return this.service.listPhoneNumbers(this.client.getEndpoint(), skip, top, this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PurchasedPhoneNumbers)res.getValue()).getPhoneNumbers(), ((PurchasedPhoneNumbers)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PurchasedPhoneNumber> listPhoneNumbersAsync(Integer skip, Integer top) {
        return new PagedFlux(() -> this.listPhoneNumbersSinglePageAsync(skip, top), nextLink -> this.listPhoneNumbersNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PurchasedPhoneNumber> listPhoneNumbersAsync(Integer skip, Integer top, Context context) {
        return new PagedFlux(() -> this.listPhoneNumbersSinglePageAsync(skip, top, context), nextLink -> this.listPhoneNumbersNextSinglePageAsync((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<PurchasedPhoneNumber> listPhoneNumbersSinglePage(Integer skip, Integer top) {
        return (PagedResponse)this.listPhoneNumbersSinglePageAsync(skip, top).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<PurchasedPhoneNumber> listPhoneNumbersSinglePage(Integer skip, Integer top, Context context) {
        return (PagedResponse)this.listPhoneNumbersSinglePageAsync(skip, top, context).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PurchasedPhoneNumber> listPhoneNumbers(Integer skip, Integer top) {
        return new PagedIterable(this.listPhoneNumbersAsync(skip, top));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PurchasedPhoneNumber> listPhoneNumbers(Integer skip, Integer top, Context context) {
        return new PagedIterable(this.listPhoneNumbersAsync(skip, top, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<OperatorInformationResult>> operatorInformationSearchWithResponseAsync(OperatorInformationRequest body) {
        return FluxUtil.withContext(context -> this.operatorInformationSearchWithResponseAsync(body, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<OperatorInformationResult>> operatorInformationSearchWithResponseAsync(OperatorInformationRequest body, Context context) {
        String accept = "application/json";
        return this.service.operatorInformationSearch(this.client.getEndpoint(), this.client.getApiVersion(), body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<OperatorInformationResult> operatorInformationSearchAsync(OperatorInformationRequest body) {
        return this.operatorInformationSearchWithResponseAsync(body).flatMap(res -> Mono.justOrEmpty((Object)((OperatorInformationResult)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<OperatorInformationResult> operatorInformationSearchAsync(OperatorInformationRequest body, Context context) {
        return this.operatorInformationSearchWithResponseAsync(body, context).flatMap(res -> Mono.justOrEmpty((Object)((OperatorInformationResult)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<OperatorInformationResult> operatorInformationSearchWithResponse(OperatorInformationRequest body, Context context) {
        return (Response)this.operatorInformationSearchWithResponseAsync(body, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperatorInformationResult operatorInformationSearch(OperatorInformationRequest body) {
        return (OperatorInformationResult)this.operatorInformationSearchWithResponse(body, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<PhoneNumberAreaCode>> listAreaCodesNextSinglePageAsync(String nextLink, String acceptLanguage) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listAreaCodesNext(nextLink, this.client.getEndpoint(), acceptLanguage, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PhoneNumberAreaCodes)res.getValue()).getAreaCodes(), ((PhoneNumberAreaCodes)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<PhoneNumberAreaCode>> listAreaCodesNextSinglePageAsync(String nextLink, String acceptLanguage, Context context) {
        String accept = "application/json";
        return this.service.listAreaCodesNext(nextLink, this.client.getEndpoint(), acceptLanguage, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PhoneNumberAreaCodes)res.getValue()).getAreaCodes(), ((PhoneNumberAreaCodes)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<PhoneNumberAreaCode> listAreaCodesNextSinglePage(String nextLink, String acceptLanguage) {
        return (PagedResponse)this.listAreaCodesNextSinglePageAsync(nextLink, acceptLanguage).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<PhoneNumberAreaCode> listAreaCodesNextSinglePage(String nextLink, String acceptLanguage, Context context) {
        return (PagedResponse)this.listAreaCodesNextSinglePageAsync(nextLink, acceptLanguage, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<PhoneNumberCountry>> listAvailableCountriesNextSinglePageAsync(String nextLink, String acceptLanguage) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listAvailableCountriesNext(nextLink, this.client.getEndpoint(), acceptLanguage, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PhoneNumberCountries)res.getValue()).getCountries(), ((PhoneNumberCountries)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<PhoneNumberCountry>> listAvailableCountriesNextSinglePageAsync(String nextLink, String acceptLanguage, Context context) {
        String accept = "application/json";
        return this.service.listAvailableCountriesNext(nextLink, this.client.getEndpoint(), acceptLanguage, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PhoneNumberCountries)res.getValue()).getCountries(), ((PhoneNumberCountries)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<PhoneNumberCountry> listAvailableCountriesNextSinglePage(String nextLink, String acceptLanguage) {
        return (PagedResponse)this.listAvailableCountriesNextSinglePageAsync(nextLink, acceptLanguage).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<PhoneNumberCountry> listAvailableCountriesNextSinglePage(String nextLink, String acceptLanguage, Context context) {
        return (PagedResponse)this.listAvailableCountriesNextSinglePageAsync(nextLink, acceptLanguage, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<PhoneNumberLocality>> listAvailableLocalitiesNextSinglePageAsync(String nextLink, String acceptLanguage) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listAvailableLocalitiesNext(nextLink, this.client.getEndpoint(), acceptLanguage, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PhoneNumberLocalities)res.getValue()).getPhoneNumberLocalities(), ((PhoneNumberLocalities)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<PhoneNumberLocality>> listAvailableLocalitiesNextSinglePageAsync(String nextLink, String acceptLanguage, Context context) {
        String accept = "application/json";
        return this.service.listAvailableLocalitiesNext(nextLink, this.client.getEndpoint(), acceptLanguage, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PhoneNumberLocalities)res.getValue()).getPhoneNumberLocalities(), ((PhoneNumberLocalities)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<PhoneNumberLocality> listAvailableLocalitiesNextSinglePage(String nextLink, String acceptLanguage) {
        return (PagedResponse)this.listAvailableLocalitiesNextSinglePageAsync(nextLink, acceptLanguage).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<PhoneNumberLocality> listAvailableLocalitiesNextSinglePage(String nextLink, String acceptLanguage, Context context) {
        return (PagedResponse)this.listAvailableLocalitiesNextSinglePageAsync(nextLink, acceptLanguage, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<PhoneNumberOffering>> listOfferingsNextSinglePageAsync(String nextLink, String acceptLanguage) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listOfferingsNext(nextLink, this.client.getEndpoint(), acceptLanguage, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((OfferingsResponse)res.getValue()).getPhoneNumberOfferings(), ((OfferingsResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<PhoneNumberOffering>> listOfferingsNextSinglePageAsync(String nextLink, String acceptLanguage, Context context) {
        String accept = "application/json";
        return this.service.listOfferingsNext(nextLink, this.client.getEndpoint(), acceptLanguage, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((OfferingsResponse)res.getValue()).getPhoneNumberOfferings(), ((OfferingsResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<PhoneNumberOffering> listOfferingsNextSinglePage(String nextLink, String acceptLanguage) {
        return (PagedResponse)this.listOfferingsNextSinglePageAsync(nextLink, acceptLanguage).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<PhoneNumberOffering> listOfferingsNextSinglePage(String nextLink, String acceptLanguage, Context context) {
        return (PagedResponse)this.listOfferingsNextSinglePageAsync(nextLink, acceptLanguage, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<PhoneNumbersReservation>> listReservationsNextSinglePageAsync(String nextLink) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listReservationsNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PhoneNumbersReservations)res.getValue()).getReservations(), ((PhoneNumbersReservations)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<PhoneNumbersReservation>> listReservationsNextSinglePageAsync(String nextLink, Context context) {
        String accept = "application/json";
        return this.service.listReservationsNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PhoneNumbersReservations)res.getValue()).getReservations(), ((PhoneNumbersReservations)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<PhoneNumbersReservation> listReservationsNextSinglePage(String nextLink) {
        return (PagedResponse)this.listReservationsNextSinglePageAsync(nextLink).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<PhoneNumbersReservation> listReservationsNextSinglePage(String nextLink, Context context) {
        return (PagedResponse)this.listReservationsNextSinglePageAsync(nextLink, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<PurchasedPhoneNumber>> listPhoneNumbersNextSinglePageAsync(String nextLink) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listPhoneNumbersNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PurchasedPhoneNumbers)res.getValue()).getPhoneNumbers(), ((PurchasedPhoneNumbers)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<PurchasedPhoneNumber>> listPhoneNumbersNextSinglePageAsync(String nextLink, Context context) {
        String accept = "application/json";
        return this.service.listPhoneNumbersNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PurchasedPhoneNumbers)res.getValue()).getPhoneNumbers(), ((PurchasedPhoneNumbers)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<PurchasedPhoneNumber> listPhoneNumbersNextSinglePage(String nextLink) {
        return (PagedResponse)this.listPhoneNumbersNextSinglePageAsync(nextLink).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<PurchasedPhoneNumber> listPhoneNumbersNextSinglePage(String nextLink, Context context) {
        return (PagedResponse)this.listPhoneNumbersNextSinglePageAsync(nextLink, context).block();
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="PhoneNumberAdminClientPhoneNumbers")
    public static interface PhoneNumbersService {
        @Get(value="/availablePhoneNumbers/countries/{countryCode}/areaCodes")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<PhoneNumberAreaCodes>> listAreaCodes(@HostParam(value="endpoint") String var1, @PathParam(value="countryCode") String var2, @QueryParam(value="phoneNumberType") PhoneNumberType var3, @QueryParam(value="skip") Integer var4, @QueryParam(value="maxPageSize") Integer var5, @QueryParam(value="assignmentType") PhoneNumberAssignmentType var6, @QueryParam(value="locality") String var7, @QueryParam(value="administrativeDivision") String var8, @QueryParam(value="api-version") String var9, @HeaderParam(value="accept-language") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Get(value="/availablePhoneNumbers/countries")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<PhoneNumberCountries>> listAvailableCountries(@HostParam(value="endpoint") String var1, @QueryParam(value="skip") Integer var2, @QueryParam(value="maxPageSize") Integer var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="accept-language") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Post(value="/availablePhoneNumbers/countries/{countryCode}/:browse")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<PhoneNumbersBrowseResult>> browseAvailableNumbers(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="countryCode") String var3, @BodyParam(value="application/json") BrowsePhoneNumbersOptions var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/availablePhoneNumbers/countries/{countryCode}/localities")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<PhoneNumberLocalities>> listAvailableLocalities(@HostParam(value="endpoint") String var1, @PathParam(value="countryCode") String var2, @QueryParam(value="skip") Integer var3, @QueryParam(value="maxPageSize") Integer var4, @QueryParam(value="administrativeDivision") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="accept-language") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Get(value="/availablePhoneNumbers/countries/{countryCode}/offerings")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<OfferingsResponse>> listOfferings(@HostParam(value="endpoint") String var1, @PathParam(value="countryCode") String var2, @QueryParam(value="skip") Integer var3, @QueryParam(value="maxPageSize") Integer var4, @QueryParam(value="phoneNumberType") PhoneNumberType var5, @QueryParam(value="assignmentType") PhoneNumberAssignmentType var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="accept-language") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Get(value="/availablePhoneNumbers/reservations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<PhoneNumbersReservations>> listReservations(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @QueryParam(value="maxPageSize") Integer var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Patch(value="/availablePhoneNumbers/reservations/{reservationId}")
        @ExpectedResponses(value={200, 201, 207})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<PhoneNumbersReservation>> createOrUpdateReservation(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="reservationId") UUID var3, @BodyParam(value="application/merge-patch+json") PhoneNumbersReservation var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/availablePhoneNumbers/reservations/{reservationId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<PhoneNumbersReservation>> getReservation(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="reservationId") UUID var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Delete(value="/availablePhoneNumbers/reservations/{reservationId}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<Void>> deleteReservation(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="reservationId") UUID var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/availablePhoneNumbers/reservations/{reservationId}/:purchase")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<ResponseBase<PhoneNumbersPurchaseReservationHeaders, Void>> purchaseReservation(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="reservationId") UUID var3, @BodyParam(value="application/json") PhoneNumbersReservationPurchaseRequest var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/availablePhoneNumbers/reservations/{reservationId}/:purchase")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<Void>> purchaseReservationNoCustomHeaders(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="reservationId") UUID var3, @BodyParam(value="application/json") PhoneNumbersReservationPurchaseRequest var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/availablePhoneNumbers/countries/{countryCode}/:search")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<ResponseBase<PhoneNumbersSearchAvailablePhoneNumbersHeaders, PhoneNumberSearchResult>> searchAvailablePhoneNumbers(@HostParam(value="endpoint") String var1, @PathParam(value="countryCode") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") PhoneNumberSearchRequest var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/availablePhoneNumbers/countries/{countryCode}/:search")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<PhoneNumberSearchResult>> searchAvailablePhoneNumbersNoCustomHeaders(@HostParam(value="endpoint") String var1, @PathParam(value="countryCode") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") PhoneNumberSearchRequest var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/availablePhoneNumbers/searchResults/{searchId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<PhoneNumberSearchResult>> getSearchResult(@HostParam(value="endpoint") String var1, @PathParam(value="searchId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/availablePhoneNumbers/:purchase")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<ResponseBase<PhoneNumbersPurchasePhoneNumbersHeaders, Void>> purchasePhoneNumbers(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") PhoneNumberPurchaseRequest var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/availablePhoneNumbers/:purchase")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<Void>> purchasePhoneNumbersNoCustomHeaders(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") PhoneNumberPurchaseRequest var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/phoneNumbers/operations/{operationId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<ResponseBase<PhoneNumbersGetOperationHeaders, PhoneNumberRawOperation>> getOperation(@HostParam(value="endpoint") String var1, @PathParam(value="operationId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/phoneNumbers/operations/{operationId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<PhoneNumberRawOperation>> getOperationNoCustomHeaders(@HostParam(value="endpoint") String var1, @PathParam(value="operationId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Delete(value="/phoneNumbers/operations/{operationId}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<Void>> cancelOperation(@HostParam(value="endpoint") String var1, @PathParam(value="operationId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Patch(value="/phoneNumbers/{phoneNumber}/capabilities")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<ResponseBase<PhoneNumbersUpdateCapabilitiesHeaders, PurchasedPhoneNumber>> updateCapabilities(@HostParam(value="endpoint") String var1, @PathParam(value="phoneNumber") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/merge-patch+json") PhoneNumberCapabilitiesRequest var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Patch(value="/phoneNumbers/{phoneNumber}/capabilities")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<PurchasedPhoneNumber>> updateCapabilitiesNoCustomHeaders(@HostParam(value="endpoint") String var1, @PathParam(value="phoneNumber") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/merge-patch+json") PhoneNumberCapabilitiesRequest var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/phoneNumbers/{phoneNumber}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<PurchasedPhoneNumber>> getByNumber(@HostParam(value="endpoint") String var1, @PathParam(value="phoneNumber") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Delete(value="/phoneNumbers/{phoneNumber}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<ResponseBase<PhoneNumbersReleasePhoneNumberHeaders, Void>> releasePhoneNumber(@HostParam(value="endpoint") String var1, @PathParam(value="phoneNumber") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Delete(value="/phoneNumbers/{phoneNumber}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<Void>> releasePhoneNumberNoCustomHeaders(@HostParam(value="endpoint") String var1, @PathParam(value="phoneNumber") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/phoneNumbers")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<PurchasedPhoneNumbers>> listPhoneNumbers(@HostParam(value="endpoint") String var1, @QueryParam(value="skip") Integer var2, @QueryParam(value="top") Integer var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/operatorInformation/:search")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<OperatorInformationResult>> operatorInformationSearch(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") OperatorInformationRequest var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<PhoneNumberAreaCodes>> listAreaCodesNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="accept-language") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<PhoneNumberCountries>> listAvailableCountriesNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="accept-language") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<PhoneNumberLocalities>> listAvailableLocalitiesNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="accept-language") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<OfferingsResponse>> listOfferingsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="accept-language") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<PhoneNumbersReservations>> listReservationsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<PurchasedPhoneNumbers>> listPhoneNumbersNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

