/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.phonenumbers;

import com.azure.communication.phonenumbers.PhoneNumbersAsyncClient;
import com.azure.communication.phonenumbers.PhoneNumbersClientBuilder;
import com.azure.communication.phonenumbers.implementation.PhoneNumberAdminClientImpl;
import com.azure.communication.phonenumbers.implementation.PhoneNumbersImpl;
import com.azure.communication.phonenumbers.implementation.accesshelpers.PhoneNumbersReservationAccessHelper;
import com.azure.communication.phonenumbers.implementation.models.OperatorInformationRequest;
import com.azure.communication.phonenumbers.models.AvailablePhoneNumber;
import com.azure.communication.phonenumbers.models.BrowsePhoneNumbersOptions;
import com.azure.communication.phonenumbers.models.CreateOrUpdateReservationOptions;
import com.azure.communication.phonenumbers.models.OperatorInformationOptions;
import com.azure.communication.phonenumbers.models.OperatorInformationResult;
import com.azure.communication.phonenumbers.models.PhoneNumberAreaCode;
import com.azure.communication.phonenumbers.models.PhoneNumberAssignmentType;
import com.azure.communication.phonenumbers.models.PhoneNumberCapabilities;
import com.azure.communication.phonenumbers.models.PhoneNumberCountry;
import com.azure.communication.phonenumbers.models.PhoneNumberLocality;
import com.azure.communication.phonenumbers.models.PhoneNumberOffering;
import com.azure.communication.phonenumbers.models.PhoneNumberOperation;
import com.azure.communication.phonenumbers.models.PhoneNumberSearchOptions;
import com.azure.communication.phonenumbers.models.PhoneNumberSearchResult;
import com.azure.communication.phonenumbers.models.PhoneNumberType;
import com.azure.communication.phonenumbers.models.PhoneNumbersBrowseResult;
import com.azure.communication.phonenumbers.models.PhoneNumbersReservation;
import com.azure.communication.phonenumbers.models.PurchasePhoneNumbersResult;
import com.azure.communication.phonenumbers.models.PurchaseReservationResult;
import com.azure.communication.phonenumbers.models.PurchasedPhoneNumber;
import com.azure.communication.phonenumbers.models.ReleasePhoneNumberResult;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.SyncPoller;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

@ServiceClient(builder=PhoneNumbersClientBuilder.class, isAsync=false)
public final class PhoneNumbersClient {
    private final ClientLogger logger = new ClientLogger(PhoneNumbersClient.class);
    private final PhoneNumbersImpl client;
    private final PhoneNumbersAsyncClient asyncClient;
    private final String acceptLanguage;

    PhoneNumbersClient(PhoneNumberAdminClientImpl phoneNumberAdminClient, PhoneNumbersAsyncClient asyncClient) {
        this(phoneNumberAdminClient, asyncClient, null);
    }

    PhoneNumbersClient(PhoneNumberAdminClientImpl phoneNumberAdminClient, PhoneNumbersAsyncClient asyncClient, String acceptLanguage) {
        this.client = phoneNumberAdminClient.getPhoneNumbers();
        this.asyncClient = asyncClient;
        this.acceptLanguage = acceptLanguage;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PurchasedPhoneNumber getPurchasedPhoneNumber(String phoneNumber) {
        Objects.requireNonNull(phoneNumber, "'phoneNumber' cannot be null.");
        return this.client.getByNumber(phoneNumber);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PurchasedPhoneNumber> getPurchasedPhoneNumberWithResponse(String phoneNumber, Context context) {
        Objects.requireNonNull(phoneNumber, "'phoneNumber' cannot be null.");
        context = context == null ? Context.NONE : context;
        return (Response)this.client.getByNumberWithResponseAsync(phoneNumber, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PhoneNumbersReservation getReservation(String reservationId) {
        Objects.requireNonNull(reservationId, "'reservationId' cannot be null.");
        return this.client.getReservation(UUID.fromString(reservationId));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PhoneNumbersReservation> getReservationWithResponse(String reservationId, Context context) {
        Objects.requireNonNull(reservationId, "'reservationId' cannot be null.");
        return this.client.getReservationWithResponse(UUID.fromString(reservationId), context);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PurchasedPhoneNumber> listPurchasedPhoneNumbers() {
        return this.listPurchasedPhoneNumbers(null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PurchasedPhoneNumber> listPurchasedPhoneNumbers(Context context) {
        context = context == null ? Context.NONE : context;
        return this.client.listPhoneNumbers(null, null, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PhoneNumbersBrowseResult browseAvailableNumbers(BrowsePhoneNumbersOptions browsePhoneNumbersOptions) {
        Objects.requireNonNull(browsePhoneNumbersOptions.getCountryCode(), "'countryCode' cannot be null.");
        return this.client.browseAvailableNumbers(browsePhoneNumbersOptions.getCountryCode(), browsePhoneNumbersOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PhoneNumbersBrowseResult> browseAvailableNumbersWithResponse(BrowsePhoneNumbersOptions browsePhoneNumbersOptions, Context context) {
        Objects.requireNonNull(browsePhoneNumbersOptions.getCountryCode(), "'countryCode' cannot be null.");
        return this.client.browseAvailableNumbersWithResponse(browsePhoneNumbersOptions.getCountryCode(), browsePhoneNumbersOptions, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PhoneNumberOperation, PhoneNumberSearchResult> beginSearchAvailablePhoneNumbers(String countryCode, PhoneNumberType phoneNumberType, PhoneNumberAssignmentType assignmentType, PhoneNumberCapabilities capabilities) {
        return this.asyncClient.beginSearchAvailablePhoneNumbers(countryCode, phoneNumberType, assignmentType, capabilities).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PhoneNumberOperation, PhoneNumberSearchResult> beginSearchAvailablePhoneNumbers(String countryCode, PhoneNumberType phoneNumberType, PhoneNumberAssignmentType assignmentType, PhoneNumberCapabilities capabilities, PhoneNumberSearchOptions searchOptions, Context context) {
        return this.asyncClient.beginSearchAvailablePhoneNumbers(countryCode, phoneNumberType, assignmentType, capabilities, searchOptions, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PhoneNumberOperation, PurchasePhoneNumbersResult> beginPurchasePhoneNumbers(String searchId) {
        return this.asyncClient.beginPurchasePhoneNumbers(searchId, false).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PhoneNumberOperation, PurchasePhoneNumbersResult> beginPurchasePhoneNumbers(String searchId, Boolean agreeToNotResell) {
        return this.asyncClient.beginPurchasePhoneNumbers(searchId, agreeToNotResell).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PhoneNumberOperation, PurchasePhoneNumbersResult> beginPurchasePhoneNumbers(String searchId, Context context) {
        return this.asyncClient.beginPurchasePhoneNumbers(searchId, false, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PhoneNumberOperation, PurchasePhoneNumbersResult> beginPurchasePhoneNumbers(String searchId, Boolean agreeToNotResell, Context context) {
        return this.asyncClient.beginPurchasePhoneNumbers(searchId, agreeToNotResell, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PhoneNumberOperation, PurchaseReservationResult> beginReservationPurchase(String reservationId) {
        return this.asyncClient.beginPurchaseReservation(reservationId).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PhoneNumberOperation, PurchaseReservationResult> beginReservationPurchase(String reservationId, Boolean agreeToNotResell) {
        return this.asyncClient.beginPurchaseReservation(reservationId, agreeToNotResell).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PhoneNumberOperation, PurchaseReservationResult> beginReservationPurchase(String reservationId, Context context) {
        return this.asyncClient.beginPurchaseReservation(reservationId, false, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PhoneNumberOperation, PurchaseReservationResult> beginReservationPurchase(String reservationId, Boolean agreeToNotResell, Context context) {
        return this.asyncClient.beginPurchaseReservation(reservationId, agreeToNotResell, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PhoneNumberOperation, ReleasePhoneNumberResult> beginReleasePhoneNumber(String phoneNumber) {
        return this.asyncClient.beginReleasePhoneNumber(phoneNumber).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PhoneNumberOperation, ReleasePhoneNumberResult> beginReleasePhoneNumber(String phoneNumber, Context context) {
        return this.asyncClient.beginReleasePhoneNumber(phoneNumber, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PhoneNumberOperation, PurchasedPhoneNumber> beginUpdatePhoneNumberCapabilities(String phoneNumber, PhoneNumberCapabilities capabilities) {
        return this.asyncClient.beginUpdatePhoneNumberCapabilities(phoneNumber, capabilities).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PhoneNumberOperation, PurchasedPhoneNumber> beginUpdatePhoneNumberCapabilities(String phoneNumber, PhoneNumberCapabilities capabilities, Context context) {
        return this.asyncClient.beginUpdatePhoneNumberCapabilities(phoneNumber, capabilities, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PhoneNumberCountry> listAvailableCountries() {
        return this.listAvailableCountries(null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PhoneNumberCountry> listAvailableCountries(Context context) {
        context = context == null ? Context.NONE : context;
        return this.client.listAvailableCountries(null, null, this.acceptLanguage, context);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PhoneNumberLocality> listAvailableLocalities(String countryCode, String administrativeDivision) {
        return this.listAvailableLocalities(countryCode, administrativeDivision, null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PhoneNumberLocality> listAvailableLocalities(String countryCode, String administrativeDivision, Context context) {
        context = context == null ? Context.NONE : context;
        return this.client.listAvailableLocalities(countryCode, null, null, administrativeDivision, this.acceptLanguage, context);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PhoneNumberAreaCode> listAvailableTollFreeAreaCodes(String countryCode) {
        return this.listAvailableTollFreeAreaCodes(countryCode, null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PhoneNumberAreaCode> listAvailableTollFreeAreaCodes(String countryCode, Context context) {
        return this.client.listAreaCodes(countryCode, PhoneNumberType.TOLL_FREE, null, null, PhoneNumberAssignmentType.APPLICATION, null, null, this.acceptLanguage);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PhoneNumberAreaCode> listAvailableGeographicAreaCodes(String countryCode, PhoneNumberAssignmentType assignmentType, String locality, String administrativeDivision) {
        return this.listAvailableGeographicAreaCodes(countryCode, assignmentType, locality, administrativeDivision, null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PhoneNumberAreaCode> listAvailableGeographicAreaCodes(String countryCode, PhoneNumberAssignmentType assignmentType, String locality, String administrativeDivision, Context context) {
        context = context == null ? Context.NONE : context;
        return this.client.listAreaCodes(countryCode, PhoneNumberType.GEOGRAPHIC, null, null, assignmentType, locality, administrativeDivision, this.acceptLanguage, context);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PhoneNumberOffering> listAvailableOfferings(String countryCode, PhoneNumberType phoneNumberType, PhoneNumberAssignmentType assignmentType) {
        return this.listAvailableOfferings(countryCode, phoneNumberType, assignmentType, null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PhoneNumberOffering> listAvailableOfferings(String countryCode, PhoneNumberType phoneNumberType, PhoneNumberAssignmentType assignmentType, Context context) {
        context = context == null ? Context.NONE : context;
        return this.client.listOfferings(countryCode, null, null, phoneNumberType, assignmentType, this.acceptLanguage, context);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PhoneNumbersReservation> listReservations() {
        return this.client.listReservations(100);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PhoneNumbersReservation> listReservations(Integer maxPageSize) {
        return this.client.listReservations(maxPageSize);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PhoneNumbersReservation> listReservations(Integer maxPageSize, Context context) {
        return this.client.listReservations(maxPageSize, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperatorInformationResult searchOperatorInformation(List<String> phoneNumbers) {
        OperatorInformationRequest request = new OperatorInformationRequest();
        request.setPhoneNumbers(phoneNumbers);
        request.setOptions(new OperatorInformationOptions().setIncludeAdditionalOperatorDetails(false));
        return this.client.operatorInformationSearch(request);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<OperatorInformationResult> searchOperatorInformationWithResponse(List<String> phoneNumbers, OperatorInformationOptions requestOptions, Context context) {
        context = context == null ? Context.NONE : context;
        OperatorInformationRequest request = new OperatorInformationRequest();
        request.setPhoneNumbers(phoneNumbers);
        request.setOptions(requestOptions);
        return this.client.operatorInformationSearchWithResponse(request, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PhoneNumbersReservation createOrUpdateReservation(CreateOrUpdateReservationOptions reservationOptions) {
        Objects.requireNonNull(reservationOptions.getReservationId(), "'reservationId' cannot be null.");
        Map<String, AvailablePhoneNumber> phoneNumbersMap = PhoneNumbersClient.updatePhoneNumbersMap(new HashMap<String, AvailablePhoneNumber>(), reservationOptions);
        PhoneNumbersReservation reservation = new PhoneNumbersReservation();
        PhoneNumbersReservationAccessHelper.setPhoneNumbers(reservation, phoneNumbersMap);
        return this.client.createOrUpdateReservation(UUID.fromString(reservationOptions.getReservationId()), reservation);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PhoneNumbersReservation> createOrUpdateReservationWithResponse(CreateOrUpdateReservationOptions reservationOptions, Context context) {
        Objects.requireNonNull(reservationOptions.getReservationId(), "'reservationId' cannot be null.");
        Map<String, AvailablePhoneNumber> phoneNumbersMap = PhoneNumbersClient.updatePhoneNumbersMap(new HashMap<String, AvailablePhoneNumber>(), reservationOptions);
        PhoneNumbersReservation reservation = new PhoneNumbersReservation();
        PhoneNumbersReservationAccessHelper.setPhoneNumbers(reservation, phoneNumbersMap);
        return this.client.createOrUpdateReservationWithResponse(UUID.fromString(reservationOptions.getReservationId()), reservation, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteReservation(String reservationId) {
        this.client.deleteReservation(UUID.fromString(reservationId));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteReservationWithResponse(String reservationId, Context context) {
        return this.client.deleteReservationWithResponse(UUID.fromString(reservationId), context);
    }

    private static Map<String, AvailablePhoneNumber> updatePhoneNumbersMap(Map<String, AvailablePhoneNumber> phoneNumbersMap, CreateOrUpdateReservationOptions request) {
        if (request.getPhoneNumbersToAdd() != null) {
            for (AvailablePhoneNumber availablePhoneNumber : request.getPhoneNumbersToAdd()) {
                phoneNumbersMap.put(availablePhoneNumber.getId(), availablePhoneNumber);
            }
        }
        if (request.getPhoneNumbersToRemove() != null) {
            for (String string : request.getPhoneNumbersToRemove()) {
                phoneNumbersMap.put(string, null);
            }
        }
        return phoneNumbersMap;
    }
}

