/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.phonenumbers;

import com.azure.communication.phonenumbers.PhoneNumbersClientBuilder;
import com.azure.communication.phonenumbers.implementation.PhoneNumberAdminClientImpl;
import com.azure.communication.phonenumbers.implementation.PhoneNumbersImpl;
import com.azure.communication.phonenumbers.implementation.accesshelpers.PhoneNumbersReservationAccessHelper;
import com.azure.communication.phonenumbers.implementation.converters.PhoneNumberErrorConverter;
import com.azure.communication.phonenumbers.implementation.models.CommunicationErrorResponseException;
import com.azure.communication.phonenumbers.implementation.models.OperatorInformationRequest;
import com.azure.communication.phonenumbers.implementation.models.PhoneNumberCapabilitiesRequest;
import com.azure.communication.phonenumbers.implementation.models.PhoneNumberPurchaseRequest;
import com.azure.communication.phonenumbers.implementation.models.PhoneNumberSearchRequest;
import com.azure.communication.phonenumbers.implementation.models.PhoneNumbersPurchasePhoneNumbersHeaders;
import com.azure.communication.phonenumbers.implementation.models.PhoneNumbersPurchaseReservationHeaders;
import com.azure.communication.phonenumbers.implementation.models.PhoneNumbersReleasePhoneNumberHeaders;
import com.azure.communication.phonenumbers.implementation.models.PhoneNumbersReservationPurchaseRequest;
import com.azure.communication.phonenumbers.implementation.models.PhoneNumbersSearchAvailablePhoneNumbersHeaders;
import com.azure.communication.phonenumbers.implementation.models.PhoneNumbersUpdateCapabilitiesHeaders;
import com.azure.communication.phonenumbers.models.AvailablePhoneNumber;
import com.azure.communication.phonenumbers.models.BrowsePhoneNumbersOptions;
import com.azure.communication.phonenumbers.models.CreateOrUpdateReservationOptions;
import com.azure.communication.phonenumbers.models.OperatorInformationOptions;
import com.azure.communication.phonenumbers.models.OperatorInformationResult;
import com.azure.communication.phonenumbers.models.PhoneNumberAreaCode;
import com.azure.communication.phonenumbers.models.PhoneNumberAssignmentType;
import com.azure.communication.phonenumbers.models.PhoneNumberCapabilities;
import com.azure.communication.phonenumbers.models.PhoneNumberCountry;
import com.azure.communication.phonenumbers.models.PhoneNumberError;
import com.azure.communication.phonenumbers.models.PhoneNumberErrorResponseException;
import com.azure.communication.phonenumbers.models.PhoneNumberLocality;
import com.azure.communication.phonenumbers.models.PhoneNumberOffering;
import com.azure.communication.phonenumbers.models.PhoneNumberOperation;
import com.azure.communication.phonenumbers.models.PhoneNumberOperationStatus;
import com.azure.communication.phonenumbers.models.PhoneNumberSearchOptions;
import com.azure.communication.phonenumbers.models.PhoneNumberSearchResult;
import com.azure.communication.phonenumbers.models.PhoneNumberType;
import com.azure.communication.phonenumbers.models.PhoneNumbersBrowseResult;
import com.azure.communication.phonenumbers.models.PhoneNumbersReservation;
import com.azure.communication.phonenumbers.models.PurchasePhoneNumbersResult;
import com.azure.communication.phonenumbers.models.PurchaseReservationResult;
import com.azure.communication.phonenumbers.models.PurchasedPhoneNumber;
import com.azure.communication.phonenumbers.models.ReleasePhoneNumberResult;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.PollingContext;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import reactor.core.publisher.Mono;

@ServiceClient(builder=PhoneNumbersClientBuilder.class, isAsync=true)
public final class PhoneNumbersAsyncClient {
    private final ClientLogger logger = new ClientLogger(PhoneNumbersAsyncClient.class);
    private final PhoneNumbersImpl client;
    private final Duration defaultPollInterval = Duration.ofSeconds(1L);
    private final String acceptLanguage;

    PhoneNumbersAsyncClient(PhoneNumberAdminClientImpl phoneNumberAdminClient) {
        this(phoneNumberAdminClient, null);
    }

    PhoneNumbersAsyncClient(PhoneNumberAdminClientImpl phoneNumberAdminClient, String acceptLanguage) {
        this.client = phoneNumberAdminClient.getPhoneNumbers();
        this.acceptLanguage = acceptLanguage;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PurchasedPhoneNumber> getPurchasedPhoneNumber(String phoneNumber) {
        if (Objects.isNull(phoneNumber)) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'phoneNumber' cannot be null."));
        }
        return this.client.getByNumberAsync(phoneNumber).onErrorMap(CommunicationErrorResponseException.class, this::translateException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PurchasedPhoneNumber>> getPurchasedPhoneNumberWithResponse(String phoneNumber) {
        if (Objects.isNull(phoneNumber)) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'phoneNumber' cannot be null."));
        }
        return this.client.getByNumberWithResponseAsync(phoneNumber).onErrorMap(CommunicationErrorResponseException.class, this::translateException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PhoneNumbersReservation> getReservation(String reservationId) {
        Objects.requireNonNull(reservationId, "'reservationId' cannot be null.");
        return this.client.getReservationAsync(UUID.fromString(reservationId));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PhoneNumbersReservation>> getReservationWithResponse(String reservationId) {
        Objects.requireNonNull(reservationId, "'reservationId' cannot be null.");
        return this.client.getReservationWithResponseAsync(UUID.fromString(reservationId));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PurchasedPhoneNumber> listPurchasedPhoneNumbers() {
        try {
            return this.client.listPhoneNumbersAsync(null, null);
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PhoneNumbersBrowseResult> browseAvailableNumbers(BrowsePhoneNumbersOptions browsePhoneNumbersOptions) {
        Objects.requireNonNull(browsePhoneNumbersOptions.getCountryCode(), "'countryCode' cannot be null.");
        return this.client.browseAvailableNumbersAsync(browsePhoneNumbersOptions.getCountryCode(), browsePhoneNumbersOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PhoneNumbersBrowseResult>> browseAvailableNumbersWithResponse(BrowsePhoneNumbersOptions browsePhoneNumbersOptions) {
        Objects.requireNonNull(browsePhoneNumbersOptions.getCountryCode(), "'countryCode' cannot be null.");
        return this.client.browseAvailableNumbersWithResponseAsync(browsePhoneNumbersOptions.getCountryCode(), browsePhoneNumbersOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PhoneNumberOperation, PhoneNumberSearchResult> beginSearchAvailablePhoneNumbers(String countryCode, PhoneNumberType phoneNumberType, PhoneNumberAssignmentType assignmentType, PhoneNumberCapabilities capabilities) {
        return this.beginSearchAvailablePhoneNumbers(countryCode, phoneNumberType, assignmentType, capabilities, null, null);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PhoneNumberOperation, PhoneNumberSearchResult> beginSearchAvailablePhoneNumbers(String countryCode, PhoneNumberType phoneNumberType, PhoneNumberAssignmentType assignmentType, PhoneNumberCapabilities capabilities, PhoneNumberSearchOptions searchOptions) {
        return this.beginSearchAvailablePhoneNumbers(countryCode, phoneNumberType, assignmentType, capabilities, searchOptions, null);
    }

    PollerFlux<PhoneNumberOperation, PhoneNumberSearchResult> beginSearchAvailablePhoneNumbers(String countryCode, PhoneNumberType phoneNumberType, PhoneNumberAssignmentType assignmentType, PhoneNumberCapabilities capabilities, PhoneNumberSearchOptions searchOptions, Context context) {
        try {
            Objects.requireNonNull(countryCode, "'countryCode' cannot be null.");
            Objects.requireNonNull(phoneNumberType, "'phoneNumberType' cannot be null.");
            Objects.requireNonNull(assignmentType, "'assignmentType' cannot be null.");
            Objects.requireNonNull(capabilities, "'capabilities' cannot be null.");
            String areaCode = null;
            Integer quantity = null;
            if (searchOptions != null) {
                areaCode = searchOptions.getAreaCode();
                quantity = searchOptions.getQuantity();
            }
            PhoneNumberSearchRequest searchRequest = new PhoneNumberSearchRequest();
            searchRequest.setPhoneNumberType(phoneNumberType).setAssignmentType(assignmentType).setCapabilities(capabilities).setAreaCode(areaCode).setQuantity(quantity);
            return new PollerFlux(this.defaultPollInterval, this.searchAvailableNumbersInitOperation(countryCode, searchRequest, context), this.pollOperation(), this.cancelOperation(), this.searchAvailableNumbersFetchFinalResultOperation());
        }
        catch (RuntimeException ex) {
            return PollerFlux.error((Exception)ex);
        }
    }

    private Function<PollingContext<PhoneNumberOperation>, Mono<PhoneNumberOperation>> searchAvailableNumbersInitOperation(String countryCode, PhoneNumberSearchRequest searchRequest, Context context) {
        return pollingContext -> FluxUtil.withContext(contextValue -> {
            if (context != null) {
                contextValue = context;
            }
            return this.client.searchAvailablePhoneNumbersWithResponseAsync(countryCode, searchRequest, (Context)contextValue).onErrorMap(CommunicationErrorResponseException.class, this::translateException).flatMap(response -> {
                pollingContext.setData("operationId", ((PhoneNumbersSearchAvailablePhoneNumbersHeaders)response.getDeserializedHeaders()).getOperationId());
                pollingContext.setData("searchId", ((PhoneNumbersSearchAvailablePhoneNumbersHeaders)response.getDeserializedHeaders()).getSearchId());
                return this.getOperation(pollingContext.getData("operationId"));
            });
        });
    }

    private Function<PollingContext<PhoneNumberOperation>, Mono<PollResponse<PhoneNumberOperation>>> pollOperation() {
        return pollingContext -> this.getOperation(pollingContext.getData("operationId")).onErrorMap(CommunicationErrorResponseException.class, this::translateException).flatMap(operation -> {
            if (operation.getStatus().toString().equalsIgnoreCase(PhoneNumberOperationStatus.SUCCEEDED.toString())) {
                return Mono.just((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, operation));
            }
            if (operation.getStatus().toString().equalsIgnoreCase(PhoneNumberOperationStatus.FAILED.toString())) {
                return Mono.just((Object)new PollResponse(LongRunningOperationStatus.FAILED, operation));
            }
            if (operation.getStatus().toString().equalsIgnoreCase(PhoneNumberOperationStatus.NOT_STARTED.toString())) {
                return Mono.just((Object)new PollResponse(LongRunningOperationStatus.NOT_STARTED, operation));
            }
            return Mono.just((Object)new PollResponse(LongRunningOperationStatus.IN_PROGRESS, operation));
        });
    }

    private BiFunction<PollingContext<PhoneNumberOperation>, PollResponse<PhoneNumberOperation>, Mono<PhoneNumberOperation>> cancelOperation() {
        return (pollingContext, firstResponse) -> {
            if (firstResponse == null || firstResponse.getValue() == null) {
                return Mono.error((Throwable)this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Cannot cancel a poll response that never started.")));
            }
            String operationId = ((PhoneNumberOperation)firstResponse.getValue()).getId();
            if (!CoreUtils.isNullOrEmpty((CharSequence)operationId)) {
                this.logger.info("Cancelling search available phone numbers operation for operation id: {}", new Object[]{operationId});
                return this.client.cancelOperationAsync(operationId).thenReturn((Object)((PhoneNumberOperation)firstResponse.getValue())).onErrorMap(CommunicationErrorResponseException.class, this::translateException);
            }
            return Mono.empty();
        };
    }

    private Function<PollingContext<PhoneNumberOperation>, Mono<PhoneNumberSearchResult>> searchAvailableNumbersFetchFinalResultOperation() {
        return pollingContext -> this.client.getSearchResultAsync(pollingContext.getData("searchId")).onErrorMap(CommunicationErrorResponseException.class, this::translateException);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PhoneNumberOperation, PurchasePhoneNumbersResult> beginPurchasePhoneNumbers(String searchId) {
        return this.beginPurchasePhoneNumbers(searchId, false, null);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PhoneNumberOperation, PurchasePhoneNumbersResult> beginPurchasePhoneNumbers(String searchId, Boolean agreeToNotResell) {
        return this.beginPurchasePhoneNumbers(searchId, agreeToNotResell, null);
    }

    PollerFlux<PhoneNumberOperation, PurchasePhoneNumbersResult> beginPurchasePhoneNumbers(String searchId, Context context) {
        try {
            Objects.requireNonNull(searchId, "'searchId' cannot be null.");
            return new PollerFlux(this.defaultPollInterval, this.purchaseNumbersInitOperation(searchId, false, context), this.pollOperation(), (pollingContext, firstResponse) -> Mono.error((Throwable)this.logger.logExceptionAsError(new RuntimeException("Cancellation is not supported"))), pollingContext -> Mono.just((Object)new PurchasePhoneNumbersResult()));
        }
        catch (RuntimeException ex) {
            return PollerFlux.error((Exception)ex);
        }
    }

    PollerFlux<PhoneNumberOperation, PurchasePhoneNumbersResult> beginPurchasePhoneNumbers(String searchId, Boolean agreeToNotResell, Context context) {
        try {
            Objects.requireNonNull(searchId, "'searchId' cannot be null.");
            return new PollerFlux(this.defaultPollInterval, this.purchaseNumbersInitOperation(searchId, agreeToNotResell, context), this.pollOperation(), (pollingContext, firstResponse) -> Mono.error((Throwable)this.logger.logExceptionAsError(new RuntimeException("Cancellation is not supported"))), pollingContext -> Mono.just((Object)new PurchasePhoneNumbersResult()));
        }
        catch (RuntimeException ex) {
            return PollerFlux.error((Exception)ex);
        }
    }

    private Function<PollingContext<PhoneNumberOperation>, Mono<PhoneNumberOperation>> purchaseNumbersInitOperation(String searchId, Boolean agreeToNotResell, Context context) {
        return pollingContext -> FluxUtil.withContext(contextValue -> {
            if (context != null) {
                contextValue = context;
            }
            return this.client.purchasePhoneNumbersWithResponseAsync(new PhoneNumberPurchaseRequest().setSearchId(searchId).setAgreeToNotResell(agreeToNotResell), (Context)contextValue).onErrorMap(CommunicationErrorResponseException.class, this::translateException).flatMap(response -> {
                pollingContext.setData("operationId", ((PhoneNumbersPurchasePhoneNumbersHeaders)response.getDeserializedHeaders()).getOperationId());
                return this.getOperation(pollingContext.getData("operationId"));
            });
        });
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PhoneNumberOperation, PurchaseReservationResult> beginPurchaseReservation(String reservationId) {
        return this.beginPurchaseReservation(reservationId, false, null);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PhoneNumberOperation, PurchaseReservationResult> beginPurchaseReservation(String reservationId, Boolean agreeToNotResell) {
        return this.beginPurchaseReservation(reservationId, agreeToNotResell, null);
    }

    PollerFlux<PhoneNumberOperation, PurchaseReservationResult> beginPurchaseReservation(String reservationId, Boolean agreeToNotResell, Context context) {
        try {
            Objects.requireNonNull(reservationId, "'reservationId' cannot be null.");
            return new PollerFlux(this.defaultPollInterval, this.purchaseReservationInitOperation(UUID.fromString(reservationId), agreeToNotResell, context), this.pollOperation(), (pollingContext, firstResponse) -> Mono.error((Throwable)this.logger.logExceptionAsError(new RuntimeException("Cancellation is not supported"))), pollingContext -> Mono.just((Object)new PurchaseReservationResult()));
        }
        catch (RuntimeException ex) {
            return PollerFlux.error((Exception)ex);
        }
    }

    private Function<PollingContext<PhoneNumberOperation>, Mono<PhoneNumberOperation>> purchaseReservationInitOperation(UUID reservationId, Boolean agreeToNotResell, Context context) {
        return pollingContext -> FluxUtil.withContext(contextValue -> {
            if (context != null) {
                contextValue = context;
            }
            return this.client.purchaseReservationWithResponseAsync(reservationId, new PhoneNumbersReservationPurchaseRequest().setAgreeToNotResell(agreeToNotResell), (Context)contextValue).onErrorMap(CommunicationErrorResponseException.class, this::translateException).flatMap(response -> {
                pollingContext.setData("operationId", ((PhoneNumbersPurchaseReservationHeaders)response.getDeserializedHeaders()).getOperationId());
                return this.getOperation(pollingContext.getData("operationId"));
            });
        });
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PhoneNumberOperation, ReleasePhoneNumberResult> beginReleasePhoneNumber(String phoneNumber) {
        return this.beginReleasePhoneNumber(phoneNumber, null);
    }

    PollerFlux<PhoneNumberOperation, ReleasePhoneNumberResult> beginReleasePhoneNumber(String phoneNumber, Context context) {
        try {
            Objects.requireNonNull(phoneNumber, "'phoneNumber' cannot be null.");
            return new PollerFlux(this.defaultPollInterval, this.releaseNumberInitOperation(phoneNumber, context), this.pollOperation(), (pollingContext, firstResponse) -> Mono.error((Throwable)this.logger.logExceptionAsError(new RuntimeException("Cancellation is not supported"))), pollingContext -> Mono.just((Object)new ReleasePhoneNumberResult()));
        }
        catch (RuntimeException ex) {
            return PollerFlux.error((Exception)ex);
        }
    }

    private Function<PollingContext<PhoneNumberOperation>, Mono<PhoneNumberOperation>> releaseNumberInitOperation(String phoneNumber, Context context) {
        return pollingContext -> FluxUtil.withContext(contextValue -> {
            if (context != null) {
                contextValue = context;
            }
            return this.client.releasePhoneNumberWithResponseAsync(phoneNumber, (Context)contextValue).onErrorMap(CommunicationErrorResponseException.class, this::translateException).flatMap(response -> {
                pollingContext.setData("operationId", ((PhoneNumbersReleasePhoneNumberHeaders)response.getDeserializedHeaders()).getOperationId());
                return this.getOperation(pollingContext.getData("operationId"));
            });
        });
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PhoneNumberOperation, PurchasedPhoneNumber> beginUpdatePhoneNumberCapabilities(String phoneNumber, PhoneNumberCapabilities capabilities) {
        return this.beginUpdatePhoneNumberCapabilities(phoneNumber, capabilities, null);
    }

    PollerFlux<PhoneNumberOperation, PurchasedPhoneNumber> beginUpdatePhoneNumberCapabilities(String phoneNumber, PhoneNumberCapabilities capabilities, Context context) {
        try {
            Objects.requireNonNull(phoneNumber, "'phoneNumber' cannot be null.");
            Objects.requireNonNull(capabilities, "'capabilities' cannot be null.");
            PhoneNumberCapabilitiesRequest capabilitiesRequest = new PhoneNumberCapabilitiesRequest().setCalling(capabilities.getCalling()).setSms(capabilities.getSms());
            return new PollerFlux(this.defaultPollInterval, this.updateNumberCapabilitiesInitOperation(phoneNumber, capabilitiesRequest, context), this.pollOperation(), (pollingContext, firstResponse) -> Mono.error((Throwable)this.logger.logExceptionAsError(new RuntimeException("Cancellation is not supported"))), this.updateNumberCapabilitiesFetchFinalResultOperation(phoneNumber));
        }
        catch (RuntimeException ex) {
            return PollerFlux.error((Exception)ex);
        }
    }

    private Function<PollingContext<PhoneNumberOperation>, Mono<PhoneNumberOperation>> updateNumberCapabilitiesInitOperation(String phoneNumber, PhoneNumberCapabilitiesRequest capabilitiesUpdateRequest, Context context) {
        return pollingContext -> FluxUtil.withContext(contextValue -> {
            if (context != null) {
                contextValue = context;
            }
            return this.client.updateCapabilitiesWithResponseAsync(phoneNumber, capabilitiesUpdateRequest, (Context)contextValue).onErrorMap(CommunicationErrorResponseException.class, this::translateException).flatMap(response -> {
                pollingContext.setData("operationId", ((PhoneNumbersUpdateCapabilitiesHeaders)response.getDeserializedHeaders()).getOperationId());
                return this.getOperation(pollingContext.getData("operationId"));
            });
        });
    }

    private Function<PollingContext<PhoneNumberOperation>, Mono<PurchasedPhoneNumber>> updateNumberCapabilitiesFetchFinalResultOperation(String phoneNumber) {
        return pollingContext -> this.client.getByNumberAsync(phoneNumber).onErrorMap(CommunicationErrorResponseException.class, this::translateException);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PhoneNumberCountry> listAvailableCountries() {
        try {
            return this.client.listAvailableCountriesAsync(null, null, this.acceptLanguage);
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PhoneNumberLocality> listAvailableLocalities(String countryCode, String administrativeDivision) {
        try {
            return this.client.listAvailableLocalitiesAsync(countryCode, null, null, administrativeDivision, this.acceptLanguage);
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PhoneNumberAreaCode> listAvailableTollFreeAreaCodes(String countryCode, PhoneNumberAssignmentType assignmentType) {
        try {
            return this.client.listAreaCodesAsync(countryCode, PhoneNumberType.TOLL_FREE, null, null, assignmentType, null, null, this.acceptLanguage);
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PhoneNumberAreaCode> listAvailableGeographicAreaCodes(String countryCode, PhoneNumberAssignmentType assignmentType, String locality, String administrativeDivision) {
        try {
            return this.client.listAreaCodesAsync(countryCode, PhoneNumberType.GEOGRAPHIC, null, null, assignmentType, locality, administrativeDivision, this.acceptLanguage);
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PhoneNumberOffering> listAvailableOfferings(String countryCode, PhoneNumberType phoneNumberType, PhoneNumberAssignmentType assignmentType) {
        try {
            return this.client.listOfferingsAsync(countryCode, null, null, phoneNumberType, assignmentType, this.acceptLanguage);
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PhoneNumbersReservation> listReservations() {
        return this.client.listReservationsAsync(100);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PhoneNumbersReservation> listReservations(Integer maxPageSize) {
        return this.client.listReservationsAsync(maxPageSize);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<OperatorInformationResult> searchOperatorInformation(List<String> phoneNumbers) {
        OperatorInformationRequest request = new OperatorInformationRequest();
        request.setPhoneNumbers(phoneNumbers);
        request.setOptions(new OperatorInformationOptions().setIncludeAdditionalOperatorDetails(false));
        return this.client.operatorInformationSearchAsync(request).onErrorMap(CommunicationErrorResponseException.class, this::translateException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<OperatorInformationResult>> searchOperatorInformationWithResponse(List<String> phoneNumbers, OperatorInformationOptions requestOptions) {
        OperatorInformationRequest request = new OperatorInformationRequest();
        request.setPhoneNumbers(phoneNumbers);
        request.setOptions(requestOptions);
        return this.client.operatorInformationSearchWithResponseAsync(request).onErrorMap(CommunicationErrorResponseException.class, this::translateException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PhoneNumbersReservation> createOrUpdateReservation(CreateOrUpdateReservationOptions reservationOptions) {
        Objects.requireNonNull(reservationOptions.getReservationId(), "'reservationId' cannot be null.");
        Map<String, AvailablePhoneNumber> phoneNumbersMap = this.updatePhoneNumbersMap(new HashMap<String, AvailablePhoneNumber>(), reservationOptions);
        PhoneNumbersReservation reservation = new PhoneNumbersReservation();
        PhoneNumbersReservationAccessHelper.setPhoneNumbers(reservation, phoneNumbersMap);
        return this.client.createOrUpdateReservationAsync(UUID.fromString(reservationOptions.getReservationId()), reservation);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PhoneNumbersReservation>> createOrUpdateReservationWithResponse(CreateOrUpdateReservationOptions reservationOptions) {
        Objects.requireNonNull(reservationOptions.getReservationId(), "'reservationId' cannot be null.");
        Map<String, AvailablePhoneNumber> phoneNumbersMap = this.updatePhoneNumbersMap(new HashMap<String, AvailablePhoneNumber>(), reservationOptions);
        PhoneNumbersReservation reservation = new PhoneNumbersReservation();
        PhoneNumbersReservationAccessHelper.setPhoneNumbers(reservation, phoneNumbersMap);
        return this.client.createOrUpdateReservationWithResponseAsync(UUID.fromString(reservationOptions.getReservationId()), reservation);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteReservation(String reservationId) {
        return this.client.deleteReservationAsync(UUID.fromString(reservationId));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteReservationWithResponse(String reservationId) {
        return this.client.deleteReservationWithResponseAsync(UUID.fromString(reservationId));
    }

    private Mono<PhoneNumberOperation> getOperation(String operationId) {
        return this.client.getOperationAsync(operationId).onErrorMap(CommunicationErrorResponseException.class, this::translateException).flatMap(rawOperation -> {
            if (rawOperation.getError() != null) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new RuntimeException(rawOperation.getError().getMessage()));
            }
            PhoneNumberOperation operation = new PhoneNumberOperation(rawOperation.getStatus(), rawOperation.getResourceLocation(), rawOperation.getCreatedDateTime(), rawOperation.getId(), rawOperation.getOperationType(), rawOperation.getLastActionDateTime());
            return Mono.just((Object)operation);
        });
    }

    private PhoneNumberErrorResponseException translateException(CommunicationErrorResponseException exception) {
        PhoneNumberError error = null;
        if (exception.getValue() != null) {
            error = PhoneNumberErrorConverter.convert(exception.getValue().getError());
        }
        return new PhoneNumberErrorResponseException(exception.getMessage(), exception.getResponse(), error);
    }

    private Map<String, AvailablePhoneNumber> updatePhoneNumbersMap(Map<String, AvailablePhoneNumber> phoneNumbersMap, CreateOrUpdateReservationOptions request) {
        if (request.getPhoneNumbersToAdd() != null) {
            for (AvailablePhoneNumber availablePhoneNumber : request.getPhoneNumbersToAdd()) {
                phoneNumbersMap.put(availablePhoneNumber.getId(), availablePhoneNumber);
            }
        }
        if (request.getPhoneNumbersToRemove() != null) {
            for (String string : request.getPhoneNumbersToRemove()) {
                phoneNumbersMap.put(string, null);
            }
        }
        return phoneNumbersMap;
    }
}

