/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.phonenumbers.siprouting;

import com.azure.communication.phonenumbers.siprouting.SipRoutingClientBuilder;
import com.azure.communication.phonenumbers.siprouting.implementation.SipRoutingAdminClientImpl;
import com.azure.communication.phonenumbers.siprouting.implementation.converters.SipTrunkConverter;
import com.azure.communication.phonenumbers.siprouting.implementation.converters.SipTrunkRouteConverter;
import com.azure.communication.phonenumbers.siprouting.implementation.models.CommunicationErrorResponseException;
import com.azure.communication.phonenumbers.siprouting.implementation.models.SipConfiguration;
import com.azure.communication.phonenumbers.siprouting.models.SipTrunk;
import com.azure.communication.phonenumbers.siprouting.models.SipTrunkRoute;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

@ServiceClient(builder=SipRoutingClientBuilder.class, isAsync=true)
public final class SipRoutingAsyncClient {
    private final SipRoutingAdminClientImpl client;

    SipRoutingAsyncClient(SipRoutingAdminClientImpl client) {
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SipTrunk> getTrunk(String fqdn) {
        return this.getSipConfiguration().flatMap(config -> {
            SipTrunk trunk = SipTrunkConverter.convertFromApi(config.getTrunks()).stream().filter(sipTrunk -> fqdn.equals(sipTrunk.getFqdn())).findAny().orElse(null);
            return trunk != null ? Mono.just((Object)trunk) : Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SipTrunk>> getTrunkWithResponse(String fqdn) {
        return this.getSipConfigurationWithResponse().onErrorMap(CommunicationErrorResponseException.class, this::translateException).map(result -> new SimpleResponse(result, (Object)SipTrunkConverter.convertFromApi(((SipConfiguration)result.getValue()).getTrunks()).stream().filter(sipTrunk -> fqdn.equals(sipTrunk.getFqdn())).findAny().orElse(null)));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<SipTrunk> listTrunks() {
        return new PagedFlux(() -> this.getOnePageTrunks());
    }

    private Mono<PagedResponse<SipTrunk>> getOnePageTrunks() {
        return this.client.getSipRoutings().getWithResponseAsync().onErrorMap(CommunicationErrorResponseException.class, this::translateException).map(result -> new PagedResponseBase(result.getRequest(), result.getStatusCode(), result.getHeaders(), SipTrunkConverter.convertFromApi(((SipConfiguration)result.getValue()).getTrunks()), null, null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<SipTrunkRoute> listRoutes() {
        return new PagedFlux(() -> this.getOnePageRoutes());
    }

    private Mono<PagedResponse<SipTrunkRoute>> getOnePageRoutes() {
        return this.client.getSipRoutings().getWithResponseAsync().onErrorMap(CommunicationErrorResponseException.class, this::translateException).map(result -> new PagedResponseBase(result.getRequest(), result.getStatusCode(), result.getHeaders(), SipTrunkRouteConverter.convertFromApi(((SipConfiguration)result.getValue()).getRoutes()), null, null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setTrunk(SipTrunk trunk) {
        HashMap<String, com.azure.communication.phonenumbers.siprouting.implementation.models.SipTrunk> trunks = new HashMap<String, com.azure.communication.phonenumbers.siprouting.implementation.models.SipTrunk>();
        trunks.put(trunk.getFqdn(), SipTrunkConverter.convertToApi(trunk));
        return this.setSipConfiguration(new SipConfiguration().setTrunks(trunks)).then();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setTrunks(List<SipTrunk> trunks) {
        SipConfiguration update = new SipConfiguration().setTrunks(SipTrunkConverter.convertToApi(trunks));
        List currentTrunks = (List)this.getTrunksInternal().block();
        if (currentTrunks != null) {
            List storedFqdns = currentTrunks.stream().map(SipTrunk::getFqdn).collect(Collectors.toList());
            Set updatedFqdns = trunks.stream().map(SipTrunk::getFqdn).collect(Collectors.toSet());
            for (String storedFqdn : storedFqdns) {
                if (updatedFqdns.contains(storedFqdn)) continue;
                update.getTrunks().put(storedFqdn, null);
            }
        }
        if (!update.getTrunks().isEmpty()) {
            return this.setSipConfiguration(update).then();
        }
        return Mono.empty();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setTrunksWithResponse(List<SipTrunk> trunks) {
        SipConfiguration update = new SipConfiguration().setTrunks(SipTrunkConverter.convertToApi(trunks));
        List currentTrunks = (List)this.getTrunksInternal().block();
        if (currentTrunks != null) {
            List storedFqdns = currentTrunks.stream().map(SipTrunk::getFqdn).collect(Collectors.toList());
            Set updatedFqdns = trunks.stream().map(SipTrunk::getFqdn).collect(Collectors.toSet());
            for (String storedFqdn : storedFqdns) {
                if (updatedFqdns.contains(storedFqdn)) continue;
                update.getTrunks().put(storedFqdn, null);
            }
        }
        if (!update.getTrunks().isEmpty()) {
            return this.setSipConfigurationWithResponse(update).map(result -> new SimpleResponse(result, null));
        }
        return Mono.just((Object)new SimpleResponse(null, 200, null, null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setRoutes(List<SipTrunkRoute> routes) {
        return this.setSipConfiguration(new SipConfiguration().setRoutes(SipTrunkRouteConverter.convertToApi(routes))).then();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setRoutesWithResponse(List<SipTrunkRoute> routes) {
        return this.setSipConfigurationWithResponse(new SipConfiguration().setRoutes(SipTrunkRouteConverter.convertToApi(routes))).map(result -> new SimpleResponse(result, null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteTrunk(String fqdn) {
        List trunks = (List)this.getTrunksInternal().block();
        if (trunks == null || trunks.isEmpty()) {
            return Mono.empty();
        }
        List deletedTrunks = trunks.stream().filter(trunk -> fqdn.equals(trunk.getFqdn())).collect(Collectors.toList());
        if (!deletedTrunks.isEmpty()) {
            HashMap<String, com.azure.communication.phonenumbers.siprouting.implementation.models.SipTrunk> trunksUpdate = new HashMap<String, com.azure.communication.phonenumbers.siprouting.implementation.models.SipTrunk>();
            trunksUpdate.put(fqdn, null);
            return this.setSipConfiguration(new SipConfiguration().setTrunks(trunksUpdate)).then();
        }
        return Mono.empty();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteTrunkWithResponse(String fqdn) {
        List trunks = (List)this.getTrunksInternal().block();
        if (trunks == null || trunks.isEmpty()) {
            return Mono.just((Object)new SimpleResponse(null, 200, null, null));
        }
        List deletedTrunks = trunks.stream().filter(trunk -> fqdn.equals(trunk.getFqdn())).collect(Collectors.toList());
        if (!deletedTrunks.isEmpty()) {
            HashMap<String, com.azure.communication.phonenumbers.siprouting.implementation.models.SipTrunk> trunksUpdate = new HashMap<String, com.azure.communication.phonenumbers.siprouting.implementation.models.SipTrunk>();
            trunksUpdate.put(fqdn, null);
            return this.setSipConfigurationWithResponse(new SipConfiguration().setTrunks(trunksUpdate)).map(result -> new SimpleResponse(result, null));
        }
        return Mono.just((Object)new SimpleResponse(null, 200, null, null));
    }

    private Mono<SipConfiguration> getSipConfiguration() {
        return this.client.getSipRoutings().getAsync().onErrorMap(CommunicationErrorResponseException.class, this::translateException);
    }

    private Mono<Response<SipConfiguration>> getSipConfigurationWithResponse() {
        return this.client.getSipRoutings().getWithResponseAsync().onErrorMap(CommunicationErrorResponseException.class, this::translateException);
    }

    private Mono<SipConfiguration> setSipConfiguration(SipConfiguration update) {
        return this.client.getSipRoutings().updateAsync(update).onErrorMap(CommunicationErrorResponseException.class, this::translateException);
    }

    private Mono<Response<SipConfiguration>> setSipConfigurationWithResponse(SipConfiguration update) {
        return this.client.getSipRoutings().updateWithResponseAsync(update).onErrorMap(CommunicationErrorResponseException.class, this::translateException);
    }

    private HttpResponseException translateException(CommunicationErrorResponseException exception) {
        return new HttpResponseException(exception.getMessage(), exception.getResponse());
    }

    private Mono<List<SipTrunk>> getTrunksInternal() {
        return this.getSipConfiguration().map(config -> SipTrunkConverter.convertFromApi(config.getTrunks()));
    }
}

