/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.phonenumbers.models;

import com.azure.communication.phonenumbers.models.BillingFrequency;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class PhoneNumberCost
implements JsonSerializable<PhoneNumberCost> {
    private double amount;
    private String currencyCode;
    private BillingFrequency billingFrequency;

    public double getAmount() {
        return this.amount;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public BillingFrequency getBillingFrequency() {
        return this.billingFrequency;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static PhoneNumberCost fromJson(JsonReader jsonReader) throws IOException {
        return (PhoneNumberCost)jsonReader.readObject(reader -> {
            PhoneNumberCost deserializedPhoneNumberCost = new PhoneNumberCost();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("amount".equals(fieldName)) {
                    deserializedPhoneNumberCost.amount = reader.getDouble();
                    continue;
                }
                if ("currencyCode".equals(fieldName)) {
                    deserializedPhoneNumberCost.currencyCode = reader.getString();
                    continue;
                }
                if ("billingFrequency".equals(fieldName)) {
                    deserializedPhoneNumberCost.billingFrequency = BillingFrequency.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPhoneNumberCost;
        });
    }
}

