/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.phonenumbers.siprouting;

import com.azure.communication.common.implementation.CommunicationConnectionString;
import com.azure.communication.common.implementation.HmacAuthenticationPolicy;
import com.azure.communication.phonenumbers.siprouting.SipRoutingAsyncClient;
import com.azure.communication.phonenumbers.siprouting.SipRoutingClient;
import com.azure.communication.phonenumbers.siprouting.SipRoutingServiceVersion;
import com.azure.communication.phonenumbers.siprouting.implementation.SipRoutingAdminClientImpl;
import com.azure.communication.phonenumbers.siprouting.implementation.SipRoutingAdminClientImplBuilder;
import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.client.traits.AzureKeyCredentialTrait;
import com.azure.core.client.traits.ConfigurationTrait;
import com.azure.core.client.traits.ConnectionStringTrait;
import com.azure.core.client.traits.EndpointTrait;
import com.azure.core.client.traits.HttpTrait;
import com.azure.core.client.traits.TokenCredentialTrait;
import com.azure.core.credential.AzureKeyCredential;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.builder.ClientBuilderUtil;
import com.azure.core.util.logging.ClientLogger;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ServiceClientBuilder(serviceClients={SipRoutingClient.class, SipRoutingAsyncClient.class})
public final class SipRoutingClientBuilder
implements AzureKeyCredentialTrait<SipRoutingClientBuilder>,
ConfigurationTrait<SipRoutingClientBuilder>,
ConnectionStringTrait<SipRoutingClientBuilder>,
EndpointTrait<SipRoutingClientBuilder>,
HttpTrait<SipRoutingClientBuilder>,
TokenCredentialTrait<SipRoutingClientBuilder> {
    private static final String APP_CONFIG_PROPERTIES = "azure-communication-phonenumbers-siprouting.properties";
    private static final Map<String, String> PROPERTIES = CoreUtils.getProperties((String)"azure-communication-phonenumbers-siprouting.properties");
    private static final String SDK_NAME = "name";
    private static final String SDK_VERSION = "version";
    private final ClientLogger logger = new ClientLogger(SipRoutingClientBuilder.class);
    private SipRoutingServiceVersion version = SipRoutingServiceVersion.getLatest();
    private String endpoint;
    private HttpPipeline httpPipeline;
    private HttpClient httpClient;
    private HttpLogOptions httpLogOptions;
    private AzureKeyCredential azureKeyCredential;
    private TokenCredential tokenCredential;
    private Configuration configuration;
    private ClientOptions clientOptions;
    private RetryPolicy retryPolicy;
    private RetryOptions retryOptions;
    private final List<HttpPipelinePolicy> perCallPolicies = new ArrayList<HttpPipelinePolicy>();
    private final List<HttpPipelinePolicy> perRetryPolicies = new ArrayList<HttpPipelinePolicy>();

    public SipRoutingClientBuilder endpoint(String endpoint) {
        try {
            new URL(endpoint);
        }
        catch (MalformedURLException ex) {
            throw this.logger.logExceptionAsWarning((RuntimeException)new IllegalArgumentException("'endpoint' must be a valid URL", ex));
        }
        this.endpoint = endpoint;
        return this;
    }

    public SipRoutingClientBuilder pipeline(HttpPipeline httpPipeline) {
        if (this.httpPipeline != null && httpPipeline == null) {
            this.logger.info("HttpPipeline is being set to 'null' when it was previously configured.");
        }
        this.httpPipeline = httpPipeline;
        return this;
    }

    public SipRoutingClientBuilder httpClient(HttpClient httpClient) {
        if (this.httpClient != null && httpClient == null) {
            this.logger.info("HttpClient is being set to 'null' when it was previously configured.");
        }
        this.httpClient = httpClient;
        return this;
    }

    public SipRoutingClientBuilder httpLogOptions(HttpLogOptions httpLogOptions) {
        this.httpLogOptions = httpLogOptions;
        return this;
    }

    public SipRoutingClientBuilder credential(AzureKeyCredential keyCredential) {
        this.azureKeyCredential = Objects.requireNonNull(keyCredential, "'keyCredential' cannot be null.");
        return this;
    }

    public SipRoutingClientBuilder credential(TokenCredential tokenCredential) {
        this.tokenCredential = Objects.requireNonNull(tokenCredential, "'tokenCredential' cannot be null.");
        return this;
    }

    public SipRoutingClientBuilder connectionString(String connectionString) {
        Objects.requireNonNull(connectionString, "'connectionString' cannot be null.");
        CommunicationConnectionString connectionStringObject = new CommunicationConnectionString(connectionString);
        String endpoint = connectionStringObject.getEndpoint();
        String accessKey = connectionStringObject.getAccessKey();
        this.endpoint(endpoint).credential(new AzureKeyCredential(accessKey));
        return this;
    }

    public SipRoutingClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public SipRoutingClientBuilder addPolicy(HttpPipelinePolicy policy) {
        Objects.requireNonNull(policy, "'policy' cannot be null.");
        if (policy.getPipelinePosition() == HttpPipelinePosition.PER_CALL) {
            this.perCallPolicies.add(policy);
        } else {
            this.perRetryPolicies.add(policy);
        }
        return this;
    }

    public SipRoutingClientBuilder clientOptions(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        return this;
    }

    public SipRoutingClientBuilder serviceVersion(SipRoutingServiceVersion version) {
        this.version = version;
        return this;
    }

    public SipRoutingClientBuilder retryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public SipRoutingClientBuilder retryOptions(RetryOptions retryOptions) {
        this.retryOptions = retryOptions;
        return this;
    }

    public SipRoutingClient buildClient() {
        this.validateRequiredFields();
        if (this.version != null) {
            this.logger.info("Build client for service version" + this.version.getVersion());
        }
        return this.createClientImpl(this.createAdminClientImpl());
    }

    public SipRoutingAsyncClient buildAsyncClient() {
        this.validateRequiredFields();
        if (this.version != null) {
            this.logger.info("Build client for service version" + this.version.getVersion());
        }
        return this.createAsyncClientImpl(this.createAdminClientImpl());
    }

    SipRoutingClient createClientImpl(SipRoutingAdminClientImpl adminClientImpl) {
        return new SipRoutingClient(adminClientImpl);
    }

    SipRoutingAsyncClient createAsyncClientImpl(SipRoutingAdminClientImpl adminClientImpl) {
        return new SipRoutingAsyncClient(adminClientImpl);
    }

    HttpPipelinePolicy createAuthenticationPolicy() {
        if (this.tokenCredential != null && this.azureKeyCredential != null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Both 'credential' and 'keyCredential' are set. Just one may be used."));
        }
        if (this.tokenCredential != null) {
            return new BearerTokenAuthenticationPolicy(this.tokenCredential, new String[]{"https://communication.azure.com//.default"});
        }
        if (this.azureKeyCredential != null) {
            return new HmacAuthenticationPolicy(this.azureKeyCredential);
        }
        throw this.logger.logExceptionAsError((RuntimeException)new NullPointerException("Missing credential information while building a client."));
    }

    UserAgentPolicy createUserAgentPolicy(String applicationId, String sdkName, String sdkVersion, Configuration configuration) {
        return new UserAgentPolicy(applicationId, sdkName, sdkVersion, configuration);
    }

    HttpPipelinePolicy createRequestIdPolicy() {
        return new RequestIdPolicy();
    }

    CookiePolicy createCookiePolicy() {
        return new CookiePolicy();
    }

    HttpLoggingPolicy createHttpLoggingPolicy(HttpLogOptions httpLogOptions) {
        return new HttpLoggingPolicy(httpLogOptions);
    }

    HttpLogOptions createDefaultHttpLogOptions() {
        return new HttpLogOptions();
    }

    private void validateRequiredFields() {
        Objects.requireNonNull(this.endpoint);
    }

    private SipRoutingAdminClientImpl createAdminClientImpl() {
        return new SipRoutingAdminClientImplBuilder().endpoint(this.endpoint).pipeline(this.createHttpPipeline()).buildClient();
    }

    private HttpPipeline createHttpPipeline() {
        if (this.httpPipeline != null) {
            return this.httpPipeline;
        }
        ClientOptions buildClientOptions = this.clientOptions == null ? new ClientOptions() : this.clientOptions;
        HttpLogOptions buildLogOptions = this.httpLogOptions == null ? new HttpLogOptions() : this.httpLogOptions;
        String applicationId = CoreUtils.getApplicationId((ClientOptions)buildClientOptions, (HttpLogOptions)buildLogOptions);
        ArrayList<Object> policies = new ArrayList<Object>();
        policies.add(this.createUserAgentPolicy(applicationId, PROPERTIES.get(SDK_NAME), PROPERTIES.get(SDK_VERSION), this.configuration));
        policies.add(this.createRequestIdPolicy());
        policies.addAll(this.perCallPolicies);
        HttpPolicyProviders.addBeforeRetryPolicies(policies);
        policies.add(ClientBuilderUtil.validateAndGetRetryPolicy((HttpPipelinePolicy)this.retryPolicy, (RetryOptions)this.retryOptions));
        policies.add(this.createAuthenticationPolicy());
        policies.add(this.createCookiePolicy());
        policies.addAll(this.perRetryPolicies);
        HttpPolicyProviders.addAfterRetryPolicies(policies);
        policies.add(this.createHttpLoggingPolicy(this.getHttpLogOptions()));
        return new HttpPipelineBuilder().policies(policies.toArray(new HttpPipelinePolicy[0])).httpClient(this.httpClient).clientOptions(this.clientOptions).build();
    }

    private HttpLogOptions getHttpLogOptions() {
        if (this.httpLogOptions == null) {
            this.httpLogOptions = this.createDefaultHttpLogOptions();
        }
        return this.httpLogOptions;
    }
}

