/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.phonenumbers.models;

import com.azure.communication.phonenumbers.models.PhoneNumberOperationStatus;
import com.azure.communication.phonenumbers.models.PhoneNumberOperationType;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class PhoneNumberOperation
implements JsonSerializable<PhoneNumberOperation> {
    private final PhoneNumberOperationStatus status;
    private final String resourceLocation;
    private final OffsetDateTime createdDateTime;
    private final String id;
    private final PhoneNumberOperationType operationType;
    private final OffsetDateTime lastActionDateTime;

    public PhoneNumberOperation(PhoneNumberOperationStatus status, String resourceLocation, OffsetDateTime createdDateTime, String id, PhoneNumberOperationType operationType, OffsetDateTime lastActionDateTime) {
        this.status = status;
        this.resourceLocation = resourceLocation;
        this.createdDateTime = createdDateTime;
        this.id = id;
        this.operationType = operationType;
        this.lastActionDateTime = lastActionDateTime;
    }

    public PhoneNumberOperationStatus getStatus() {
        return this.status;
    }

    public String getResourceLocation() {
        return this.resourceLocation;
    }

    public OffsetDateTime getCreatedDateTime() {
        return this.createdDateTime;
    }

    public String getId() {
        return this.id;
    }

    public PhoneNumberOperationType getOperationType() {
        return this.operationType;
    }

    public OffsetDateTime getLastActionDateTime() {
        return this.lastActionDateTime;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return jsonWriter.writeStartObject().writeEndObject();
    }

    public static PhoneNumberOperation fromJson(JsonReader jsonReader) throws IOException {
        return (PhoneNumberOperation)jsonReader.readObject(reader -> {
            PhoneNumberOperationStatus status = null;
            String resourceLocation = null;
            OffsetDateTime createdDateTime = null;
            String id = null;
            PhoneNumberOperationType operationType = null;
            OffsetDateTime lastActionDateTime = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("status".equals(fieldName)) {
                    status = PhoneNumberOperationStatus.fromString(reader.getString());
                    continue;
                }
                if ("resourceLocation".equals(fieldName)) {
                    resourceLocation = reader.getString();
                    continue;
                }
                if ("createdDateTime".equals(fieldName)) {
                    createdDateTime = CoreUtils.parseBestOffsetDateTime((String)reader.getString());
                    continue;
                }
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("operationType".equals(fieldName)) {
                    operationType = PhoneNumberOperationType.fromString(reader.getString());
                    continue;
                }
                if ("lastActionDateTime".equals(fieldName)) {
                    lastActionDateTime = CoreUtils.parseBestOffsetDateTime((String)reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return new PhoneNumberOperation(status, resourceLocation, createdDateTime, id, operationType, lastActionDateTime);
        });
    }
}

