/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.phonenumbers.models;

import com.azure.communication.phonenumbers.models.OperatorDetails;
import com.azure.communication.phonenumbers.models.OperatorNumberType;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class OperatorInformation
implements JsonSerializable<OperatorInformation> {
    private String phoneNumber;
    private String nationalFormat;
    private String internationalFormat;
    private String isoCountryCode;
    private OperatorNumberType numberType;
    private OperatorDetails operatorDetails;

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public String getNationalFormat() {
        return this.nationalFormat;
    }

    public String getInternationalFormat() {
        return this.internationalFormat;
    }

    public String getIsoCountryCode() {
        return this.isoCountryCode;
    }

    public OperatorNumberType getNumberType() {
        return this.numberType;
    }

    public OperatorDetails getOperatorDetails() {
        return this.operatorDetails;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static OperatorInformation fromJson(JsonReader jsonReader) throws IOException {
        return (OperatorInformation)jsonReader.readObject(reader -> {
            OperatorInformation deserializedOperatorInformation = new OperatorInformation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("phoneNumber".equals(fieldName)) {
                    deserializedOperatorInformation.phoneNumber = reader.getString();
                    continue;
                }
                if ("nationalFormat".equals(fieldName)) {
                    deserializedOperatorInformation.nationalFormat = reader.getString();
                    continue;
                }
                if ("internationalFormat".equals(fieldName)) {
                    deserializedOperatorInformation.internationalFormat = reader.getString();
                    continue;
                }
                if ("isoCountryCode".equals(fieldName)) {
                    deserializedOperatorInformation.isoCountryCode = reader.getString();
                    continue;
                }
                if ("numberType".equals(fieldName)) {
                    deserializedOperatorInformation.numberType = OperatorNumberType.fromString(reader.getString());
                    continue;
                }
                if ("operatorDetails".equals(fieldName)) {
                    deserializedOperatorInformation.operatorDetails = OperatorDetails.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOperatorInformation;
        });
    }
}

