/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.common;

import com.azure.communication.common.CommunicationCloudEnvironment;
import com.azure.communication.common.CommunicationIdentifier;
import com.azure.core.util.CoreUtils;

public final class MicrosoftTeamsAppIdentifier
extends CommunicationIdentifier {
    private final String appId;
    private final CommunicationCloudEnvironment cloudEnvironment;

    public MicrosoftTeamsAppIdentifier(String appId, CommunicationCloudEnvironment cloudEnvironment) {
        if (CoreUtils.isNullOrEmpty((CharSequence)appId)) {
            throw new IllegalArgumentException("The initialization parameter [appId] cannot be null or empty.");
        }
        this.appId = appId;
        this.cloudEnvironment = cloudEnvironment;
        this.generateRawId();
    }

    public MicrosoftTeamsAppIdentifier(String appId) {
        this(appId, CommunicationCloudEnvironment.PUBLIC);
    }

    public String getAppId() {
        return this.appId;
    }

    public CommunicationCloudEnvironment getCloudEnvironment() {
        return this.cloudEnvironment;
    }

    @Override
    protected MicrosoftTeamsAppIdentifier setRawId(String rawId) {
        super.setRawId(rawId);
        return this;
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof MicrosoftTeamsAppIdentifier)) {
            return false;
        }
        return ((MicrosoftTeamsAppIdentifier)that).getRawId().equals(this.getRawId());
    }

    @Override
    public int hashCode() {
        return this.getRawId().hashCode();
    }

    private void generateRawId() {
        if (this.cloudEnvironment.equals((Object)CommunicationCloudEnvironment.DOD)) {
            super.setRawId("28:dod:" + this.appId);
        } else if (this.cloudEnvironment.equals((Object)CommunicationCloudEnvironment.GCCH)) {
            super.setRawId("28:gcch:" + this.appId);
        } else {
            super.setRawId("28:orgid:" + this.appId);
        }
    }
}

