/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.WebAuthenticationType;
import com.azure.analytics.synapse.artifacts.models.WebLinkedServiceTypeProperties;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class WebAnonymousAuthentication
extends WebLinkedServiceTypeProperties {
    private WebAuthenticationType authenticationType = WebAuthenticationType.ANONYMOUS;

    @Override
    public WebAuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    @Override
    public WebAnonymousAuthentication setUrl(Object url) {
        super.setUrl(url);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("url", this.getUrl());
        jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
        return jsonWriter.writeEndObject();
    }

    public static WebAnonymousAuthentication fromJson(JsonReader jsonReader) throws IOException {
        return (WebAnonymousAuthentication)jsonReader.readObject(reader -> {
            WebAnonymousAuthentication deserializedWebAnonymousAuthentication = new WebAnonymousAuthentication();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("url".equals(fieldName)) {
                    deserializedWebAnonymousAuthentication.setUrl(reader.readUntyped());
                    continue;
                }
                if ("authenticationType".equals(fieldName)) {
                    deserializedWebAnonymousAuthentication.authenticationType = WebAuthenticationType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWebAnonymousAuthentication;
        });
    }
}

