/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.CopySink;
import com.azure.analytics.synapse.artifacts.models.DWCopyCommandSettings;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class WarehouseSink
extends CopySink {
    private String type = "WarehouseSink";
    private Object preCopyScript;
    private Object allowCopyCommand;
    private DWCopyCommandSettings copyCommandSettings;
    private Object tableOption;
    private Object writeBehavior;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getPreCopyScript() {
        return this.preCopyScript;
    }

    public WarehouseSink setPreCopyScript(Object preCopyScript) {
        this.preCopyScript = preCopyScript;
        return this;
    }

    public Object getAllowCopyCommand() {
        return this.allowCopyCommand;
    }

    public WarehouseSink setAllowCopyCommand(Object allowCopyCommand) {
        this.allowCopyCommand = allowCopyCommand;
        return this;
    }

    public DWCopyCommandSettings getCopyCommandSettings() {
        return this.copyCommandSettings;
    }

    public WarehouseSink setCopyCommandSettings(DWCopyCommandSettings copyCommandSettings) {
        this.copyCommandSettings = copyCommandSettings;
        return this;
    }

    public Object getTableOption() {
        return this.tableOption;
    }

    public WarehouseSink setTableOption(Object tableOption) {
        this.tableOption = tableOption;
        return this;
    }

    public Object getWriteBehavior() {
        return this.writeBehavior;
    }

    public WarehouseSink setWriteBehavior(Object writeBehavior) {
        this.writeBehavior = writeBehavior;
        return this;
    }

    @Override
    public WarehouseSink setWriteBatchSize(Object writeBatchSize) {
        super.setWriteBatchSize(writeBatchSize);
        return this;
    }

    @Override
    public WarehouseSink setWriteBatchTimeout(Object writeBatchTimeout) {
        super.setWriteBatchTimeout(writeBatchTimeout);
        return this;
    }

    @Override
    public WarehouseSink setSinkRetryCount(Object sinkRetryCount) {
        super.setSinkRetryCount(sinkRetryCount);
        return this;
    }

    @Override
    public WarehouseSink setSinkRetryWait(Object sinkRetryWait) {
        super.setSinkRetryWait(sinkRetryWait);
        return this;
    }

    @Override
    public WarehouseSink setMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.setMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.getWriteBatchSize() != null) {
            jsonWriter.writeUntypedField("writeBatchSize", this.getWriteBatchSize());
        }
        if (this.getWriteBatchTimeout() != null) {
            jsonWriter.writeUntypedField("writeBatchTimeout", this.getWriteBatchTimeout());
        }
        if (this.getSinkRetryCount() != null) {
            jsonWriter.writeUntypedField("sinkRetryCount", this.getSinkRetryCount());
        }
        if (this.getSinkRetryWait() != null) {
            jsonWriter.writeUntypedField("sinkRetryWait", this.getSinkRetryWait());
        }
        if (this.getMaxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.getMaxConcurrentConnections());
        }
        jsonWriter.writeStringField("type", this.type);
        if (this.preCopyScript != null) {
            jsonWriter.writeUntypedField("preCopyScript", this.preCopyScript);
        }
        if (this.allowCopyCommand != null) {
            jsonWriter.writeUntypedField("allowCopyCommand", this.allowCopyCommand);
        }
        jsonWriter.writeJsonField("copyCommandSettings", (JsonSerializable)this.copyCommandSettings);
        if (this.tableOption != null) {
            jsonWriter.writeUntypedField("tableOption", this.tableOption);
        }
        if (this.writeBehavior != null) {
            jsonWriter.writeUntypedField("writeBehavior", this.writeBehavior);
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static WarehouseSink fromJson(JsonReader jsonReader) throws IOException {
        return (WarehouseSink)jsonReader.readObject(reader -> {
            WarehouseSink deserializedWarehouseSink = new WarehouseSink();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("writeBatchSize".equals(fieldName)) {
                    deserializedWarehouseSink.setWriteBatchSize(reader.readUntyped());
                    continue;
                }
                if ("writeBatchTimeout".equals(fieldName)) {
                    deserializedWarehouseSink.setWriteBatchTimeout(reader.readUntyped());
                    continue;
                }
                if ("sinkRetryCount".equals(fieldName)) {
                    deserializedWarehouseSink.setSinkRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sinkRetryWait".equals(fieldName)) {
                    deserializedWarehouseSink.setSinkRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedWarehouseSink.setMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedWarehouseSink.type = reader.getString();
                    continue;
                }
                if ("preCopyScript".equals(fieldName)) {
                    deserializedWarehouseSink.preCopyScript = reader.readUntyped();
                    continue;
                }
                if ("allowCopyCommand".equals(fieldName)) {
                    deserializedWarehouseSink.allowCopyCommand = reader.readUntyped();
                    continue;
                }
                if ("copyCommandSettings".equals(fieldName)) {
                    deserializedWarehouseSink.copyCommandSettings = DWCopyCommandSettings.fromJson(reader);
                    continue;
                }
                if ("tableOption".equals(fieldName)) {
                    deserializedWarehouseSink.tableOption = reader.readUntyped();
                    continue;
                }
                if ("writeBehavior".equals(fieldName)) {
                    deserializedWarehouseSink.writeBehavior = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedWarehouseSink.setAdditionalProperties(additionalProperties);
            return deserializedWarehouseSink;
        });
    }
}

