/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.DependencyReference;
import com.azure.analytics.synapse.artifacts.models.RetryPolicy;
import com.azure.analytics.synapse.artifacts.models.Trigger;
import com.azure.analytics.synapse.artifacts.models.TriggerPipelineReference;
import com.azure.analytics.synapse.artifacts.models.TriggerRuntimeState;
import com.azure.analytics.synapse.artifacts.models.TumblingWindowFrequency;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TumblingWindowTrigger
extends Trigger {
    private String type = "TumblingWindowTrigger";
    private TriggerPipelineReference pipeline;
    private TumblingWindowFrequency frequency;
    private int interval;
    private OffsetDateTime startTime;
    private OffsetDateTime endTime;
    private Object delay;
    private int maxConcurrency;
    private RetryPolicy retryPolicy;
    private List<DependencyReference> dependsOn;

    @Override
    public String getType() {
        return this.type;
    }

    public TriggerPipelineReference getPipeline() {
        return this.pipeline;
    }

    public TumblingWindowTrigger setPipeline(TriggerPipelineReference pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    public TumblingWindowFrequency getFrequency() {
        return this.frequency;
    }

    public TumblingWindowTrigger setFrequency(TumblingWindowFrequency frequency) {
        this.frequency = frequency;
        return this;
    }

    public int getInterval() {
        return this.interval;
    }

    public TumblingWindowTrigger setInterval(int interval) {
        this.interval = interval;
        return this;
    }

    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    public TumblingWindowTrigger setStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public OffsetDateTime getEndTime() {
        return this.endTime;
    }

    public TumblingWindowTrigger setEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    public Object getDelay() {
        return this.delay;
    }

    public TumblingWindowTrigger setDelay(Object delay) {
        this.delay = delay;
        return this;
    }

    public int getMaxConcurrency() {
        return this.maxConcurrency;
    }

    public TumblingWindowTrigger setMaxConcurrency(int maxConcurrency) {
        this.maxConcurrency = maxConcurrency;
        return this;
    }

    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    public TumblingWindowTrigger setRetryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public List<DependencyReference> getDependsOn() {
        return this.dependsOn;
    }

    public TumblingWindowTrigger setDependsOn(List<DependencyReference> dependsOn) {
        this.dependsOn = dependsOn;
        return this;
    }

    @Override
    public TumblingWindowTrigger setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public TumblingWindowTrigger setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("pipeline", (JsonSerializable)this.pipeline);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStartObject("typeProperties");
        jsonWriter.writeStringField("frequency", this.frequency == null ? null : this.frequency.toString());
        jsonWriter.writeIntField("interval", this.interval);
        jsonWriter.writeStringField("startTime", this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("endTime", this.endTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endTime));
        if (this.delay != null) {
            jsonWriter.writeUntypedField("delay", this.delay);
        }
        jsonWriter.writeIntField("maxConcurrency", this.maxConcurrency);
        jsonWriter.writeJsonField("retryPolicy", (JsonSerializable)this.retryPolicy);
        jsonWriter.writeArrayField("dependsOn", this.dependsOn, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeEndObject();
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static TumblingWindowTrigger fromJson(JsonReader jsonReader) throws IOException {
        return (TumblingWindowTrigger)jsonReader.readObject(reader -> {
            TumblingWindowTrigger deserializedTumblingWindowTrigger = new TumblingWindowTrigger();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("description".equals(fieldName)) {
                    deserializedTumblingWindowTrigger.setDescription(reader.getString());
                    continue;
                }
                if ("runtimeState".equals(fieldName)) {
                    deserializedTumblingWindowTrigger.setRuntimeState(TriggerRuntimeState.fromString(reader.getString()));
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedTumblingWindowTrigger.setAnnotations(annotations);
                    continue;
                }
                if ("pipeline".equals(fieldName)) {
                    deserializedTumblingWindowTrigger.pipeline = TriggerPipelineReference.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedTumblingWindowTrigger.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("frequency".equals(fieldName)) {
                            deserializedTumblingWindowTrigger.frequency = TumblingWindowFrequency.fromString(reader.getString());
                            continue;
                        }
                        if ("interval".equals(fieldName)) {
                            deserializedTumblingWindowTrigger.interval = reader.getInt();
                            continue;
                        }
                        if ("startTime".equals(fieldName)) {
                            deserializedTumblingWindowTrigger.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                            continue;
                        }
                        if ("endTime".equals(fieldName)) {
                            deserializedTumblingWindowTrigger.endTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                            continue;
                        }
                        if ("delay".equals(fieldName)) {
                            deserializedTumblingWindowTrigger.delay = reader.readUntyped();
                            continue;
                        }
                        if ("maxConcurrency".equals(fieldName)) {
                            deserializedTumblingWindowTrigger.maxConcurrency = reader.getInt();
                            continue;
                        }
                        if ("retryPolicy".equals(fieldName)) {
                            deserializedTumblingWindowTrigger.retryPolicy = RetryPolicy.fromJson(reader);
                            continue;
                        }
                        if ("dependsOn".equals(fieldName)) {
                            List dependsOn;
                            deserializedTumblingWindowTrigger.dependsOn = dependsOn = reader.readArray(reader1 -> DependencyReference.fromJson(reader1));
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedTumblingWindowTrigger.setAdditionalProperties(additionalProperties);
            return deserializedTumblingWindowTrigger;
        });
    }
}

