/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.Activity;
import com.azure.analytics.synapse.artifacts.models.ActivityDependency;
import com.azure.analytics.synapse.artifacts.models.ActivityOnInactiveMarkAs;
import com.azure.analytics.synapse.artifacts.models.ActivityState;
import com.azure.analytics.synapse.artifacts.models.ControlActivity;
import com.azure.analytics.synapse.artifacts.models.Expression;
import com.azure.analytics.synapse.artifacts.models.SwitchCase;
import com.azure.analytics.synapse.artifacts.models.UserProperty;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SwitchActivity
extends ControlActivity {
    private String type = "Switch";
    private Expression on;
    private List<SwitchCase> cases;
    private List<Activity> defaultActivities;

    @Override
    public String getType() {
        return this.type;
    }

    public Expression getOn() {
        return this.on;
    }

    public SwitchActivity setOn(Expression on) {
        this.on = on;
        return this;
    }

    public List<SwitchCase> getCases() {
        return this.cases;
    }

    public SwitchActivity setCases(List<SwitchCase> cases) {
        this.cases = cases;
        return this;
    }

    public List<Activity> getDefaultActivities() {
        return this.defaultActivities;
    }

    public SwitchActivity setDefaultActivities(List<Activity> defaultActivities) {
        this.defaultActivities = defaultActivities;
        return this;
    }

    @Override
    public SwitchActivity setName(String name) {
        super.setName(name);
        return this;
    }

    @Override
    public SwitchActivity setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public SwitchActivity setState(ActivityState state) {
        super.setState(state);
        return this;
    }

    @Override
    public SwitchActivity setOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.setOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    @Override
    public SwitchActivity setDependsOn(List<ActivityDependency> dependsOn) {
        super.setDependsOn((List)dependsOn);
        return this;
    }

    @Override
    public SwitchActivity setUserProperties(List<UserProperty> userProperties) {
        super.setUserProperties((List)userProperties);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeStringField("state", this.getState() == null ? null : this.getState().toString());
        jsonWriter.writeStringField("onInactiveMarkAs", this.getOnInactiveMarkAs() == null ? null : this.getOnInactiveMarkAs().toString());
        jsonWriter.writeArrayField("dependsOn", this.getDependsOn(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("userProperties", this.getUserProperties(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("type", this.type);
        if (this.on != null || this.cases != null || this.defaultActivities != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeJsonField("on", (JsonSerializable)this.on);
            jsonWriter.writeArrayField("cases", this.cases, (writer, element) -> writer.writeJson((JsonSerializable)element));
            jsonWriter.writeArrayField("defaultActivities", this.defaultActivities, (writer, element) -> writer.writeJson((JsonSerializable)element));
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SwitchActivity fromJson(JsonReader jsonReader) throws IOException {
        return (SwitchActivity)jsonReader.readObject(reader -> {
            SwitchActivity deserializedSwitchActivity = new SwitchActivity();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedSwitchActivity.setName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedSwitchActivity.setDescription(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedSwitchActivity.setState(ActivityState.fromString(reader.getString()));
                    continue;
                }
                if ("onInactiveMarkAs".equals(fieldName)) {
                    deserializedSwitchActivity.setOnInactiveMarkAs(ActivityOnInactiveMarkAs.fromString(reader.getString()));
                    continue;
                }
                if ("dependsOn".equals(fieldName)) {
                    List dependsOn = reader.readArray(reader1 -> ActivityDependency.fromJson(reader1));
                    deserializedSwitchActivity.setDependsOn(dependsOn);
                    continue;
                }
                if ("userProperties".equals(fieldName)) {
                    List userProperties = reader.readArray(reader1 -> UserProperty.fromJson(reader1));
                    deserializedSwitchActivity.setUserProperties(userProperties);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSwitchActivity.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("on".equals(fieldName)) {
                            deserializedSwitchActivity.on = Expression.fromJson(reader);
                            continue;
                        }
                        if ("cases".equals(fieldName)) {
                            List cases;
                            deserializedSwitchActivity.cases = cases = reader.readArray(reader1 -> SwitchCase.fromJson(reader1));
                            continue;
                        }
                        if ("defaultActivities".equals(fieldName)) {
                            List defaultActivities;
                            deserializedSwitchActivity.defaultActivities = defaultActivities = reader.readArray(reader1 -> Activity.fromJson(reader1));
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSwitchActivity.setAdditionalProperties(additionalProperties);
            return deserializedSwitchActivity;
        });
    }
}

