/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.SecretBase;
import com.azure.analytics.synapse.artifacts.models.SsisAccessCredential;
import com.azure.analytics.synapse.artifacts.models.SsisChildPackage;
import com.azure.analytics.synapse.artifacts.models.SsisPackageLocationType;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public class SsisPackageLocation
implements JsonSerializable<SsisPackageLocation> {
    private Object packagePath;
    private SsisPackageLocationType type;
    private SecretBase packagePassword;
    private SsisAccessCredential accessCredential;
    private Object configurationPath;
    private SsisAccessCredential configurationAccessCredential;
    private String packageName;
    private Object packageContent;
    private String packageLastModifiedDate;
    private List<SsisChildPackage> childPackages;

    public Object getPackagePath() {
        return this.packagePath;
    }

    public SsisPackageLocation setPackagePath(Object packagePath) {
        this.packagePath = packagePath;
        return this;
    }

    public SsisPackageLocationType getType() {
        return this.type;
    }

    public SsisPackageLocation setType(SsisPackageLocationType type) {
        this.type = type;
        return this;
    }

    public SecretBase getPackagePassword() {
        return this.packagePassword;
    }

    public SsisPackageLocation setPackagePassword(SecretBase packagePassword) {
        this.packagePassword = packagePassword;
        return this;
    }

    public SsisAccessCredential getAccessCredential() {
        return this.accessCredential;
    }

    public SsisPackageLocation setAccessCredential(SsisAccessCredential accessCredential) {
        this.accessCredential = accessCredential;
        return this;
    }

    public Object getConfigurationPath() {
        return this.configurationPath;
    }

    public SsisPackageLocation setConfigurationPath(Object configurationPath) {
        this.configurationPath = configurationPath;
        return this;
    }

    public SsisAccessCredential getConfigurationAccessCredential() {
        return this.configurationAccessCredential;
    }

    public SsisPackageLocation setConfigurationAccessCredential(SsisAccessCredential configurationAccessCredential) {
        this.configurationAccessCredential = configurationAccessCredential;
        return this;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public SsisPackageLocation setPackageName(String packageName) {
        this.packageName = packageName;
        return this;
    }

    public Object getPackageContent() {
        return this.packageContent;
    }

    public SsisPackageLocation setPackageContent(Object packageContent) {
        this.packageContent = packageContent;
        return this;
    }

    public String getPackageLastModifiedDate() {
        return this.packageLastModifiedDate;
    }

    public SsisPackageLocation setPackageLastModifiedDate(String packageLastModifiedDate) {
        this.packageLastModifiedDate = packageLastModifiedDate;
        return this;
    }

    public List<SsisChildPackage> getChildPackages() {
        return this.childPackages;
    }

    public SsisPackageLocation setChildPackages(List<SsisChildPackage> childPackages) {
        this.childPackages = childPackages;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.packagePath != null) {
            jsonWriter.writeUntypedField("packagePath", this.packagePath);
        }
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        if (this.packagePassword != null || this.accessCredential != null || this.configurationPath != null || this.configurationAccessCredential != null || this.packageName != null || this.packageContent != null || this.packageLastModifiedDate != null || this.childPackages != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeJsonField("packagePassword", (JsonSerializable)this.packagePassword);
            jsonWriter.writeJsonField("accessCredential", (JsonSerializable)this.accessCredential);
            if (this.configurationPath != null) {
                jsonWriter.writeUntypedField("configurationPath", this.configurationPath);
            }
            jsonWriter.writeJsonField("configurationAccessCredential", (JsonSerializable)this.configurationAccessCredential);
            jsonWriter.writeStringField("packageName", this.packageName);
            if (this.packageContent != null) {
                jsonWriter.writeUntypedField("packageContent", this.packageContent);
            }
            jsonWriter.writeStringField("packageLastModifiedDate", this.packageLastModifiedDate);
            jsonWriter.writeArrayField("childPackages", this.childPackages, (writer, element) -> writer.writeJson((JsonSerializable)element));
            jsonWriter.writeEndObject();
        }
        return jsonWriter.writeEndObject();
    }

    public static SsisPackageLocation fromJson(JsonReader jsonReader) throws IOException {
        return (SsisPackageLocation)jsonReader.readObject(reader -> {
            SsisPackageLocation deserializedSsisPackageLocation = new SsisPackageLocation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("packagePath".equals(fieldName)) {
                    deserializedSsisPackageLocation.packagePath = reader.readUntyped();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSsisPackageLocation.type = SsisPackageLocationType.fromString(reader.getString());
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("packagePassword".equals(fieldName)) {
                            deserializedSsisPackageLocation.packagePassword = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("accessCredential".equals(fieldName)) {
                            deserializedSsisPackageLocation.accessCredential = SsisAccessCredential.fromJson(reader);
                            continue;
                        }
                        if ("configurationPath".equals(fieldName)) {
                            deserializedSsisPackageLocation.configurationPath = reader.readUntyped();
                            continue;
                        }
                        if ("configurationAccessCredential".equals(fieldName)) {
                            deserializedSsisPackageLocation.configurationAccessCredential = SsisAccessCredential.fromJson(reader);
                            continue;
                        }
                        if ("packageName".equals(fieldName)) {
                            deserializedSsisPackageLocation.packageName = reader.getString();
                            continue;
                        }
                        if ("packageContent".equals(fieldName)) {
                            deserializedSsisPackageLocation.packageContent = reader.readUntyped();
                            continue;
                        }
                        if ("packageLastModifiedDate".equals(fieldName)) {
                            deserializedSsisPackageLocation.packageLastModifiedDate = reader.getString();
                            continue;
                        }
                        if ("childPackages".equals(fieldName)) {
                            List childPackages;
                            deserializedSsisPackageLocation.childPackages = childPackages = reader.readArray(reader1 -> SsisChildPackage.fromJson(reader1));
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSsisPackageLocation;
        });
    }
}

