/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.Activity;
import com.azure.analytics.synapse.artifacts.models.ActivityDependency;
import com.azure.analytics.synapse.artifacts.models.ActivityOnInactiveMarkAs;
import com.azure.analytics.synapse.artifacts.models.ActivityState;
import com.azure.analytics.synapse.artifacts.models.SqlPoolReference;
import com.azure.analytics.synapse.artifacts.models.UserProperty;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SqlPoolStoredProcedureActivity
extends Activity {
    private String type = "SqlPoolStoredProcedure";
    private SqlPoolReference sqlPool;
    private Object storedProcedureName;
    private Object storedProcedureParameters;

    @Override
    public String getType() {
        return this.type;
    }

    public SqlPoolReference getSqlPool() {
        return this.sqlPool;
    }

    public SqlPoolStoredProcedureActivity setSqlPool(SqlPoolReference sqlPool) {
        this.sqlPool = sqlPool;
        return this;
    }

    public Object getStoredProcedureName() {
        return this.storedProcedureName;
    }

    public SqlPoolStoredProcedureActivity setStoredProcedureName(Object storedProcedureName) {
        this.storedProcedureName = storedProcedureName;
        return this;
    }

    public Object getStoredProcedureParameters() {
        return this.storedProcedureParameters;
    }

    public SqlPoolStoredProcedureActivity setStoredProcedureParameters(Object storedProcedureParameters) {
        this.storedProcedureParameters = storedProcedureParameters;
        return this;
    }

    @Override
    public SqlPoolStoredProcedureActivity setName(String name) {
        super.setName(name);
        return this;
    }

    @Override
    public SqlPoolStoredProcedureActivity setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public SqlPoolStoredProcedureActivity setState(ActivityState state) {
        super.setState(state);
        return this;
    }

    @Override
    public SqlPoolStoredProcedureActivity setOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.setOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    @Override
    public SqlPoolStoredProcedureActivity setDependsOn(List<ActivityDependency> dependsOn) {
        super.setDependsOn(dependsOn);
        return this;
    }

    @Override
    public SqlPoolStoredProcedureActivity setUserProperties(List<UserProperty> userProperties) {
        super.setUserProperties(userProperties);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeStringField("state", this.getState() == null ? null : this.getState().toString());
        jsonWriter.writeStringField("onInactiveMarkAs", this.getOnInactiveMarkAs() == null ? null : this.getOnInactiveMarkAs().toString());
        jsonWriter.writeArrayField("dependsOn", this.getDependsOn(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("userProperties", this.getUserProperties(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("sqlPool", (JsonSerializable)this.sqlPool);
        jsonWriter.writeStringField("type", this.type);
        if (this.storedProcedureName != null || this.storedProcedureParameters != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeUntypedField("storedProcedureName", this.storedProcedureName);
            if (this.storedProcedureParameters != null) {
                jsonWriter.writeUntypedField("storedProcedureParameters", this.storedProcedureParameters);
            }
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SqlPoolStoredProcedureActivity fromJson(JsonReader jsonReader) throws IOException {
        return (SqlPoolStoredProcedureActivity)jsonReader.readObject(reader -> {
            SqlPoolStoredProcedureActivity deserializedSqlPoolStoredProcedureActivity = new SqlPoolStoredProcedureActivity();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedSqlPoolStoredProcedureActivity.setName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedSqlPoolStoredProcedureActivity.setDescription(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedSqlPoolStoredProcedureActivity.setState(ActivityState.fromString(reader.getString()));
                    continue;
                }
                if ("onInactiveMarkAs".equals(fieldName)) {
                    deserializedSqlPoolStoredProcedureActivity.setOnInactiveMarkAs(ActivityOnInactiveMarkAs.fromString(reader.getString()));
                    continue;
                }
                if ("dependsOn".equals(fieldName)) {
                    List dependsOn = reader.readArray(reader1 -> ActivityDependency.fromJson(reader1));
                    deserializedSqlPoolStoredProcedureActivity.setDependsOn(dependsOn);
                    continue;
                }
                if ("userProperties".equals(fieldName)) {
                    List userProperties = reader.readArray(reader1 -> UserProperty.fromJson(reader1));
                    deserializedSqlPoolStoredProcedureActivity.setUserProperties(userProperties);
                    continue;
                }
                if ("sqlPool".equals(fieldName)) {
                    deserializedSqlPoolStoredProcedureActivity.sqlPool = SqlPoolReference.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSqlPoolStoredProcedureActivity.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("storedProcedureName".equals(fieldName)) {
                            deserializedSqlPoolStoredProcedureActivity.storedProcedureName = reader.readUntyped();
                            continue;
                        }
                        if ("storedProcedureParameters".equals(fieldName)) {
                            deserializedSqlPoolStoredProcedureActivity.storedProcedureParameters = reader.readUntyped();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSqlPoolStoredProcedureActivity.setAdditionalProperties(additionalProperties);
            return deserializedSqlPoolStoredProcedureActivity;
        });
    }
}

