/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.SchedulerCurrentState;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class SparkScheduler
implements JsonSerializable<SparkScheduler> {
    private OffsetDateTime submittedAt;
    private OffsetDateTime scheduledAt;
    private OffsetDateTime endedAt;
    private OffsetDateTime cancellationRequestedAt;
    private SchedulerCurrentState currentState;

    public OffsetDateTime getSubmittedAt() {
        return this.submittedAt;
    }

    public SparkScheduler setSubmittedAt(OffsetDateTime submittedAt) {
        this.submittedAt = submittedAt;
        return this;
    }

    public OffsetDateTime getScheduledAt() {
        return this.scheduledAt;
    }

    public SparkScheduler setScheduledAt(OffsetDateTime scheduledAt) {
        this.scheduledAt = scheduledAt;
        return this;
    }

    public OffsetDateTime getEndedAt() {
        return this.endedAt;
    }

    public SparkScheduler setEndedAt(OffsetDateTime endedAt) {
        this.endedAt = endedAt;
        return this;
    }

    public OffsetDateTime getCancellationRequestedAt() {
        return this.cancellationRequestedAt;
    }

    public SparkScheduler setCancellationRequestedAt(OffsetDateTime cancellationRequestedAt) {
        this.cancellationRequestedAt = cancellationRequestedAt;
        return this;
    }

    public SchedulerCurrentState getCurrentState() {
        return this.currentState;
    }

    public SparkScheduler setCurrentState(SchedulerCurrentState currentState) {
        this.currentState = currentState;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("submittedAt", this.submittedAt == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.submittedAt));
        jsonWriter.writeStringField("scheduledAt", this.scheduledAt == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.scheduledAt));
        jsonWriter.writeStringField("endedAt", this.endedAt == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endedAt));
        jsonWriter.writeStringField("cancellationRequestedAt", this.cancellationRequestedAt == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.cancellationRequestedAt));
        jsonWriter.writeStringField("currentState", this.currentState == null ? null : this.currentState.toString());
        return jsonWriter.writeEndObject();
    }

    public static SparkScheduler fromJson(JsonReader jsonReader) throws IOException {
        return (SparkScheduler)jsonReader.readObject(reader -> {
            SparkScheduler deserializedSparkScheduler = new SparkScheduler();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("submittedAt".equals(fieldName)) {
                    deserializedSparkScheduler.submittedAt = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("scheduledAt".equals(fieldName)) {
                    deserializedSparkScheduler.scheduledAt = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endedAt".equals(fieldName)) {
                    deserializedSparkScheduler.endedAt = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("cancellationRequestedAt".equals(fieldName)) {
                    deserializedSparkScheduler.cancellationRequestedAt = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("currentState".equals(fieldName)) {
                    deserializedSparkScheduler.currentState = SchedulerCurrentState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSparkScheduler;
        });
    }
}

