/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.BigDataPoolReference;
import com.azure.analytics.synapse.artifacts.models.SparkConfigurationReference;
import com.azure.analytics.synapse.artifacts.models.SparkJobDefinitionFolder;
import com.azure.analytics.synapse.artifacts.models.SparkJobProperties;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class SparkJobDefinition
implements JsonSerializable<SparkJobDefinition> {
    private String description;
    private BigDataPoolReference targetBigDataPool;
    private SparkConfigurationReference targetSparkConfiguration;
    private String requiredSparkVersion;
    private String language;
    private SparkJobProperties jobProperties;
    private SparkJobDefinitionFolder folder;
    private Map<String, Object> additionalProperties;

    public String getDescription() {
        return this.description;
    }

    public SparkJobDefinition setDescription(String description) {
        this.description = description;
        return this;
    }

    public BigDataPoolReference getTargetBigDataPool() {
        return this.targetBigDataPool;
    }

    public SparkJobDefinition setTargetBigDataPool(BigDataPoolReference targetBigDataPool) {
        this.targetBigDataPool = targetBigDataPool;
        return this;
    }

    public SparkConfigurationReference getTargetSparkConfiguration() {
        return this.targetSparkConfiguration;
    }

    public SparkJobDefinition setTargetSparkConfiguration(SparkConfigurationReference targetSparkConfiguration) {
        this.targetSparkConfiguration = targetSparkConfiguration;
        return this;
    }

    public String getRequiredSparkVersion() {
        return this.requiredSparkVersion;
    }

    public SparkJobDefinition setRequiredSparkVersion(String requiredSparkVersion) {
        this.requiredSparkVersion = requiredSparkVersion;
        return this;
    }

    public String getLanguage() {
        return this.language;
    }

    public SparkJobDefinition setLanguage(String language) {
        this.language = language;
        return this;
    }

    public SparkJobProperties getJobProperties() {
        return this.jobProperties;
    }

    public SparkJobDefinition setJobProperties(SparkJobProperties jobProperties) {
        this.jobProperties = jobProperties;
        return this;
    }

    public SparkJobDefinitionFolder getFolder() {
        return this.folder;
    }

    public SparkJobDefinition setFolder(SparkJobDefinitionFolder folder) {
        this.folder = folder;
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public SparkJobDefinition setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("targetBigDataPool", (JsonSerializable)this.targetBigDataPool);
        jsonWriter.writeJsonField("jobProperties", (JsonSerializable)this.jobProperties);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeJsonField("targetSparkConfiguration", (JsonSerializable)this.targetSparkConfiguration);
        jsonWriter.writeStringField("requiredSparkVersion", this.requiredSparkVersion);
        jsonWriter.writeStringField("language", this.language);
        jsonWriter.writeJsonField("folder", (JsonSerializable)this.folder);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SparkJobDefinition fromJson(JsonReader jsonReader) throws IOException {
        return (SparkJobDefinition)jsonReader.readObject(reader -> {
            SparkJobDefinition deserializedSparkJobDefinition = new SparkJobDefinition();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("targetBigDataPool".equals(fieldName)) {
                    deserializedSparkJobDefinition.targetBigDataPool = BigDataPoolReference.fromJson(reader);
                    continue;
                }
                if ("jobProperties".equals(fieldName)) {
                    deserializedSparkJobDefinition.jobProperties = SparkJobProperties.fromJson(reader);
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedSparkJobDefinition.description = reader.getString();
                    continue;
                }
                if ("targetSparkConfiguration".equals(fieldName)) {
                    deserializedSparkJobDefinition.targetSparkConfiguration = SparkConfigurationReference.fromJson(reader);
                    continue;
                }
                if ("requiredSparkVersion".equals(fieldName)) {
                    deserializedSparkJobDefinition.requiredSparkVersion = reader.getString();
                    continue;
                }
                if ("language".equals(fieldName)) {
                    deserializedSparkJobDefinition.language = reader.getString();
                    continue;
                }
                if ("folder".equals(fieldName)) {
                    deserializedSparkJobDefinition.folder = SparkJobDefinitionFolder.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSparkJobDefinition.additionalProperties = additionalProperties;
            return deserializedSparkJobDefinition;
        });
    }
}

