/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.SapTablePartitionSettings;
import com.azure.analytics.synapse.artifacts.models.TabularSource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class SapTableSource
extends TabularSource {
    private String type = "SapTableSource";
    private Object rowCount;
    private Object rowSkips;
    private Object rfcTableFields;
    private Object rfcTableOptions;
    private Object batchSize;
    private Object customRfcReadTableFunctionModule;
    private Object sapDataColumnDelimiter;
    private Object partitionOption;
    private SapTablePartitionSettings partitionSettings;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getRowCount() {
        return this.rowCount;
    }

    public SapTableSource setRowCount(Object rowCount) {
        this.rowCount = rowCount;
        return this;
    }

    public Object getRowSkips() {
        return this.rowSkips;
    }

    public SapTableSource setRowSkips(Object rowSkips) {
        this.rowSkips = rowSkips;
        return this;
    }

    public Object getRfcTableFields() {
        return this.rfcTableFields;
    }

    public SapTableSource setRfcTableFields(Object rfcTableFields) {
        this.rfcTableFields = rfcTableFields;
        return this;
    }

    public Object getRfcTableOptions() {
        return this.rfcTableOptions;
    }

    public SapTableSource setRfcTableOptions(Object rfcTableOptions) {
        this.rfcTableOptions = rfcTableOptions;
        return this;
    }

    public Object getBatchSize() {
        return this.batchSize;
    }

    public SapTableSource setBatchSize(Object batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public Object getCustomRfcReadTableFunctionModule() {
        return this.customRfcReadTableFunctionModule;
    }

    public SapTableSource setCustomRfcReadTableFunctionModule(Object customRfcReadTableFunctionModule) {
        this.customRfcReadTableFunctionModule = customRfcReadTableFunctionModule;
        return this;
    }

    public Object getSapDataColumnDelimiter() {
        return this.sapDataColumnDelimiter;
    }

    public SapTableSource setSapDataColumnDelimiter(Object sapDataColumnDelimiter) {
        this.sapDataColumnDelimiter = sapDataColumnDelimiter;
        return this;
    }

    public Object getPartitionOption() {
        return this.partitionOption;
    }

    public SapTableSource setPartitionOption(Object partitionOption) {
        this.partitionOption = partitionOption;
        return this;
    }

    public SapTablePartitionSettings getPartitionSettings() {
        return this.partitionSettings;
    }

    public SapTableSource setPartitionSettings(SapTablePartitionSettings partitionSettings) {
        this.partitionSettings = partitionSettings;
        return this;
    }

    @Override
    public SapTableSource setQueryTimeout(Object queryTimeout) {
        super.setQueryTimeout(queryTimeout);
        return this;
    }

    @Override
    public SapTableSource setAdditionalColumns(Object additionalColumns) {
        super.setAdditionalColumns(additionalColumns);
        return this;
    }

    @Override
    public SapTableSource setSourceRetryCount(Object sourceRetryCount) {
        super.setSourceRetryCount(sourceRetryCount);
        return this;
    }

    @Override
    public SapTableSource setSourceRetryWait(Object sourceRetryWait) {
        super.setSourceRetryWait(sourceRetryWait);
        return this;
    }

    @Override
    public SapTableSource setMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.setMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.getSourceRetryCount() != null) {
            jsonWriter.writeUntypedField("sourceRetryCount", this.getSourceRetryCount());
        }
        if (this.getSourceRetryWait() != null) {
            jsonWriter.writeUntypedField("sourceRetryWait", this.getSourceRetryWait());
        }
        if (this.getMaxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.getMaxConcurrentConnections());
        }
        if (this.getQueryTimeout() != null) {
            jsonWriter.writeUntypedField("queryTimeout", this.getQueryTimeout());
        }
        if (this.getAdditionalColumns() != null) {
            jsonWriter.writeUntypedField("additionalColumns", this.getAdditionalColumns());
        }
        jsonWriter.writeStringField("type", this.type);
        if (this.rowCount != null) {
            jsonWriter.writeUntypedField("rowCount", this.rowCount);
        }
        if (this.rowSkips != null) {
            jsonWriter.writeUntypedField("rowSkips", this.rowSkips);
        }
        if (this.rfcTableFields != null) {
            jsonWriter.writeUntypedField("rfcTableFields", this.rfcTableFields);
        }
        if (this.rfcTableOptions != null) {
            jsonWriter.writeUntypedField("rfcTableOptions", this.rfcTableOptions);
        }
        if (this.batchSize != null) {
            jsonWriter.writeUntypedField("batchSize", this.batchSize);
        }
        if (this.customRfcReadTableFunctionModule != null) {
            jsonWriter.writeUntypedField("customRfcReadTableFunctionModule", this.customRfcReadTableFunctionModule);
        }
        if (this.sapDataColumnDelimiter != null) {
            jsonWriter.writeUntypedField("sapDataColumnDelimiter", this.sapDataColumnDelimiter);
        }
        if (this.partitionOption != null) {
            jsonWriter.writeUntypedField("partitionOption", this.partitionOption);
        }
        jsonWriter.writeJsonField("partitionSettings", (JsonSerializable)this.partitionSettings);
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SapTableSource fromJson(JsonReader jsonReader) throws IOException {
        return (SapTableSource)jsonReader.readObject(reader -> {
            SapTableSource deserializedSapTableSource = new SapTableSource();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceRetryCount".equals(fieldName)) {
                    deserializedSapTableSource.setSourceRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sourceRetryWait".equals(fieldName)) {
                    deserializedSapTableSource.setSourceRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedSapTableSource.setMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("queryTimeout".equals(fieldName)) {
                    deserializedSapTableSource.setQueryTimeout(reader.readUntyped());
                    continue;
                }
                if ("additionalColumns".equals(fieldName)) {
                    deserializedSapTableSource.setAdditionalColumns(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSapTableSource.type = reader.getString();
                    continue;
                }
                if ("rowCount".equals(fieldName)) {
                    deserializedSapTableSource.rowCount = reader.readUntyped();
                    continue;
                }
                if ("rowSkips".equals(fieldName)) {
                    deserializedSapTableSource.rowSkips = reader.readUntyped();
                    continue;
                }
                if ("rfcTableFields".equals(fieldName)) {
                    deserializedSapTableSource.rfcTableFields = reader.readUntyped();
                    continue;
                }
                if ("rfcTableOptions".equals(fieldName)) {
                    deserializedSapTableSource.rfcTableOptions = reader.readUntyped();
                    continue;
                }
                if ("batchSize".equals(fieldName)) {
                    deserializedSapTableSource.batchSize = reader.readUntyped();
                    continue;
                }
                if ("customRfcReadTableFunctionModule".equals(fieldName)) {
                    deserializedSapTableSource.customRfcReadTableFunctionModule = reader.readUntyped();
                    continue;
                }
                if ("sapDataColumnDelimiter".equals(fieldName)) {
                    deserializedSapTableSource.sapDataColumnDelimiter = reader.readUntyped();
                    continue;
                }
                if ("partitionOption".equals(fieldName)) {
                    deserializedSapTableSource.partitionOption = reader.readUntyped();
                    continue;
                }
                if ("partitionSettings".equals(fieldName)) {
                    deserializedSapTableSource.partitionSettings = SapTablePartitionSettings.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSapTableSource.setAdditionalProperties(additionalProperties);
            return deserializedSapTableSource;
        });
    }
}

