/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.Dataset;
import com.azure.analytics.synapse.artifacts.models.DatasetFolder;
import com.azure.analytics.synapse.artifacts.models.LinkedServiceReference;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SapOpenHubTableDataset
extends Dataset {
    private String type = "SapOpenHubTable";
    private Object openHubDestinationName;
    private Object excludeLastRequest;
    private Object baseRequestId;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getOpenHubDestinationName() {
        return this.openHubDestinationName;
    }

    public SapOpenHubTableDataset setOpenHubDestinationName(Object openHubDestinationName) {
        this.openHubDestinationName = openHubDestinationName;
        return this;
    }

    public Object getExcludeLastRequest() {
        return this.excludeLastRequest;
    }

    public SapOpenHubTableDataset setExcludeLastRequest(Object excludeLastRequest) {
        this.excludeLastRequest = excludeLastRequest;
        return this;
    }

    public Object getBaseRequestId() {
        return this.baseRequestId;
    }

    public SapOpenHubTableDataset setBaseRequestId(Object baseRequestId) {
        this.baseRequestId = baseRequestId;
        return this;
    }

    @Override
    public SapOpenHubTableDataset setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public SapOpenHubTableDataset setStructure(Object structure) {
        super.setStructure(structure);
        return this;
    }

    @Override
    public SapOpenHubTableDataset setSchema(Object schema) {
        super.setSchema(schema);
        return this;
    }

    @Override
    public SapOpenHubTableDataset setLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.setLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public SapOpenHubTableDataset setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public SapOpenHubTableDataset setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public SapOpenHubTableDataset setFolder(DatasetFolder folder) {
        super.setFolder(folder);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.getLinkedServiceName());
        jsonWriter.writeStringField("description", this.getDescription());
        if (this.getStructure() != null) {
            jsonWriter.writeUntypedField("structure", this.getStructure());
        }
        if (this.getSchema() != null) {
            jsonWriter.writeUntypedField("schema", this.getSchema());
        }
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("folder", (JsonSerializable)this.getFolder());
        jsonWriter.writeStringField("type", this.type);
        if (this.openHubDestinationName != null || this.excludeLastRequest != null || this.baseRequestId != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeUntypedField("openHubDestinationName", this.openHubDestinationName);
            if (this.excludeLastRequest != null) {
                jsonWriter.writeUntypedField("excludeLastRequest", this.excludeLastRequest);
            }
            if (this.baseRequestId != null) {
                jsonWriter.writeUntypedField("baseRequestId", this.baseRequestId);
            }
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SapOpenHubTableDataset fromJson(JsonReader jsonReader) throws IOException {
        return (SapOpenHubTableDataset)jsonReader.readObject(reader -> {
            SapOpenHubTableDataset deserializedSapOpenHubTableDataset = new SapOpenHubTableDataset();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedSapOpenHubTableDataset.setLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedSapOpenHubTableDataset.setDescription(reader.getString());
                    continue;
                }
                if ("structure".equals(fieldName)) {
                    deserializedSapOpenHubTableDataset.setStructure(reader.readUntyped());
                    continue;
                }
                if ("schema".equals(fieldName)) {
                    deserializedSapOpenHubTableDataset.setSchema(reader.readUntyped());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedSapOpenHubTableDataset.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedSapOpenHubTableDataset.setAnnotations(annotations);
                    continue;
                }
                if ("folder".equals(fieldName)) {
                    deserializedSapOpenHubTableDataset.setFolder(DatasetFolder.fromJson(reader));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSapOpenHubTableDataset.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("openHubDestinationName".equals(fieldName)) {
                            deserializedSapOpenHubTableDataset.openHubDestinationName = reader.readUntyped();
                            continue;
                        }
                        if ("excludeLastRequest".equals(fieldName)) {
                            deserializedSapOpenHubTableDataset.excludeLastRequest = reader.readUntyped();
                            continue;
                        }
                        if ("baseRequestId".equals(fieldName)) {
                            deserializedSapOpenHubTableDataset.baseRequestId = reader.readUntyped();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSapOpenHubTableDataset.setAdditionalProperties(additionalProperties);
            return deserializedSapOpenHubTableDataset;
        });
    }
}

