/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeReference;
import com.azure.analytics.synapse.artifacts.models.LinkedService;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.analytics.synapse.artifacts.models.SecretBase;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SapOpenHubLinkedService
extends LinkedService {
    private String type = "SapOpenHub";
    private Object server;
    private Object systemNumber;
    private Object clientId;
    private Object language;
    private Object systemId;
    private Object userName;
    private SecretBase password;
    private Object messageServer;
    private Object messageServerService;
    private Object logonGroup;
    private Object encryptedCredential;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getServer() {
        return this.server;
    }

    public SapOpenHubLinkedService setServer(Object server) {
        this.server = server;
        return this;
    }

    public Object getSystemNumber() {
        return this.systemNumber;
    }

    public SapOpenHubLinkedService setSystemNumber(Object systemNumber) {
        this.systemNumber = systemNumber;
        return this;
    }

    public Object getClientId() {
        return this.clientId;
    }

    public SapOpenHubLinkedService setClientId(Object clientId) {
        this.clientId = clientId;
        return this;
    }

    public Object getLanguage() {
        return this.language;
    }

    public SapOpenHubLinkedService setLanguage(Object language) {
        this.language = language;
        return this;
    }

    public Object getSystemId() {
        return this.systemId;
    }

    public SapOpenHubLinkedService setSystemId(Object systemId) {
        this.systemId = systemId;
        return this;
    }

    public Object getUserName() {
        return this.userName;
    }

    public SapOpenHubLinkedService setUserName(Object userName) {
        this.userName = userName;
        return this;
    }

    public SecretBase getPassword() {
        return this.password;
    }

    public SapOpenHubLinkedService setPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public Object getMessageServer() {
        return this.messageServer;
    }

    public SapOpenHubLinkedService setMessageServer(Object messageServer) {
        this.messageServer = messageServer;
        return this;
    }

    public Object getMessageServerService() {
        return this.messageServerService;
    }

    public SapOpenHubLinkedService setMessageServerService(Object messageServerService) {
        this.messageServerService = messageServerService;
        return this;
    }

    public Object getLogonGroup() {
        return this.logonGroup;
    }

    public SapOpenHubLinkedService setLogonGroup(Object logonGroup) {
        this.logonGroup = logonGroup;
        return this;
    }

    public Object getEncryptedCredential() {
        return this.encryptedCredential;
    }

    public SapOpenHubLinkedService setEncryptedCredential(Object encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    @Override
    public SapOpenHubLinkedService setVersion(String version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public SapOpenHubLinkedService setConnectVia(IntegrationRuntimeReference connectVia) {
        super.setConnectVia(connectVia);
        return this;
    }

    @Override
    public SapOpenHubLinkedService setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public SapOpenHubLinkedService setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public SapOpenHubLinkedService setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.getVersion());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.getConnectVia());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("type", this.type);
        if (this.server != null || this.systemNumber != null || this.clientId != null || this.language != null || this.systemId != null || this.userName != null || this.password != null || this.messageServer != null || this.messageServerService != null || this.logonGroup != null || this.encryptedCredential != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeUntypedField("server", this.server);
            jsonWriter.writeUntypedField("systemNumber", this.systemNumber);
            jsonWriter.writeUntypedField("clientId", this.clientId);
            if (this.language != null) {
                jsonWriter.writeUntypedField("language", this.language);
            }
            if (this.systemId != null) {
                jsonWriter.writeUntypedField("systemId", this.systemId);
            }
            if (this.userName != null) {
                jsonWriter.writeUntypedField("userName", this.userName);
            }
            jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
            if (this.messageServer != null) {
                jsonWriter.writeUntypedField("messageServer", this.messageServer);
            }
            if (this.messageServerService != null) {
                jsonWriter.writeUntypedField("messageServerService", this.messageServerService);
            }
            if (this.logonGroup != null) {
                jsonWriter.writeUntypedField("logonGroup", this.logonGroup);
            }
            if (this.encryptedCredential != null) {
                jsonWriter.writeUntypedField("encryptedCredential", this.encryptedCredential);
            }
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SapOpenHubLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (SapOpenHubLinkedService)jsonReader.readObject(reader -> {
            SapOpenHubLinkedService deserializedSapOpenHubLinkedService = new SapOpenHubLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedSapOpenHubLinkedService.setVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedSapOpenHubLinkedService.setConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedSapOpenHubLinkedService.setDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedSapOpenHubLinkedService.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedSapOpenHubLinkedService.setAnnotations(annotations);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSapOpenHubLinkedService.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("server".equals(fieldName)) {
                            deserializedSapOpenHubLinkedService.server = reader.readUntyped();
                            continue;
                        }
                        if ("systemNumber".equals(fieldName)) {
                            deserializedSapOpenHubLinkedService.systemNumber = reader.readUntyped();
                            continue;
                        }
                        if ("clientId".equals(fieldName)) {
                            deserializedSapOpenHubLinkedService.clientId = reader.readUntyped();
                            continue;
                        }
                        if ("language".equals(fieldName)) {
                            deserializedSapOpenHubLinkedService.language = reader.readUntyped();
                            continue;
                        }
                        if ("systemId".equals(fieldName)) {
                            deserializedSapOpenHubLinkedService.systemId = reader.readUntyped();
                            continue;
                        }
                        if ("userName".equals(fieldName)) {
                            deserializedSapOpenHubLinkedService.userName = reader.readUntyped();
                            continue;
                        }
                        if ("password".equals(fieldName)) {
                            deserializedSapOpenHubLinkedService.password = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("messageServer".equals(fieldName)) {
                            deserializedSapOpenHubLinkedService.messageServer = reader.readUntyped();
                            continue;
                        }
                        if ("messageServerService".equals(fieldName)) {
                            deserializedSapOpenHubLinkedService.messageServerService = reader.readUntyped();
                            continue;
                        }
                        if ("logonGroup".equals(fieldName)) {
                            deserializedSapOpenHubLinkedService.logonGroup = reader.readUntyped();
                            continue;
                        }
                        if ("encryptedCredential".equals(fieldName)) {
                            deserializedSapOpenHubLinkedService.encryptedCredential = reader.readUntyped();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSapOpenHubLinkedService.setAdditionalProperties(additionalProperties);
            return deserializedSapOpenHubLinkedService;
        });
    }
}

