/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.CopySink;
import com.azure.analytics.synapse.artifacts.models.SalesforceV2SinkWriteBehavior;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class SalesforceV2Sink
extends CopySink {
    private String type = "SalesforceV2Sink";
    private SalesforceV2SinkWriteBehavior writeBehavior;
    private Object externalIdFieldName;
    private Object ignoreNullValues;

    @Override
    public String getType() {
        return this.type;
    }

    public SalesforceV2SinkWriteBehavior getWriteBehavior() {
        return this.writeBehavior;
    }

    public SalesforceV2Sink setWriteBehavior(SalesforceV2SinkWriteBehavior writeBehavior) {
        this.writeBehavior = writeBehavior;
        return this;
    }

    public Object getExternalIdFieldName() {
        return this.externalIdFieldName;
    }

    public SalesforceV2Sink setExternalIdFieldName(Object externalIdFieldName) {
        this.externalIdFieldName = externalIdFieldName;
        return this;
    }

    public Object getIgnoreNullValues() {
        return this.ignoreNullValues;
    }

    public SalesforceV2Sink setIgnoreNullValues(Object ignoreNullValues) {
        this.ignoreNullValues = ignoreNullValues;
        return this;
    }

    @Override
    public SalesforceV2Sink setWriteBatchSize(Object writeBatchSize) {
        super.setWriteBatchSize(writeBatchSize);
        return this;
    }

    @Override
    public SalesforceV2Sink setWriteBatchTimeout(Object writeBatchTimeout) {
        super.setWriteBatchTimeout(writeBatchTimeout);
        return this;
    }

    @Override
    public SalesforceV2Sink setSinkRetryCount(Object sinkRetryCount) {
        super.setSinkRetryCount(sinkRetryCount);
        return this;
    }

    @Override
    public SalesforceV2Sink setSinkRetryWait(Object sinkRetryWait) {
        super.setSinkRetryWait(sinkRetryWait);
        return this;
    }

    @Override
    public SalesforceV2Sink setMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.setMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.getWriteBatchSize() != null) {
            jsonWriter.writeUntypedField("writeBatchSize", this.getWriteBatchSize());
        }
        if (this.getWriteBatchTimeout() != null) {
            jsonWriter.writeUntypedField("writeBatchTimeout", this.getWriteBatchTimeout());
        }
        if (this.getSinkRetryCount() != null) {
            jsonWriter.writeUntypedField("sinkRetryCount", this.getSinkRetryCount());
        }
        if (this.getSinkRetryWait() != null) {
            jsonWriter.writeUntypedField("sinkRetryWait", this.getSinkRetryWait());
        }
        if (this.getMaxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.getMaxConcurrentConnections());
        }
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("writeBehavior", this.writeBehavior == null ? null : this.writeBehavior.toString());
        if (this.externalIdFieldName != null) {
            jsonWriter.writeUntypedField("externalIdFieldName", this.externalIdFieldName);
        }
        if (this.ignoreNullValues != null) {
            jsonWriter.writeUntypedField("ignoreNullValues", this.ignoreNullValues);
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SalesforceV2Sink fromJson(JsonReader jsonReader) throws IOException {
        return (SalesforceV2Sink)jsonReader.readObject(reader -> {
            SalesforceV2Sink deserializedSalesforceV2Sink = new SalesforceV2Sink();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("writeBatchSize".equals(fieldName)) {
                    deserializedSalesforceV2Sink.setWriteBatchSize(reader.readUntyped());
                    continue;
                }
                if ("writeBatchTimeout".equals(fieldName)) {
                    deserializedSalesforceV2Sink.setWriteBatchTimeout(reader.readUntyped());
                    continue;
                }
                if ("sinkRetryCount".equals(fieldName)) {
                    deserializedSalesforceV2Sink.setSinkRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sinkRetryWait".equals(fieldName)) {
                    deserializedSalesforceV2Sink.setSinkRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedSalesforceV2Sink.setMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSalesforceV2Sink.type = reader.getString();
                    continue;
                }
                if ("writeBehavior".equals(fieldName)) {
                    deserializedSalesforceV2Sink.writeBehavior = SalesforceV2SinkWriteBehavior.fromString(reader.getString());
                    continue;
                }
                if ("externalIdFieldName".equals(fieldName)) {
                    deserializedSalesforceV2Sink.externalIdFieldName = reader.readUntyped();
                    continue;
                }
                if ("ignoreNullValues".equals(fieldName)) {
                    deserializedSalesforceV2Sink.ignoreNullValues = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSalesforceV2Sink.setAdditionalProperties(additionalProperties);
            return deserializedSalesforceV2Sink;
        });
    }
}

