/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.PrivateEndpoint;
import com.azure.analytics.synapse.artifacts.models.PrivateLinkServiceConnectionState;
import com.azure.analytics.synapse.artifacts.models.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public class PrivateEndpointConnection
extends ProxyResource {
    private PrivateEndpoint privateEndpoint;
    private PrivateLinkServiceConnectionState privateLinkServiceConnectionState;
    private String provisioningState;
    private String type;
    private String name;
    private String id;

    public PrivateEndpoint getPrivateEndpoint() {
        return this.privateEndpoint;
    }

    public PrivateEndpointConnection setPrivateEndpoint(PrivateEndpoint privateEndpoint) {
        this.privateEndpoint = privateEndpoint;
        return this;
    }

    public PrivateLinkServiceConnectionState getPrivateLinkServiceConnectionState() {
        return this.privateLinkServiceConnectionState;
    }

    public PrivateEndpointConnection setPrivateLinkServiceConnectionState(PrivateLinkServiceConnectionState privateLinkServiceConnectionState) {
        this.privateLinkServiceConnectionState = privateLinkServiceConnectionState;
        return this;
    }

    public String getProvisioningState() {
        return this.provisioningState;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.privateEndpoint != null || this.privateLinkServiceConnectionState != null || this.provisioningState != null) {
            jsonWriter.writeStartObject("properties");
            jsonWriter.writeJsonField("privateEndpoint", (JsonSerializable)this.privateEndpoint);
            jsonWriter.writeJsonField("privateLinkServiceConnectionState", (JsonSerializable)this.privateLinkServiceConnectionState);
            jsonWriter.writeEndObject();
        }
        return jsonWriter.writeEndObject();
    }

    public static PrivateEndpointConnection fromJson(JsonReader jsonReader) throws IOException {
        return (PrivateEndpointConnection)jsonReader.readObject(reader -> {
            PrivateEndpointConnection deserializedPrivateEndpointConnection = new PrivateEndpointConnection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedPrivateEndpointConnection.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedPrivateEndpointConnection.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedPrivateEndpointConnection.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("privateEndpoint".equals(fieldName)) {
                            deserializedPrivateEndpointConnection.privateEndpoint = PrivateEndpoint.fromJson(reader);
                            continue;
                        }
                        if ("privateLinkServiceConnectionState".equals(fieldName)) {
                            deserializedPrivateEndpointConnection.privateLinkServiceConnectionState = PrivateLinkServiceConnectionState.fromJson(reader);
                            continue;
                        }
                        if ("provisioningState".equals(fieldName)) {
                            deserializedPrivateEndpointConnection.provisioningState = reader.getString();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPrivateEndpointConnection;
        });
    }
}

