/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.Activity;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.analytics.synapse.artifacts.models.PipelineFolder;
import com.azure.analytics.synapse.artifacts.models.SubResource;
import com.azure.analytics.synapse.artifacts.models.VariableSpecification;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class PipelineResource
extends SubResource {
    private String description;
    private List<Activity> activities;
    private Map<String, ParameterSpecification> parameters;
    private Map<String, VariableSpecification> variables;
    private Integer concurrency;
    private List<Object> annotations;
    private Map<String, Object> runDimensions;
    private PipelineFolder folder;
    private Map<String, Object> additionalProperties;
    private String etag;
    private String type;
    private String name;
    private String id;

    public String getDescription() {
        return this.description;
    }

    public PipelineResource setDescription(String description) {
        this.description = description;
        return this;
    }

    public List<Activity> getActivities() {
        return this.activities;
    }

    public PipelineResource setActivities(List<Activity> activities) {
        this.activities = activities;
        return this;
    }

    public Map<String, ParameterSpecification> getParameters() {
        return this.parameters;
    }

    public PipelineResource setParameters(Map<String, ParameterSpecification> parameters) {
        this.parameters = parameters;
        return this;
    }

    public Map<String, VariableSpecification> getVariables() {
        return this.variables;
    }

    public PipelineResource setVariables(Map<String, VariableSpecification> variables) {
        this.variables = variables;
        return this;
    }

    public Integer getConcurrency() {
        return this.concurrency;
    }

    public PipelineResource setConcurrency(Integer concurrency) {
        this.concurrency = concurrency;
        return this;
    }

    public List<Object> getAnnotations() {
        return this.annotations;
    }

    public PipelineResource setAnnotations(List<Object> annotations) {
        this.annotations = annotations;
        return this;
    }

    public Map<String, Object> getRunDimensions() {
        return this.runDimensions;
    }

    public PipelineResource setRunDimensions(Map<String, Object> runDimensions) {
        this.runDimensions = runDimensions;
        return this;
    }

    public PipelineFolder getFolder() {
        return this.folder;
    }

    public PipelineResource setFolder(PipelineFolder folder) {
        this.folder = folder;
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public PipelineResource setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public String getEtag() {
        return this.etag;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.description != null || this.activities != null || this.parameters != null || this.variables != null || this.concurrency != null || this.annotations != null || this.runDimensions != null || this.folder != null) {
            jsonWriter.writeStartObject("properties");
            jsonWriter.writeStringField("description", this.description);
            jsonWriter.writeArrayField("activities", this.activities, (writer, element) -> writer.writeJson((JsonSerializable)element));
            jsonWriter.writeMapField("parameters", this.parameters, (writer, element) -> writer.writeJson((JsonSerializable)element));
            jsonWriter.writeMapField("variables", this.variables, (writer, element) -> writer.writeJson((JsonSerializable)element));
            jsonWriter.writeNumberField("concurrency", (Number)this.concurrency);
            jsonWriter.writeArrayField("annotations", this.annotations, (writer, element) -> writer.writeUntyped(element));
            jsonWriter.writeMapField("runDimensions", this.runDimensions, (writer, element) -> writer.writeUntyped(element));
            jsonWriter.writeJsonField("folder", (JsonSerializable)this.folder);
            jsonWriter.writeEndObject();
        }
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static PipelineResource fromJson(JsonReader jsonReader) throws IOException {
        return (PipelineResource)jsonReader.readObject(reader -> {
            PipelineResource deserializedPipelineResource = new PipelineResource();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedPipelineResource.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedPipelineResource.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedPipelineResource.type = reader.getString();
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedPipelineResource.etag = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("description".equals(fieldName)) {
                            deserializedPipelineResource.description = reader.getString();
                            continue;
                        }
                        if ("activities".equals(fieldName)) {
                            List activities;
                            deserializedPipelineResource.activities = activities = reader.readArray(reader1 -> Activity.fromJson(reader1));
                            continue;
                        }
                        if ("parameters".equals(fieldName)) {
                            Map parameters;
                            deserializedPipelineResource.parameters = parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                            continue;
                        }
                        if ("variables".equals(fieldName)) {
                            Map variables;
                            deserializedPipelineResource.variables = variables = reader.readMap(reader1 -> VariableSpecification.fromJson(reader1));
                            continue;
                        }
                        if ("concurrency".equals(fieldName)) {
                            deserializedPipelineResource.concurrency = (Integer)reader.getNullable(JsonReader::getInt);
                            continue;
                        }
                        if ("annotations".equals(fieldName)) {
                            List annotations;
                            deserializedPipelineResource.annotations = annotations = reader.readArray(reader1 -> reader1.readUntyped());
                            continue;
                        }
                        if ("runDimensions".equals(fieldName)) {
                            Map runDimensions;
                            deserializedPipelineResource.runDimensions = runDimensions = reader.readMap(reader1 -> reader1.readUntyped());
                            continue;
                        }
                        if ("folder".equals(fieldName)) {
                            deserializedPipelineResource.folder = PipelineFolder.fromJson(reader);
                            continue;
                        }
                        if (additionalProperties == null) {
                            additionalProperties = new LinkedHashMap();
                        }
                        additionalProperties.put(fieldName, reader.readUntyped());
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedPipelineResource.additionalProperties = additionalProperties;
            return deserializedPipelineResource;
        });
    }
}

