/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeReference;
import com.azure.analytics.synapse.artifacts.models.LinkedService;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.analytics.synapse.artifacts.models.SecretBase;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class PaypalLinkedService
extends LinkedService {
    private String type = "Paypal";
    private Object host;
    private Object clientId;
    private SecretBase clientSecret;
    private Object useEncryptedEndpoints;
    private Object useHostVerification;
    private Object usePeerVerification;
    private Object encryptedCredential;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getHost() {
        return this.host;
    }

    public PaypalLinkedService setHost(Object host) {
        this.host = host;
        return this;
    }

    public Object getClientId() {
        return this.clientId;
    }

    public PaypalLinkedService setClientId(Object clientId) {
        this.clientId = clientId;
        return this;
    }

    public SecretBase getClientSecret() {
        return this.clientSecret;
    }

    public PaypalLinkedService setClientSecret(SecretBase clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public Object getUseEncryptedEndpoints() {
        return this.useEncryptedEndpoints;
    }

    public PaypalLinkedService setUseEncryptedEndpoints(Object useEncryptedEndpoints) {
        this.useEncryptedEndpoints = useEncryptedEndpoints;
        return this;
    }

    public Object getUseHostVerification() {
        return this.useHostVerification;
    }

    public PaypalLinkedService setUseHostVerification(Object useHostVerification) {
        this.useHostVerification = useHostVerification;
        return this;
    }

    public Object getUsePeerVerification() {
        return this.usePeerVerification;
    }

    public PaypalLinkedService setUsePeerVerification(Object usePeerVerification) {
        this.usePeerVerification = usePeerVerification;
        return this;
    }

    public Object getEncryptedCredential() {
        return this.encryptedCredential;
    }

    public PaypalLinkedService setEncryptedCredential(Object encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    @Override
    public PaypalLinkedService setVersion(String version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public PaypalLinkedService setConnectVia(IntegrationRuntimeReference connectVia) {
        super.setConnectVia(connectVia);
        return this;
    }

    @Override
    public PaypalLinkedService setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public PaypalLinkedService setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public PaypalLinkedService setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.getVersion());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.getConnectVia());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("type", this.type);
        if (this.host != null || this.clientId != null || this.clientSecret != null || this.useEncryptedEndpoints != null || this.useHostVerification != null || this.usePeerVerification != null || this.encryptedCredential != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeUntypedField("host", this.host);
            jsonWriter.writeUntypedField("clientId", this.clientId);
            jsonWriter.writeJsonField("clientSecret", (JsonSerializable)this.clientSecret);
            if (this.useEncryptedEndpoints != null) {
                jsonWriter.writeUntypedField("useEncryptedEndpoints", this.useEncryptedEndpoints);
            }
            if (this.useHostVerification != null) {
                jsonWriter.writeUntypedField("useHostVerification", this.useHostVerification);
            }
            if (this.usePeerVerification != null) {
                jsonWriter.writeUntypedField("usePeerVerification", this.usePeerVerification);
            }
            if (this.encryptedCredential != null) {
                jsonWriter.writeUntypedField("encryptedCredential", this.encryptedCredential);
            }
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static PaypalLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (PaypalLinkedService)jsonReader.readObject(reader -> {
            PaypalLinkedService deserializedPaypalLinkedService = new PaypalLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedPaypalLinkedService.setVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedPaypalLinkedService.setConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedPaypalLinkedService.setDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedPaypalLinkedService.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedPaypalLinkedService.setAnnotations(annotations);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedPaypalLinkedService.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("host".equals(fieldName)) {
                            deserializedPaypalLinkedService.host = reader.readUntyped();
                            continue;
                        }
                        if ("clientId".equals(fieldName)) {
                            deserializedPaypalLinkedService.clientId = reader.readUntyped();
                            continue;
                        }
                        if ("clientSecret".equals(fieldName)) {
                            deserializedPaypalLinkedService.clientSecret = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("useEncryptedEndpoints".equals(fieldName)) {
                            deserializedPaypalLinkedService.useEncryptedEndpoints = reader.readUntyped();
                            continue;
                        }
                        if ("useHostVerification".equals(fieldName)) {
                            deserializedPaypalLinkedService.useHostVerification = reader.readUntyped();
                            continue;
                        }
                        if ("usePeerVerification".equals(fieldName)) {
                            deserializedPaypalLinkedService.usePeerVerification = reader.readUntyped();
                            continue;
                        }
                        if ("encryptedCredential".equals(fieldName)) {
                            deserializedPaypalLinkedService.encryptedCredential = reader.readUntyped();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedPaypalLinkedService.setAdditionalProperties(additionalProperties);
            return deserializedPaypalLinkedService;
        });
    }
}

