/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.CellOutputType;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class NotebookCellOutputItem
implements JsonSerializable<NotebookCellOutputItem> {
    private String name;
    private Integer executionCount;
    private CellOutputType outputType;
    private Object text;
    private Object data;
    private Object metadata;

    public String getName() {
        return this.name;
    }

    public NotebookCellOutputItem setName(String name) {
        this.name = name;
        return this;
    }

    public Integer getExecutionCount() {
        return this.executionCount;
    }

    public NotebookCellOutputItem setExecutionCount(Integer executionCount) {
        this.executionCount = executionCount;
        return this;
    }

    public CellOutputType getOutputType() {
        return this.outputType;
    }

    public NotebookCellOutputItem setOutputType(CellOutputType outputType) {
        this.outputType = outputType;
        return this;
    }

    public Object getText() {
        return this.text;
    }

    public NotebookCellOutputItem setText(Object text) {
        this.text = text;
        return this;
    }

    public Object getData() {
        return this.data;
    }

    public NotebookCellOutputItem setData(Object data) {
        this.data = data;
        return this;
    }

    public Object getMetadata() {
        return this.metadata;
    }

    public NotebookCellOutputItem setMetadata(Object metadata) {
        this.metadata = metadata;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("output_type", this.outputType == null ? null : this.outputType.toString());
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeNumberField("execution_count", (Number)this.executionCount);
        if (this.text != null) {
            jsonWriter.writeUntypedField("text", this.text);
        }
        if (this.data != null) {
            jsonWriter.writeUntypedField("data", this.data);
        }
        if (this.metadata != null) {
            jsonWriter.writeUntypedField("metadata", this.metadata);
        }
        return jsonWriter.writeEndObject();
    }

    public static NotebookCellOutputItem fromJson(JsonReader jsonReader) throws IOException {
        return (NotebookCellOutputItem)jsonReader.readObject(reader -> {
            NotebookCellOutputItem deserializedNotebookCellOutputItem = new NotebookCellOutputItem();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("output_type".equals(fieldName)) {
                    deserializedNotebookCellOutputItem.outputType = CellOutputType.fromString(reader.getString());
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedNotebookCellOutputItem.name = reader.getString();
                    continue;
                }
                if ("execution_count".equals(fieldName)) {
                    deserializedNotebookCellOutputItem.executionCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("text".equals(fieldName)) {
                    deserializedNotebookCellOutputItem.text = reader.readUntyped();
                    continue;
                }
                if ("data".equals(fieldName)) {
                    deserializedNotebookCellOutputItem.data = reader.readUntyped();
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    deserializedNotebookCellOutputItem.metadata = reader.readUntyped();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNotebookCellOutputItem;
        });
    }
}

