/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.DataFlow;
import com.azure.analytics.synapse.artifacts.models.DataFlowFolder;
import com.azure.analytics.synapse.artifacts.models.DataFlowSink;
import com.azure.analytics.synapse.artifacts.models.DataFlowSource;
import com.azure.analytics.synapse.artifacts.models.Transformation;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public class MappingDataFlow
extends DataFlow {
    private String type = "MappingDataFlow";
    private List<DataFlowSource> sources;
    private List<DataFlowSink> sinks;
    private List<Transformation> transformations;
    private String script;
    private List<String> scriptLines;

    @Override
    public String getType() {
        return this.type;
    }

    public List<DataFlowSource> getSources() {
        return this.sources;
    }

    public MappingDataFlow setSources(List<DataFlowSource> sources) {
        this.sources = sources;
        return this;
    }

    public List<DataFlowSink> getSinks() {
        return this.sinks;
    }

    public MappingDataFlow setSinks(List<DataFlowSink> sinks) {
        this.sinks = sinks;
        return this;
    }

    public List<Transformation> getTransformations() {
        return this.transformations;
    }

    public MappingDataFlow setTransformations(List<Transformation> transformations) {
        this.transformations = transformations;
        return this;
    }

    public String getScript() {
        return this.script;
    }

    public MappingDataFlow setScript(String script) {
        this.script = script;
        return this;
    }

    public List<String> getScriptLines() {
        return this.scriptLines;
    }

    public MappingDataFlow setScriptLines(List<String> scriptLines) {
        this.scriptLines = scriptLines;
        return this;
    }

    @Override
    public MappingDataFlow setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public MappingDataFlow setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public MappingDataFlow setFolder(DataFlowFolder folder) {
        super.setFolder(folder);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("folder", (JsonSerializable)this.getFolder());
        jsonWriter.writeStringField("type", this.type);
        if (this.sources != null || this.sinks != null || this.transformations != null || this.script != null || this.scriptLines != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeArrayField("sources", this.sources, (writer, element) -> writer.writeJson((JsonSerializable)element));
            jsonWriter.writeArrayField("sinks", this.sinks, (writer, element) -> writer.writeJson((JsonSerializable)element));
            jsonWriter.writeArrayField("transformations", this.transformations, (writer, element) -> writer.writeJson((JsonSerializable)element));
            jsonWriter.writeStringField("script", this.script);
            jsonWriter.writeArrayField("scriptLines", this.scriptLines, (writer, element) -> writer.writeString(element));
            jsonWriter.writeEndObject();
        }
        return jsonWriter.writeEndObject();
    }

    public static MappingDataFlow fromJson(JsonReader jsonReader) throws IOException {
        return (MappingDataFlow)jsonReader.readObject(reader -> {
            MappingDataFlow deserializedMappingDataFlow = new MappingDataFlow();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("description".equals(fieldName)) {
                    deserializedMappingDataFlow.setDescription(reader.getString());
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedMappingDataFlow.setAnnotations(annotations);
                    continue;
                }
                if ("folder".equals(fieldName)) {
                    deserializedMappingDataFlow.setFolder(DataFlowFolder.fromJson(reader));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedMappingDataFlow.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("sources".equals(fieldName)) {
                            List sources;
                            deserializedMappingDataFlow.sources = sources = reader.readArray(reader1 -> DataFlowSource.fromJson(reader1));
                            continue;
                        }
                        if ("sinks".equals(fieldName)) {
                            List sinks;
                            deserializedMappingDataFlow.sinks = sinks = reader.readArray(reader1 -> DataFlowSink.fromJson(reader1));
                            continue;
                        }
                        if ("transformations".equals(fieldName)) {
                            List transformations;
                            deserializedMappingDataFlow.transformations = transformations = reader.readArray(reader1 -> Transformation.fromJson(reader1));
                            continue;
                        }
                        if ("script".equals(fieldName)) {
                            deserializedMappingDataFlow.script = reader.getString();
                            continue;
                        }
                        if ("scriptLines".equals(fieldName)) {
                            List scriptLines;
                            deserializedMappingDataFlow.scriptLines = scriptLines = reader.readArray(reader1 -> reader1.getString());
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMappingDataFlow;
        });
    }
}

