/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.ResourceIdentityType;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.UUID;

public final class ManagedIdentity
implements JsonSerializable<ManagedIdentity> {
    private String principalId;
    private UUID tenantId;
    private ResourceIdentityType type;

    public String getPrincipalId() {
        return this.principalId;
    }

    public UUID getTenantId() {
        return this.tenantId;
    }

    public ResourceIdentityType getType() {
        return this.type;
    }

    public ManagedIdentity setType(ResourceIdentityType type) {
        this.type = type;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static ManagedIdentity fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedIdentity)jsonReader.readObject(reader -> {
            ManagedIdentity deserializedManagedIdentity = new ManagedIdentity();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("principalId".equals(fieldName)) {
                    deserializedManagedIdentity.principalId = reader.getString();
                    continue;
                }
                if ("tenantId".equals(fieldName)) {
                    deserializedManagedIdentity.tenantId = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedManagedIdentity.type = ResourceIdentityType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedIdentity;
        });
    }
}

