/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.CustomSetupBase;
import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeCustomSetupScriptProperties;
import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeDataProxyProperties;
import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeEdition;
import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeLicenseType;
import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeSsisCatalogInfo;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class IntegrationRuntimeSsisProperties
implements JsonSerializable<IntegrationRuntimeSsisProperties> {
    private IntegrationRuntimeSsisCatalogInfo catalogInfo;
    private IntegrationRuntimeLicenseType licenseType;
    private IntegrationRuntimeCustomSetupScriptProperties customSetupScriptProperties;
    private IntegrationRuntimeDataProxyProperties dataProxyProperties;
    private IntegrationRuntimeEdition edition;
    private List<CustomSetupBase> expressCustomSetupProperties;
    private Map<String, Object> additionalProperties;

    public IntegrationRuntimeSsisCatalogInfo getCatalogInfo() {
        return this.catalogInfo;
    }

    public IntegrationRuntimeSsisProperties setCatalogInfo(IntegrationRuntimeSsisCatalogInfo catalogInfo) {
        this.catalogInfo = catalogInfo;
        return this;
    }

    public IntegrationRuntimeLicenseType getLicenseType() {
        return this.licenseType;
    }

    public IntegrationRuntimeSsisProperties setLicenseType(IntegrationRuntimeLicenseType licenseType) {
        this.licenseType = licenseType;
        return this;
    }

    public IntegrationRuntimeCustomSetupScriptProperties getCustomSetupScriptProperties() {
        return this.customSetupScriptProperties;
    }

    public IntegrationRuntimeSsisProperties setCustomSetupScriptProperties(IntegrationRuntimeCustomSetupScriptProperties customSetupScriptProperties) {
        this.customSetupScriptProperties = customSetupScriptProperties;
        return this;
    }

    public IntegrationRuntimeDataProxyProperties getDataProxyProperties() {
        return this.dataProxyProperties;
    }

    public IntegrationRuntimeSsisProperties setDataProxyProperties(IntegrationRuntimeDataProxyProperties dataProxyProperties) {
        this.dataProxyProperties = dataProxyProperties;
        return this;
    }

    public IntegrationRuntimeEdition getEdition() {
        return this.edition;
    }

    public IntegrationRuntimeSsisProperties setEdition(IntegrationRuntimeEdition edition) {
        this.edition = edition;
        return this;
    }

    public List<CustomSetupBase> getExpressCustomSetupProperties() {
        return this.expressCustomSetupProperties;
    }

    public IntegrationRuntimeSsisProperties setExpressCustomSetupProperties(List<CustomSetupBase> expressCustomSetupProperties) {
        this.expressCustomSetupProperties = expressCustomSetupProperties;
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public IntegrationRuntimeSsisProperties setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("catalogInfo", (JsonSerializable)this.catalogInfo);
        jsonWriter.writeStringField("licenseType", this.licenseType == null ? null : this.licenseType.toString());
        jsonWriter.writeJsonField("customSetupScriptProperties", (JsonSerializable)this.customSetupScriptProperties);
        jsonWriter.writeJsonField("dataProxyProperties", (JsonSerializable)this.dataProxyProperties);
        jsonWriter.writeStringField("edition", this.edition == null ? null : this.edition.toString());
        jsonWriter.writeArrayField("expressCustomSetupProperties", this.expressCustomSetupProperties, (writer, element) -> writer.writeJson((JsonSerializable)element));
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static IntegrationRuntimeSsisProperties fromJson(JsonReader jsonReader) throws IOException {
        return (IntegrationRuntimeSsisProperties)jsonReader.readObject(reader -> {
            IntegrationRuntimeSsisProperties deserializedIntegrationRuntimeSsisProperties = new IntegrationRuntimeSsisProperties();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("catalogInfo".equals(fieldName)) {
                    deserializedIntegrationRuntimeSsisProperties.catalogInfo = IntegrationRuntimeSsisCatalogInfo.fromJson(reader);
                    continue;
                }
                if ("licenseType".equals(fieldName)) {
                    deserializedIntegrationRuntimeSsisProperties.licenseType = IntegrationRuntimeLicenseType.fromString(reader.getString());
                    continue;
                }
                if ("customSetupScriptProperties".equals(fieldName)) {
                    deserializedIntegrationRuntimeSsisProperties.customSetupScriptProperties = IntegrationRuntimeCustomSetupScriptProperties.fromJson(reader);
                    continue;
                }
                if ("dataProxyProperties".equals(fieldName)) {
                    deserializedIntegrationRuntimeSsisProperties.dataProxyProperties = IntegrationRuntimeDataProxyProperties.fromJson(reader);
                    continue;
                }
                if ("edition".equals(fieldName)) {
                    deserializedIntegrationRuntimeSsisProperties.edition = IntegrationRuntimeEdition.fromString(reader.getString());
                    continue;
                }
                if ("expressCustomSetupProperties".equals(fieldName)) {
                    List expressCustomSetupProperties;
                    deserializedIntegrationRuntimeSsisProperties.expressCustomSetupProperties = expressCustomSetupProperties = reader.readArray(reader1 -> CustomSetupBase.fromJson(reader1));
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedIntegrationRuntimeSsisProperties.additionalProperties = additionalProperties;
            return deserializedIntegrationRuntimeSsisProperties;
        });
    }
}

