/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.DataFlowComputeType;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class IntegrationRuntimeDataFlowProperties
implements JsonSerializable<IntegrationRuntimeDataFlowProperties> {
    private DataFlowComputeType computeType;
    private Integer coreCount;
    private Integer timeToLive;
    private Boolean cleanup;
    private Map<String, Object> additionalProperties;

    public DataFlowComputeType getComputeType() {
        return this.computeType;
    }

    public IntegrationRuntimeDataFlowProperties setComputeType(DataFlowComputeType computeType) {
        this.computeType = computeType;
        return this;
    }

    public Integer getCoreCount() {
        return this.coreCount;
    }

    public IntegrationRuntimeDataFlowProperties setCoreCount(Integer coreCount) {
        this.coreCount = coreCount;
        return this;
    }

    public Integer getTimeToLive() {
        return this.timeToLive;
    }

    public IntegrationRuntimeDataFlowProperties setTimeToLive(Integer timeToLive) {
        this.timeToLive = timeToLive;
        return this;
    }

    public Boolean isCleanup() {
        return this.cleanup;
    }

    public IntegrationRuntimeDataFlowProperties setCleanup(Boolean cleanup) {
        this.cleanup = cleanup;
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public IntegrationRuntimeDataFlowProperties setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("computeType", this.computeType == null ? null : this.computeType.toString());
        jsonWriter.writeNumberField("coreCount", (Number)this.coreCount);
        jsonWriter.writeNumberField("timeToLive", (Number)this.timeToLive);
        jsonWriter.writeBooleanField("cleanup", this.cleanup);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static IntegrationRuntimeDataFlowProperties fromJson(JsonReader jsonReader) throws IOException {
        return (IntegrationRuntimeDataFlowProperties)jsonReader.readObject(reader -> {
            IntegrationRuntimeDataFlowProperties deserializedIntegrationRuntimeDataFlowProperties = new IntegrationRuntimeDataFlowProperties();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("computeType".equals(fieldName)) {
                    deserializedIntegrationRuntimeDataFlowProperties.computeType = DataFlowComputeType.fromString(reader.getString());
                    continue;
                }
                if ("coreCount".equals(fieldName)) {
                    deserializedIntegrationRuntimeDataFlowProperties.coreCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("timeToLive".equals(fieldName)) {
                    deserializedIntegrationRuntimeDataFlowProperties.timeToLive = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("cleanup".equals(fieldName)) {
                    deserializedIntegrationRuntimeDataFlowProperties.cleanup = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedIntegrationRuntimeDataFlowProperties.additionalProperties = additionalProperties;
            return deserializedIntegrationRuntimeDataFlowProperties;
        });
    }
}

