/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.Activity;
import com.azure.analytics.synapse.artifacts.models.ActivityDependency;
import com.azure.analytics.synapse.artifacts.models.ActivityOnInactiveMarkAs;
import com.azure.analytics.synapse.artifacts.models.ActivityState;
import com.azure.analytics.synapse.artifacts.models.ControlActivity;
import com.azure.analytics.synapse.artifacts.models.Expression;
import com.azure.analytics.synapse.artifacts.models.UserProperty;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class IfConditionActivity
extends ControlActivity {
    private String type = "IfCondition";
    private Expression expression;
    private List<Activity> ifTrueActivities;
    private List<Activity> ifFalseActivities;

    @Override
    public String getType() {
        return this.type;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public IfConditionActivity setExpression(Expression expression) {
        this.expression = expression;
        return this;
    }

    public List<Activity> getIfTrueActivities() {
        return this.ifTrueActivities;
    }

    public IfConditionActivity setIfTrueActivities(List<Activity> ifTrueActivities) {
        this.ifTrueActivities = ifTrueActivities;
        return this;
    }

    public List<Activity> getIfFalseActivities() {
        return this.ifFalseActivities;
    }

    public IfConditionActivity setIfFalseActivities(List<Activity> ifFalseActivities) {
        this.ifFalseActivities = ifFalseActivities;
        return this;
    }

    @Override
    public IfConditionActivity setName(String name) {
        super.setName(name);
        return this;
    }

    @Override
    public IfConditionActivity setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public IfConditionActivity setState(ActivityState state) {
        super.setState(state);
        return this;
    }

    @Override
    public IfConditionActivity setOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.setOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    @Override
    public IfConditionActivity setDependsOn(List<ActivityDependency> dependsOn) {
        super.setDependsOn((List)dependsOn);
        return this;
    }

    @Override
    public IfConditionActivity setUserProperties(List<UserProperty> userProperties) {
        super.setUserProperties((List)userProperties);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeStringField("state", this.getState() == null ? null : this.getState().toString());
        jsonWriter.writeStringField("onInactiveMarkAs", this.getOnInactiveMarkAs() == null ? null : this.getOnInactiveMarkAs().toString());
        jsonWriter.writeArrayField("dependsOn", this.getDependsOn(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("userProperties", this.getUserProperties(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("type", this.type);
        if (this.expression != null || this.ifTrueActivities != null || this.ifFalseActivities != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeJsonField("expression", (JsonSerializable)this.expression);
            jsonWriter.writeArrayField("ifTrueActivities", this.ifTrueActivities, (writer, element) -> writer.writeJson((JsonSerializable)element));
            jsonWriter.writeArrayField("ifFalseActivities", this.ifFalseActivities, (writer, element) -> writer.writeJson((JsonSerializable)element));
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static IfConditionActivity fromJson(JsonReader jsonReader) throws IOException {
        return (IfConditionActivity)jsonReader.readObject(reader -> {
            IfConditionActivity deserializedIfConditionActivity = new IfConditionActivity();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedIfConditionActivity.setName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedIfConditionActivity.setDescription(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedIfConditionActivity.setState(ActivityState.fromString(reader.getString()));
                    continue;
                }
                if ("onInactiveMarkAs".equals(fieldName)) {
                    deserializedIfConditionActivity.setOnInactiveMarkAs(ActivityOnInactiveMarkAs.fromString(reader.getString()));
                    continue;
                }
                if ("dependsOn".equals(fieldName)) {
                    List dependsOn = reader.readArray(reader1 -> ActivityDependency.fromJson(reader1));
                    deserializedIfConditionActivity.setDependsOn(dependsOn);
                    continue;
                }
                if ("userProperties".equals(fieldName)) {
                    List userProperties = reader.readArray(reader1 -> UserProperty.fromJson(reader1));
                    deserializedIfConditionActivity.setUserProperties(userProperties);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedIfConditionActivity.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("expression".equals(fieldName)) {
                            deserializedIfConditionActivity.expression = Expression.fromJson(reader);
                            continue;
                        }
                        if ("ifTrueActivities".equals(fieldName)) {
                            List ifTrueActivities;
                            deserializedIfConditionActivity.ifTrueActivities = ifTrueActivities = reader.readArray(reader1 -> Activity.fromJson(reader1));
                            continue;
                        }
                        if ("ifFalseActivities".equals(fieldName)) {
                            List ifFalseActivities;
                            deserializedIfConditionActivity.ifFalseActivities = ifFalseActivities = reader.readArray(reader1 -> Activity.fromJson(reader1));
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedIfConditionActivity.setAdditionalProperties(additionalProperties);
            return deserializedIfConditionActivity;
        });
    }
}

