/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.Dataset;
import com.azure.analytics.synapse.artifacts.models.DatasetCompression;
import com.azure.analytics.synapse.artifacts.models.DatasetFolder;
import com.azure.analytics.synapse.artifacts.models.DatasetStorageFormat;
import com.azure.analytics.synapse.artifacts.models.LinkedServiceReference;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class HttpDataset
extends Dataset {
    private String type = "HttpFile";
    private Object relativeUrl;
    private Object requestMethod;
    private Object requestBody;
    private Object additionalHeaders;
    private DatasetStorageFormat format;
    private DatasetCompression compression;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getRelativeUrl() {
        return this.relativeUrl;
    }

    public HttpDataset setRelativeUrl(Object relativeUrl) {
        this.relativeUrl = relativeUrl;
        return this;
    }

    public Object getRequestMethod() {
        return this.requestMethod;
    }

    public HttpDataset setRequestMethod(Object requestMethod) {
        this.requestMethod = requestMethod;
        return this;
    }

    public Object getRequestBody() {
        return this.requestBody;
    }

    public HttpDataset setRequestBody(Object requestBody) {
        this.requestBody = requestBody;
        return this;
    }

    public Object getAdditionalHeaders() {
        return this.additionalHeaders;
    }

    public HttpDataset setAdditionalHeaders(Object additionalHeaders) {
        this.additionalHeaders = additionalHeaders;
        return this;
    }

    public DatasetStorageFormat getFormat() {
        return this.format;
    }

    public HttpDataset setFormat(DatasetStorageFormat format) {
        this.format = format;
        return this;
    }

    public DatasetCompression getCompression() {
        return this.compression;
    }

    public HttpDataset setCompression(DatasetCompression compression) {
        this.compression = compression;
        return this;
    }

    @Override
    public HttpDataset setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public HttpDataset setStructure(Object structure) {
        super.setStructure(structure);
        return this;
    }

    @Override
    public HttpDataset setSchema(Object schema) {
        super.setSchema(schema);
        return this;
    }

    @Override
    public HttpDataset setLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.setLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public HttpDataset setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public HttpDataset setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public HttpDataset setFolder(DatasetFolder folder) {
        super.setFolder(folder);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.getLinkedServiceName());
        jsonWriter.writeStringField("description", this.getDescription());
        if (this.getStructure() != null) {
            jsonWriter.writeUntypedField("structure", this.getStructure());
        }
        if (this.getSchema() != null) {
            jsonWriter.writeUntypedField("schema", this.getSchema());
        }
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("folder", (JsonSerializable)this.getFolder());
        jsonWriter.writeStringField("type", this.type);
        if (this.relativeUrl != null || this.requestMethod != null || this.requestBody != null || this.additionalHeaders != null || this.format != null || this.compression != null) {
            jsonWriter.writeStartObject("typeProperties");
            if (this.relativeUrl != null) {
                jsonWriter.writeUntypedField("relativeUrl", this.relativeUrl);
            }
            if (this.requestMethod != null) {
                jsonWriter.writeUntypedField("requestMethod", this.requestMethod);
            }
            if (this.requestBody != null) {
                jsonWriter.writeUntypedField("requestBody", this.requestBody);
            }
            if (this.additionalHeaders != null) {
                jsonWriter.writeUntypedField("additionalHeaders", this.additionalHeaders);
            }
            jsonWriter.writeJsonField("format", (JsonSerializable)this.format);
            jsonWriter.writeJsonField("compression", (JsonSerializable)this.compression);
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static HttpDataset fromJson(JsonReader jsonReader) throws IOException {
        return (HttpDataset)jsonReader.readObject(reader -> {
            HttpDataset deserializedHttpDataset = new HttpDataset();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedHttpDataset.setLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedHttpDataset.setDescription(reader.getString());
                    continue;
                }
                if ("structure".equals(fieldName)) {
                    deserializedHttpDataset.setStructure(reader.readUntyped());
                    continue;
                }
                if ("schema".equals(fieldName)) {
                    deserializedHttpDataset.setSchema(reader.readUntyped());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedHttpDataset.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedHttpDataset.setAnnotations(annotations);
                    continue;
                }
                if ("folder".equals(fieldName)) {
                    deserializedHttpDataset.setFolder(DatasetFolder.fromJson(reader));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedHttpDataset.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("relativeUrl".equals(fieldName)) {
                            deserializedHttpDataset.relativeUrl = reader.readUntyped();
                            continue;
                        }
                        if ("requestMethod".equals(fieldName)) {
                            deserializedHttpDataset.requestMethod = reader.readUntyped();
                            continue;
                        }
                        if ("requestBody".equals(fieldName)) {
                            deserializedHttpDataset.requestBody = reader.readUntyped();
                            continue;
                        }
                        if ("additionalHeaders".equals(fieldName)) {
                            deserializedHttpDataset.additionalHeaders = reader.readUntyped();
                            continue;
                        }
                        if ("format".equals(fieldName)) {
                            deserializedHttpDataset.format = DatasetStorageFormat.fromJson(reader);
                            continue;
                        }
                        if ("compression".equals(fieldName)) {
                            deserializedHttpDataset.compression = DatasetCompression.fromJson(reader);
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedHttpDataset.setAdditionalProperties(additionalProperties);
            return deserializedHttpDataset;
        });
    }
}

