/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.ActivityDependency;
import com.azure.analytics.synapse.artifacts.models.ActivityOnInactiveMarkAs;
import com.azure.analytics.synapse.artifacts.models.ActivityPolicy;
import com.azure.analytics.synapse.artifacts.models.ActivityState;
import com.azure.analytics.synapse.artifacts.models.ExecutionActivity;
import com.azure.analytics.synapse.artifacts.models.HDInsightActivityDebugInfoOption;
import com.azure.analytics.synapse.artifacts.models.LinkedServiceReference;
import com.azure.analytics.synapse.artifacts.models.UserProperty;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class HDInsightStreamingActivity
extends ExecutionActivity {
    private String type = "HDInsightStreaming";
    private List<LinkedServiceReference> storageLinkedServices;
    private List<Object> arguments;
    private HDInsightActivityDebugInfoOption getDebugInfo;
    private Object mapper;
    private Object reducer;
    private Object input;
    private Object output;
    private List<Object> filePaths;
    private LinkedServiceReference fileLinkedService;
    private Object combiner;
    private List<Object> commandEnvironment;
    private Map<String, Object> defines;

    @Override
    public String getType() {
        return this.type;
    }

    public List<LinkedServiceReference> getStorageLinkedServices() {
        return this.storageLinkedServices;
    }

    public HDInsightStreamingActivity setStorageLinkedServices(List<LinkedServiceReference> storageLinkedServices) {
        this.storageLinkedServices = storageLinkedServices;
        return this;
    }

    public List<Object> getArguments() {
        return this.arguments;
    }

    public HDInsightStreamingActivity setArguments(List<Object> arguments) {
        this.arguments = arguments;
        return this;
    }

    public HDInsightActivityDebugInfoOption getGetDebugInfo() {
        return this.getDebugInfo;
    }

    public HDInsightStreamingActivity setGetDebugInfo(HDInsightActivityDebugInfoOption getDebugInfo) {
        this.getDebugInfo = getDebugInfo;
        return this;
    }

    public Object getMapper() {
        return this.mapper;
    }

    public HDInsightStreamingActivity setMapper(Object mapper) {
        this.mapper = mapper;
        return this;
    }

    public Object getReducer() {
        return this.reducer;
    }

    public HDInsightStreamingActivity setReducer(Object reducer) {
        this.reducer = reducer;
        return this;
    }

    public Object getInput() {
        return this.input;
    }

    public HDInsightStreamingActivity setInput(Object input) {
        this.input = input;
        return this;
    }

    public Object getOutput() {
        return this.output;
    }

    public HDInsightStreamingActivity setOutput(Object output) {
        this.output = output;
        return this;
    }

    public List<Object> getFilePaths() {
        return this.filePaths;
    }

    public HDInsightStreamingActivity setFilePaths(List<Object> filePaths) {
        this.filePaths = filePaths;
        return this;
    }

    public LinkedServiceReference getFileLinkedService() {
        return this.fileLinkedService;
    }

    public HDInsightStreamingActivity setFileLinkedService(LinkedServiceReference fileLinkedService) {
        this.fileLinkedService = fileLinkedService;
        return this;
    }

    public Object getCombiner() {
        return this.combiner;
    }

    public HDInsightStreamingActivity setCombiner(Object combiner) {
        this.combiner = combiner;
        return this;
    }

    public List<Object> getCommandEnvironment() {
        return this.commandEnvironment;
    }

    public HDInsightStreamingActivity setCommandEnvironment(List<Object> commandEnvironment) {
        this.commandEnvironment = commandEnvironment;
        return this;
    }

    public Map<String, Object> getDefines() {
        return this.defines;
    }

    public HDInsightStreamingActivity setDefines(Map<String, Object> defines) {
        this.defines = defines;
        return this;
    }

    @Override
    public HDInsightStreamingActivity setLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.setLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public HDInsightStreamingActivity setPolicy(ActivityPolicy policy) {
        super.setPolicy(policy);
        return this;
    }

    @Override
    public HDInsightStreamingActivity setName(String name) {
        super.setName(name);
        return this;
    }

    @Override
    public HDInsightStreamingActivity setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public HDInsightStreamingActivity setState(ActivityState state) {
        super.setState(state);
        return this;
    }

    @Override
    public HDInsightStreamingActivity setOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.setOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    @Override
    public HDInsightStreamingActivity setDependsOn(List<ActivityDependency> dependsOn) {
        super.setDependsOn((List)dependsOn);
        return this;
    }

    @Override
    public HDInsightStreamingActivity setUserProperties(List<UserProperty> userProperties) {
        super.setUserProperties((List)userProperties);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeStringField("state", this.getState() == null ? null : this.getState().toString());
        jsonWriter.writeStringField("onInactiveMarkAs", this.getOnInactiveMarkAs() == null ? null : this.getOnInactiveMarkAs().toString());
        jsonWriter.writeArrayField("dependsOn", this.getDependsOn(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("userProperties", this.getUserProperties(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.getLinkedServiceName());
        jsonWriter.writeJsonField("policy", (JsonSerializable)this.getPolicy());
        jsonWriter.writeStringField("type", this.type);
        if (this.storageLinkedServices != null || this.arguments != null || this.getDebugInfo != null || this.mapper != null || this.reducer != null || this.input != null || this.output != null || this.filePaths != null || this.fileLinkedService != null || this.combiner != null || this.commandEnvironment != null || this.defines != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeArrayField("storageLinkedServices", this.storageLinkedServices, (writer, element) -> writer.writeJson((JsonSerializable)element));
            jsonWriter.writeArrayField("arguments", this.arguments, (writer, element) -> writer.writeUntyped(element));
            jsonWriter.writeStringField("getDebugInfo", this.getDebugInfo == null ? null : this.getDebugInfo.toString());
            jsonWriter.writeUntypedField("mapper", this.mapper);
            jsonWriter.writeUntypedField("reducer", this.reducer);
            jsonWriter.writeUntypedField("input", this.input);
            jsonWriter.writeUntypedField("output", this.output);
            jsonWriter.writeArrayField("filePaths", this.filePaths, (writer, element) -> writer.writeUntyped(element));
            jsonWriter.writeJsonField("fileLinkedService", (JsonSerializable)this.fileLinkedService);
            if (this.combiner != null) {
                jsonWriter.writeUntypedField("combiner", this.combiner);
            }
            jsonWriter.writeArrayField("commandEnvironment", this.commandEnvironment, (writer, element) -> writer.writeUntyped(element));
            jsonWriter.writeMapField("defines", this.defines, (writer, element) -> writer.writeUntyped(element));
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static HDInsightStreamingActivity fromJson(JsonReader jsonReader) throws IOException {
        return (HDInsightStreamingActivity)jsonReader.readObject(reader -> {
            HDInsightStreamingActivity deserializedHDInsightStreamingActivity = new HDInsightStreamingActivity();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedHDInsightStreamingActivity.setName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedHDInsightStreamingActivity.setDescription(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedHDInsightStreamingActivity.setState(ActivityState.fromString(reader.getString()));
                    continue;
                }
                if ("onInactiveMarkAs".equals(fieldName)) {
                    deserializedHDInsightStreamingActivity.setOnInactiveMarkAs(ActivityOnInactiveMarkAs.fromString(reader.getString()));
                    continue;
                }
                if ("dependsOn".equals(fieldName)) {
                    List dependsOn = reader.readArray(reader1 -> ActivityDependency.fromJson(reader1));
                    deserializedHDInsightStreamingActivity.setDependsOn(dependsOn);
                    continue;
                }
                if ("userProperties".equals(fieldName)) {
                    List userProperties = reader.readArray(reader1 -> UserProperty.fromJson(reader1));
                    deserializedHDInsightStreamingActivity.setUserProperties(userProperties);
                    continue;
                }
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedHDInsightStreamingActivity.setLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("policy".equals(fieldName)) {
                    deserializedHDInsightStreamingActivity.setPolicy(ActivityPolicy.fromJson(reader));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedHDInsightStreamingActivity.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("storageLinkedServices".equals(fieldName)) {
                            List storageLinkedServices;
                            deserializedHDInsightStreamingActivity.storageLinkedServices = storageLinkedServices = reader.readArray(reader1 -> LinkedServiceReference.fromJson(reader1));
                            continue;
                        }
                        if ("arguments".equals(fieldName)) {
                            List arguments;
                            deserializedHDInsightStreamingActivity.arguments = arguments = reader.readArray(reader1 -> reader1.readUntyped());
                            continue;
                        }
                        if ("getDebugInfo".equals(fieldName)) {
                            deserializedHDInsightStreamingActivity.getDebugInfo = HDInsightActivityDebugInfoOption.fromString(reader.getString());
                            continue;
                        }
                        if ("mapper".equals(fieldName)) {
                            deserializedHDInsightStreamingActivity.mapper = reader.readUntyped();
                            continue;
                        }
                        if ("reducer".equals(fieldName)) {
                            deserializedHDInsightStreamingActivity.reducer = reader.readUntyped();
                            continue;
                        }
                        if ("input".equals(fieldName)) {
                            deserializedHDInsightStreamingActivity.input = reader.readUntyped();
                            continue;
                        }
                        if ("output".equals(fieldName)) {
                            deserializedHDInsightStreamingActivity.output = reader.readUntyped();
                            continue;
                        }
                        if ("filePaths".equals(fieldName)) {
                            List filePaths;
                            deserializedHDInsightStreamingActivity.filePaths = filePaths = reader.readArray(reader1 -> reader1.readUntyped());
                            continue;
                        }
                        if ("fileLinkedService".equals(fieldName)) {
                            deserializedHDInsightStreamingActivity.fileLinkedService = LinkedServiceReference.fromJson(reader);
                            continue;
                        }
                        if ("combiner".equals(fieldName)) {
                            deserializedHDInsightStreamingActivity.combiner = reader.readUntyped();
                            continue;
                        }
                        if ("commandEnvironment".equals(fieldName)) {
                            List commandEnvironment;
                            deserializedHDInsightStreamingActivity.commandEnvironment = commandEnvironment = reader.readArray(reader1 -> reader1.readUntyped());
                            continue;
                        }
                        if ("defines".equals(fieldName)) {
                            Map defines;
                            deserializedHDInsightStreamingActivity.defines = defines = reader.readMap(reader1 -> reader1.readUntyped());
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedHDInsightStreamingActivity.setAdditionalProperties(additionalProperties);
            return deserializedHDInsightStreamingActivity;
        });
    }
}

